@extends('admin.layouts.main')
@section('title')
    {{ __('translations.profits-report') }}
@endsection
@section('sub-title')
    {{ __('translations.financial-reports') }}
@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <div class="card shadow-xl border-0 mb-5 overflow-hidden">
                <div class="card-header bg-gradient-primary text-white py-5">
                    <div class="card-title m-0">
                        <h3 class="fw-bolder m-0 text-white">{{ __('translations.profits-report') }}</h3>
                    </div>
                    <div class="card-toolbar">
                        <a href="{{ route('admin.financial-reports.index') }}" class="btn btn-sm btn-light-primary btn-active-light-primary">
                            <i class="bi bi-arrow-left me-2"></i>{{ __('translations.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body p-5">
                    <!-- Filters Section -->
                    <div class="card bg-light-primary bg-opacity-50 shadow-sm border-0 mb-6">
                        <div class="card-body p-4">
                            <h4 class="mb-4 text-dark fw-bold"><i class="bi bi-funnel-fill me-2"></i>{{ __('translations.filter') }}</h4>
                            <form action="{{ route('admin.financial-reports.profits') }}" method="get">
                                <div class="row g-4">
                                    <div class="col-md-4">
                                        <label class="form-label fw-semibold">{{ __('translations.start-date') }}</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light border-0"><i class="bi bi-calendar3"></i></span>
                                            <input type="date" name="start_date" value="{{ $startDate }}" class="form-control form-control-solid border-0 shadow-none">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label fw-semibold">{{ __('translations.end-date') }}</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light border-0"><i class="bi bi-calendar3"></i></span>
                                            <input type="date" name="end_date" value="{{ $endDate }}" class="form-control form-control-solid border-0 shadow-none">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label">&nbsp;</label>
                                        <div class="d-flex">
                                            <button type="submit" class="btn btn-primary hover-scale w-100">
                                                <i class="bi bi-search me-2"></i>{{ __('translations.filter') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row g-5 g-xl-8 mb-6">
                        <div class="col-xl-3">
                            <div class="card card-xl-stretch mb-xl-8 hover-elevate-up shadow-sm">
                                <div class="card-body p-0">
                                    <div class="d-flex flex-column bg-light-success px-9 py-8 rounded-2">
                                        <div class="d-flex align-items-center mb-2">
                                            <span class="symbol symbol-40px me-3">
                                                <span class="symbol-label bg-success">
                                                    <i class="bi bi-bar-chart-line-fill fs-1 text-white"></i>
                                                </span>
                                            </span>
                                            <div>
                                                <h3 class="text-success fw-bold fs-2 mb-0">{{ number_format($sales, 0) }} {{ __('translations.currency') }}</h3>
                                                <div class="text-gray-700 fw-semibold">{{ __('translations.total-sales') }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3">
                            <div class="card card-xl-stretch mb-xl-8 hover-elevate-up shadow-sm">
                                <div class="card-body p-0">
                                    <div class="d-flex flex-column bg-light-warning px-9 py-8 rounded-2">
                                        <div class="d-flex align-items-center mb-2">
                                            <span class="symbol symbol-40px me-3">
                                                <span class="symbol-label bg-warning">
                                                    <i class="bi bi-arrow-return-left fs-1 text-white"></i>
                                                </span>
                                            </span>
                                            <div>
                                                <h3 class="text-warning fw-bold fs-2 mb-0">{{ number_format($returns ?? 0, 0) }} {{ __('translations.currency') }}</h3>
                                                <div class="text-gray-700 fw-semibold">{{ __('translations.returns') }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3">
                            <div class="card card-xl-stretch mb-xl-8 hover-elevate-up shadow-sm">
                                <div class="card-body p-0">
                                    <div class="d-flex flex-column bg-light-danger px-9 py-8 rounded-2">
                                        <div class="d-flex align-items-center mb-2">
                                            <span class="symbol symbol-40px me-3">
                                                <span class="symbol-label bg-danger">
                                                    <i class="bi bi-cash-stack fs-1 text-white"></i>
                                                </span>
                                            </span>
                                            <div>
                                                <h3 class="text-danger fw-bold fs-2 mb-0">{{ number_format($expenses, 0) }} {{ __('translations.currency') }}</h3>
                                                <div class="text-gray-700 fw-semibold">{{ __('translations.total-expenses') }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3">
                            <div class="card card-xl-stretch mb-xl-8 hover-elevate-up shadow-sm">
                                <div class="card-body p-0">
                                    <div class="d-flex flex-column bg-light-primary px-9 py-8 rounded-2">
                                        <div class="d-flex align-items-center mb-2">
                                            <span class="symbol symbol-40px me-3">
                                                <span class="symbol-label bg-primary">
                                                    <i class="bi bi-graph-up-arrow fs-1 text-white"></i>
                                                </span>
                                            </span>
                                            <div>
                                                <h3 class="text-primary fw-bold fs-2 mb-0">{{ number_format($profit, 0) }} {{ __('translations.currency') }}</h3>
                                                <div class="text-gray-700 fw-semibold">{{ __('translations.net-profit') }}</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Charts Section -->
                    <div class="row g-5 g-xl-8 mb-6">
                        <div class="col-xl-12">
                            <div class="card card-xl-stretch mb-xl-8 shadow-sm hover-elevate-up">
                                <div class="card-header ribbon ribbon-top ribbon-vertical">
                                    <div class="ribbon-label bg-primary">
                                        <i class="bi bi-graph-up-arrow fs-2 text-white"></i>
                                    </div>
                                    <h3 class="card-title align-items-start flex-column">
                                        <span class="card-label fw-bold fs-3 mb-1">{{ __('translations.daily-profits') }}</span>
                                        <span class="text-muted fw-semibold fs-7">{{ __('translations.selected-period') }}</span>
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div id="daily_profits_chart" style="height: 350px"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-5 g-xl-8">
                        <div class="col-xl-12">
                            <div class="card card-xl-stretch mb-xl-8 shadow-sm hover-elevate-up">
                                <div class="card-header ribbon ribbon-top ribbon-vertical">
                                    <div class="ribbon-label bg-success">
                                        <i class="bi bi-graph-up fs-2 text-white"></i>
                                    </div>
                                    <h3 class="card-title align-items-start flex-column">
                                        <span class="card-label fw-bold fs-3 mb-1">{{ __('translations.monthly-profits') }}</span>
                                        <span class="text-muted fw-semibold fs-7">{{ $selectedYear ?? date('Y') }}</span>
                                    </h3>
                                    <div class="card-toolbar">
                                        <form action="{{ route('admin.financial-reports.profits') }}" method="GET" class="d-flex align-items-center">
                                            <select name="year" class="form-select form-select-sm" onchange="this.form.submit()">
                                                @for($year = date('Y') + 5; $year >= date('Y') - 5; $year--)
                                                    <option value="{{ $year }}" {{ ($selectedYear ?? date('Y')) == $year ? 'selected' : '' }}>{{ $year }}</option>
                                                @endfor
                                            </select>
                                        </form>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div id="monthly_profits_chart" style="height: 350px"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Profit Analysis -->
                    <div class="card shadow-sm border-0 mt-5 hover-elevate-up">
                        <div class="card-header py-3 border-0 bg-light">
                            <div class="card-title">
                                <h3 class="card-label fw-bold"><i class="bi bi-clipboard-data me-2 text-primary"></i>{{ __('translations.profit-analysis') }}</h3>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover table-rounded gs-7">
                                    <thead>
                                        <tr class="fw-bold text-gray-800 border-bottom border-gray-200 bg-light-primary bg-opacity-50">
                                            <th>{{ __('translations.metric') }}</th>
                                            <th>{{ __('translations.value') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.total-sales') }}</td>
                                            <td class="fw-bold fs-6">{{ number_format($sales, 0) }} {{ __('translations.currency') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.returns') }}</td>
                                            <td class="fw-bold fs-6">{{ number_format($returns ?? 0, 0) }} {{ __('translations.currency') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.net-sales') }}</td>
                                            <td class="fw-bold fs-6">{{ number_format($sales - ($returns ?? 0), 0) }} {{ __('translations.currency') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.total-expenses') }}</td>
                                            <td class="fw-bold fs-6">{{ number_format($expenses, 0) }} {{ __('translations.currency') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.net-profit') }}</td>
                                            <td class="fw-bold fs-6">{{ number_format($profit, 0) }} {{ __('translations.currency') }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.profit-margin') }}</td>
                                            <td class="fw-bold fs-6">{{ ($sales - ($returns ?? 0)) > 0 ? number_format((($profit) / ($sales - ($returns ?? 0))) * 100, 2) : 0 }}%</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">{{ __('translations.expense-ratio') }}</td>
                                            <td class="fw-bold fs-6">{{ ($sales - ($returns ?? 0)) > 0 ? number_format(($expenses / ($sales - ($returns ?? 0))) * 100, 2) : 0 }}%</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        // Check if data is empty
        var dailyDataIsEmpty = true;
        var monthlyDataIsEmpty = true;

        @if(isset($dailyProfits) && isset($dailyProfits['data']) && is_array($dailyProfits['data']))
            dailyDataIsEmpty = @json($dailyProfits['data']).length === 0 || !@json($dailyProfits['data']).some(function(value) { return value > 0; });
        @endif

        @if(isset($monthlyProfits) && isset($monthlyProfits['data']) && is_array($monthlyProfits['data']))
            monthlyDataIsEmpty = @json($monthlyProfits['data']).length === 0 || !@json($monthlyProfits['data']).some(function(value) { return value > 0; });
        @endif

        console.log('Daily profits data is empty:', dailyDataIsEmpty);
        console.log('Monthly profits data is empty:', monthlyDataIsEmpty);

        // Daily Profits Chart
        if (!dailyDataIsEmpty) {
            var dailyOptions = {
                series: [{
                    name: '{{ __("translations.profits") }}',
                    data: @json($dailyProfits['data'])
                }],
                chart: {
                    fontFamily: 'Tajawal, sans-serif',
                    type: 'bar',
                    height: 350,
                    toolbar: {
                        show: false
                    },
                    animations: {
                        enabled: true,
                        easing: 'easeinout',
                        speed: 800,
                        animateGradually: {
                            enabled: true,
                            delay: 150
                        },
                        dynamicAnimation: {
                            enabled: true,
                            speed: 350
                        }
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '55%',
                        borderRadius: 5,
                        endingShape: 'rounded'
                    },
                },
                colors: ['#28a745'],
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: @json($dailyProfits['labels']),
                    labels: {
                        style: {
                            fontSize: '12px',
                            fontWeight: 500
                        }
                    }
                },
                yaxis: {
                    labels: {
                        formatter: function(val) {
                            return val.toLocaleString()
                        },
                        style: {
                            fontSize: '12px',
                            fontWeight: 500
                        }
                    }
                },
                fill: {
                    opacity: 1,
                    type: 'gradient',
                    gradient: {
                        shade: 'light',
                        type: "vertical",
                        shadeIntensity: 0.2,
                        gradientToColors: undefined,
                        inverseColors: false,
                        opacityFrom: 0.85,
                        opacityTo: 0.85,
                        stops: [0, 100]
                    },
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return val.toLocaleString() + ' {{ __("translations.currency") }}'
                        }
                    }
                }
            };

            var dailyChart = new ApexCharts(document.querySelector("#daily_profits_chart"), dailyOptions);
            dailyChart.render();
        } else {
            document.querySelector("#daily_profits_chart").innerHTML = '<div class="d-flex justify-content-center align-items-center h-100"><span class="text-muted fs-3">{{ __("translations.no-profits-data") }}</span></div>';
        }

        // Monthly Profits Chart
        if (!monthlyDataIsEmpty) {
            var monthlyOptions = {
                series: [{
                    name: '{{ __("translations.profits") }}',
                    data: @json($monthlyProfits['data'])
                }],
                chart: {
                    fontFamily: 'Tajawal, sans-serif',
                    type: 'line',
                    height: 350,
                    toolbar: {
                        show: false
                    },
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 18,
                        left: 7,
                        blur: 10,
                        opacity: 0.1
                    },
                    animations: {
                        enabled: true,
                        easing: 'easeinout',
                        speed: 800,
                        animateGradually: {
                            enabled: true,
                            delay: 150
                        },
                        dynamicAnimation: {
                            enabled: true,
                            speed: 350
                        }
                    }
                },
                colors: ['#01d9cc'],
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    width: 3,
                    curve: 'smooth'
                },
                markers: {
                    size: 5,
                    strokeWidth: 0,
                    hover: {
                        size: 7
                    }
                },
                xaxis: {
                    categories: @json($monthlyProfits['labels']),
                    labels: {
                        style: {
                            fontSize: '12px',
                            fontWeight: 500
                        }
                    }
                },
                yaxis: {
                    labels: {
                        formatter: function(val) {
                            return val.toLocaleString()
                        },
                        style: {
                            fontSize: '12px',
                            fontWeight: 500
                        }
                    }
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return val.toLocaleString() + ' {{ __("translations.currency") }}'
                        }
                    }
                }
            };

            var monthlyChart = new ApexCharts(document.querySelector("#monthly_profits_chart"), monthlyOptions);
            monthlyChart.render();
        } else {
            document.querySelector("#monthly_profits_chart").innerHTML = '<div class="d-flex justify-content-center align-items-center h-100"><span class="text-muted fs-3">{{ __("translations.no-profits-data") }}</span></div>';
        }
    });
</script>
<style>
    .hover-elevate-up {
        transition: transform 0.3s ease;
    }
    .hover-elevate-up:hover {
        transform: translateY(-5px);
    }
    .hover-scale {
        transition: transform 0.3s ease;
    }
    .hover-scale:hover {
        transform: scale(1.05);
    }
</style>
@endsection
