@extends('admin.layouts.main')
@section('title')
    {{ __('translations.top-products-report') }}
@endsection
@section('sub-title')
    {{ __('translations.financial-reports') }}
@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <div class="card shadow-xl border-0 mb-5 overflow-hidden">
                <div class="card-header bg-gradient-primary text-white py-5">
                    <div class="card-title m-0">
                        <h3 class="fw-bolder m-0 text-white">{{ __('translations.top-products-report') }}</h3>
                    </div>
                    <div class="card-toolbar">
                        <a href="{{ route('admin.financial-reports.index') }}" class="btn btn-sm btn-light-primary btn-active-light-primary">
                            <i class="bi bi-arrow-left me-2"></i>{{ __('translations.back') }}
                        </a>
                    </div>
                </div>
                <div class="card-body p-5">
                    <!-- Filters Section -->
                    <div class="card bg-light-primary bg-opacity-50 shadow-sm border-0 mb-6">
                        <div class="card-body p-4">
                            <h4 class="mb-4 text-dark fw-bold"><i class="bi bi-funnel-fill me-2"></i>{{ __('translations.filter') }}</h4>
                            <form action="{{ route('admin.financial-reports.top-products') }}" method="get">
                                <div class="row g-4">
                                    <div class="col-md-3">
                                        <label class="form-label fw-semibold">{{ __('translations.category') }}</label>
                                        <select name="category_id" class="form-select form-select-solid border-0 shadow-none">
                                            <option value="">{{ __('translations.all-categories') }}</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                                                    {{ $category->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label fw-semibold">{{ __('translations.sort-by') }}</label>
                                        <select name="order_by" class="form-select form-select-solid border-0 shadow-none">
                                            <option value="total_quantity" {{ request('order_by', 'total_quantity') == 'total_quantity' ? 'selected' : '' }}>
                                                {{ __('translations.quantity-sold') }}
                                            </option>
                                            <option value="total_sales" {{ request('order_by') == 'total_sales' ? 'selected' : '' }}>
                                                {{ __('translations.sales-amount') }}
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label fw-semibold">{{ __('translations.start-date') }}</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light border-0"><i class="bi bi-calendar3"></i></span>
                                            <input type="date" name="start_date" value="{{ $startDate }}" class="form-control form-control-solid border-0 shadow-none">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label fw-semibold">{{ __('translations.end-date') }}</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light border-0"><i class="bi bi-calendar3"></i></span>
                                            <input type="date" name="end_date" value="{{ $endDate }}" class="form-control form-control-solid border-0 shadow-none">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="d-flex justify-content-end gap-3">
                                            <button type="submit" class="btn btn-primary hover-scale">
                                                <i class="bi bi-search me-2"></i>{{ __('translations.filter') }}
                                            </button>
                                            <a href="{{ route('admin.financial-reports.top-products') }}" class="btn btn-secondary">
                                                <i class="bi bi-x-circle me-2"></i>{{ __('translations.reset') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Charts Section -->
                    <div class="row g-5 g-xl-8 mb-6">
                        <div class="col-xl-12">
                            <div class="card card-xl-stretch mb-xl-8 shadow-sm hover-elevate-up">
                                <div class="card-header ribbon ribbon-top ribbon-vertical">
                                    <div class="ribbon-label bg-primary">
                                        <i class="bi bi-pie-chart-fill fs-2 text-white"></i>
                                    </div>
                                    <h3 class="card-title align-items-start flex-column">
                                        <span class="card-label fw-bold fs-3 mb-1">{{ __('translations.sales-by-category') }}</span>
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div id="sales_category_chart" style="height: 350px"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Top Products Table -->
                    <div class="card shadow-sm border-0 hover-elevate-up">
                        <div class="card-header py-3 border-0 bg-light">
                            <div class="card-title">
                                <h3 class="card-label fw-bold"><i class="bi bi-tag-fill me-2 text-primary"></i>{{ __('translations.top-selling-products') }}</h3>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover table-rounded gs-7">
                                    <thead>
                                        <tr class="fw-bold text-gray-800 border-bottom border-gray-200 bg-light-primary bg-opacity-50">
                                            <th class="text-center">#</th>
                                            <th>{{ __('translations.product') }}</th>
                                            <th>{{ __('translations.category') }}</th>
                                            <th class="text-center">{{ __('translations.quantity-sold') }}</th>
                                            <th>{{ __('translations.total-sales') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($topProducts as $index => $product)
                                            <tr>
                                                <td class="text-center fw-bold">{{ $index + 1 }}</td>
                                                <td class="fw-semibold">{{ $product->product->name ?? 'N/A' }}</td>
                                                <td>{{ $product->product->category->name ?? 'N/A' }}</td>
                                                <td class="text-center fw-bold">{{ $product->total_quantity }}</td>
                                                <td class="fw-bold fs-6">{{ number_format($product->total_sales, 0) }} {{ __('translations.currency') }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center py-5">
                                                    <div class="d-flex flex-column align-items-center">
                                                        <i class="bi bi-exclamation-circle text-muted fs-2"></i>
                                                        <span class="text-muted mt-2">{{ __('translations.no-products-found') }}</span>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            <div class="px-5 py-4">
                                {{ $topProducts->withQueryString()->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        // Category Sales Chart
        var categoryData = @json($salesByCategory);

        if (categoryData && categoryData.length > 0) {
            var labels = categoryData.map(function(item) { return item.name; });
            var data = categoryData.map(function(item) { return parseFloat(item.total_sales); });

            var categoryOptions = {
                series: data,
                chart: {
                    fontFamily: 'Tajawal, sans-serif',
                    type: 'donut',
                    height: 350,
                    toolbar: {
                        show: false
                    },
                    animations: {
                        enabled: true,
                        easing: 'easeinout',
                        speed: 1000,
                        animateGradually: {
                            enabled: true,
                            delay: 100
                        },
                        dynamicAnimation: {
                            enabled: true,
                            speed: 450
                        }
                    },
                    dropShadow: {
                        enabled: true,
                        color: '#111',
                        top: 3,
                        left: 3,
                        blur: 5,
                        opacity: 0.2
                    }
                },
                labels: labels,
                colors: ['#3498db', '#2ecc71', '#9b59b6', '#f1c40f', '#e74c3c', '#1abc9c', '#34495e', '#fd7e14'],
                fill: {
                    type: 'gradient',
                    gradient: {
                        shade: 'dark',
                        type: 'horizontal',
                        shadeIntensity: 0.5,
                        opacityFrom: 1,
                        opacityTo: 0.8,
                        stops: [0, 100]
                    }
                },
                legend: {
                    position: 'bottom',
                    fontSize: '14px',
                    fontWeight: 600,
                    markers: {
                        width: 12,
                        height: 12,
                        radius: 6,
                        strokeWidth: 0
                    },
                    itemMargin: {
                        horizontal: 10,
                        vertical: 5
                    }
                },
                plotOptions: {
                    pie: {
                        startAngle: 0,
                        endAngle: 360,
                        expandOnClick: true,
                        offsetX: 0,
                        offsetY: 0,
                        customScale: 1,
                        dataLabels: {
                            offset: -5
                        },
                        donut: {
                            size: '60%',
                            background: 'transparent',
                            labels: {
                                show: true,
                                name: {
                                    show: true,
                                    fontSize: '16px',
                                    fontWeight: 'bold',
                                    offsetY: -10
                                },
                                value: {
                                    show: true,
                                    fontSize: '20px',
                                    fontWeight: 'bold',
                                    offsetY: 5,
                                    formatter: function (val) {
                                        return val.toLocaleString() + ' {{ __("translations.currency") }}';
                                    }
                                },
                                total: {
                                    show: true,
                                    showAlways: true,
                                    label: '{{ __("translations.total") }}',
                                    fontSize: '20px',
                                    fontWeight: 'bold',
                                    formatter: function (w) {
                                        return w.globals.seriesTotals.reduce(function(a, b) { return a + b; }, 0).toLocaleString() + ' {{ __("translations.currency") }}';
                                    }
                                }
                            }
                        }
                    }
                },
                dataLabels: {
                    enabled: true,
                    formatter: function (val, opts) {
                        return Math.round(val) + '%';
                    },
                    textAnchor: 'middle',
                    distributed: false,
                    offsetX: 0,
                    offsetY: 0,
                    style: {
                        fontSize: '13px',
                        fontWeight: 'bold',
                        colors: ['#fff']
                    },
                    dropShadow: {
                        enabled: true,
                        color: '#000',
                        top: 1,
                        left: 1,
                        blur: 3,
                        opacity: 0.3
                    }
                },
                stroke: {
                    width: 2,
                    colors: ['#fff']
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 300
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }],
                tooltip: {
                    theme: 'dark',
                    style: {
                        fontSize: '14px'
                    },
                    y: {
                        formatter: function (val) {
                            return val.toLocaleString() + ' {{ __("translations.currency") }}'
                        }
                    }
                }
            };

            var categoryChart = new ApexCharts(document.querySelector("#sales_category_chart"), categoryOptions);
            categoryChart.render();
        } else {
            $("#sales_category_chart").html('<div class="d-flex justify-content-center align-items-center h-100"><span class="text-muted fs-3">{{ __("translations.no-category-data") }}</span></div>');
        }
    });
</script>
<style>
    .hover-elevate-up {
        transition: transform 0.3s ease;
    }
    .hover-elevate-up:hover {
        transform: translateY(-5px);
    }
    .hover-scale {
        transition: transform 0.3s ease;
    }
    .hover-scale:hover {
        transform: scale(1.05);
    }
</style>
@endsection
