@extends('admin.layouts.main')
@section('title'){{ __('translations.invoices-show') }}@endsection
@section('sub-title'){{ __('translations.invoices') }}@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
  <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card card-docs mb-2 shadow">
            <div class="card-header bg-primary text-white">
              <div class="card-title m-0">
                <h3 class="fw-bolder m-0 text-white">{{ __('translations.invoices-show') }}</h3>
              </div>
            </div>
            <div class="card-body">
              <!-- Action buttons at top -->
              <div class="d-flex justify-content-end mb-4">
                <button type="button" id="print-button" class="btn btn-light-primary me-2">
                  <i class="fa fa-print me-1"></i> {{ __('translations.print') }}
                </button>
                @if($invoice->sent_to_invotek == 0)
                <form action="{{ route('admin.invoices.resend-invoice', $invoice->id) }}" method="POST" class="d-inline">
                  @csrf
                  <button type="submit" class="btn btn-light-warning me-2">
                    <i class="fa fa-paper-plane me-1"></i> {{ __('translations.resend') }}
                  </button>
                </form>
                @endif
                @if($invoice->sent_to_invotek == 1)
                <button type="button" data-bs-toggle="modal" data-bs-target="#returnInvoiceModal" class="btn btn-light-danger">
                  <i class="fa fa-undo me-1"></i> {{ __('translations.return') }}
                </button>
                @endif
              </div>

              <!-- Invoice Document -->
              <div class="invoice-container bg-white p-5 border rounded shadow-sm mb-5 printable-area">
                <!-- Invoice Status Badge -->
                <div class="position-absolute top-0 end-0 m-4">
                  @if($invoice->status == 'paid')
                    <div class="badge bg-success fs-6 p-2 shadow-sm">{{ __('translations.paid') }}</div>
                  @elseif($invoice->status == 'pending')
                    <div class="badge bg-warning fs-6 p-2 shadow-sm">{{ __('translations.pending') }}</div>
                  @elseif($invoice->status == 'cancelled')
                    <div class="badge bg-danger fs-6 p-2 shadow-sm">{{ __('translations.cancelled') }}</div>
                  @endif
                </div>

                <!-- Invoice Header Section with Logo and Company Info -->
                <div class="row mb-5">
                  <div class="col-md-6">
                    <div class="d-flex align-items-center mb-4">
                      @if(isset($setting) && isset($setting->logo))
                        <img src="{{ asset($setting->logo) }}" alt="Company Logo" class="img-fluid me-3" style="max-height: 80px;">
                      @else
                        <img src="{{ asset('logo.png') }}" alt="Company Logo" class="img-fluid me-3" style="max-height: 80px;">
                      @endif
                      <div>
                        @if(isset($setting) && isset($setting->translate(app()->getLocale())->name))
                          <h3 class="fw-bold mb-1">{{ $setting->translate(app()->getLocale())->name }}</h3>
                        @endif
                        @if(isset($setting) && isset($setting->translate(app()->getLocale())->address))
                          <p class="text-muted mb-0"><i class="fas fa-map-marker-alt me-1"></i> {{ $setting->translate(app()->getLocale())->address }}</p>
                        @endif
                        @if(isset($setting) && isset($setting->phone1))
                          <p class="text-muted mb-0"><i class="fas fa-phone me-1"></i> {{ $setting->phone1 }}</p>
                        @endif
                        @if(isset($setting) && isset($setting->email))
                          <p class="text-muted mb-0"><i class="fas fa-envelope me-1"></i> {{ $setting->email }}</p>
                        @endif
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6 text-md-end">
                    <h1 class="display-4 fw-bold text-primary mb-0">{{ __('translations.invoice') }}</h1>
                    <div class="badge bg-primary text-white fs-6 mt-2">#{{ $invoice->number }}</div>
                    <p class="text-muted mt-2"><i class="far fa-calendar-alt me-1"></i> {{ date('d M, Y', strtotime($invoice->issue_date)) }}</p>
                  </div>
                </div>

                <!-- QR Code and Client Info -->
                <div class="row mb-5">
                  <div class="col-md-7">
                    <div class="bg-light p-4 rounded">
                      <h5 class="fw-bold text-primary">{{ __('translations.invoice-to') }}:</h5>
                      <h5 class="mb-1">{{ $invoice->client->first_name }} {{ $invoice->client->last_name }}</h5>
                      @if($invoice->client->company_name)
                        <p class="text-muted mb-1">{{ $invoice->client->company_name }}</p>
                      @endif
                      @if($invoice->client->address)
                        <p class="text-muted mb-1"><i class="fas fa-map-marker-alt me-1"></i> {{ $invoice->client->address }}</p>
                      @endif
                      @if($invoice->client->email)
                        <p class="text-muted mb-1"><i class="fas fa-envelope me-1"></i> {{ $invoice->client->email }}</p>
                      @endif
                      @if($invoice->client->phone)
                        <p class="text-muted mb-0"><i class="fas fa-phone me-1"></i> {{ $invoice->client->phone }}</p>
                      @endif
                    </div>
                  </div>
                  <div class="col-md-5 d-flex justify-content-center align-items-center">
                    <!-- QR Code -->
                    <div class="text-center">
                        @if($invoice->einv_qr)
                      <div class="mb-2">
                        {!! QrCode::format('svg')->encoding('UTF-8')->errorCorrection('H')->size(200)->generate($invoice->einv_qr) !!}
                      </div>
                      <p class="text-muted">{{ __('translations.scan-to-view') }}</p>
                      @endif
                    </div>
                  </div>
                </div>

                <!-- Invoice Details Section -->
                <div class="row mb-5">
                  <div class="col-md-12">
                    <div class="table-responsive">
                      <table class="table table-rounded table-striped border gy-7 gs-7">
                        <thead>
                          <tr class="fw-bold fs-6 text-gray-800 border-bottom bg-light">
                            <th>{{ __('translations.product') }}</th>
                            <th>{{ __('translations.price') }}</th>
                            <th>{{ __('translations.quantity') }}</th>
                            <th>{{ __('translations.total') }}</th>
                            <th>{{ __('translations.discount') }}</th>
                            <th>{{ __('translations.total after discount') }}</th>
                          </tr>
                        </thead>
                        <tbody>
                          @if($invoice->details && is_iterable($invoice->details))
                          @php
                          $discount = 0;
                          $subtotal = 0;
                          @endphp
                            @foreach($invoice->details as $item)
                              <tr>
                                <td>
                                  <div class="d-flex align-items-center">
                                    <div>
                                      <span class="fw-bold">{{ $item->name }}</span>
                                    </div>
                                  </div>
                                </td>
                                <td>{{ number_format($item->price, 0) }} {{ __('translations.currency') }}</td>
                                <td>{{ $item->quantity }}</td>
                                <td>{{ number_format($item->total + $item->discount, 0) }} {{ __('translations.currency') }}</td>
                                <td>{{ number_format($item->discount, 0) }} {{ __('translations.currency') }}</td>
                                <td>{{ number_format($item->total, 0) }} {{ __('translations.currency') }}</td>
                              </tr>
                              @php
                              $discount += $item->discount;
                              $subtotal += $item->total;
                              @endphp
                            @endforeach
                          @else
                            <tr>
                              <td colspan="5" class="text-center">{{ __('translations.no-items-found') }}</td>
                            </tr>
                          @endif
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>

                <!-- Invoice Totals Section -->
                <div class="row mb-5">
                  <div class="col-md-8">
                    <!-- Payment Information -->
                    <div class="bg-light p-4 rounded">
                      <h5 class="fw-bold text-primary mb-3">{{ __('translations.payment-info') }}</h5>
                      <div class="mb-2">
                        <span class="fw-bold">{{ __('translations.payment-date') }}:</span>
                        <span class="ms-2">{{ date('d M, Y', strtotime($invoice->issue_date)) }}</span>
                      </div>
                      <div class="mb-0">
                        <span class="fw-bold">{{ __('translations.payment-method') }}:</span>
                        <span class="ms-2">
                          @if($invoice->payment_method_code == '011')
                            <span class="badge bg-success">{{ __('translations.cash') }}</span>
                         @else
                          <span class="badge bg-warning">{{ __('translations.credit') }}</span>
                          @endif
                        </span>
                      </div>
                      <div class="mb-0">
                        <span class="fw-bold">{{ __('translations.sent-to-invotek') }}:</span>
                        <span class="ms-2">
                            @if($invoice->sent_to_invotek == 1 )
                              <span class="badge bg-success">{{ __('translations.sent to invotek') }}</span>
                           @elseif($invoice->sent_to_invotek == 2)
                            <span class="badge bg-danger">{{ __('translations.returned') }}</span>
                            @elseif($invoice->sent_to_invotek == 0)
                            <span class="badge bg-warning">{{ __('translations.not sent to invotek') }}</span>
                            @endif
                          </span>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="bg-light p-4 rounded shadow-sm">
                      <div class="d-flex justify-content-between mb-3">
                        <span class="fw-bold">{{ __('translations.subtotal') }}:</span>
                        <div>
                          <span class="fs-5">{{ number_format($subtotal - $discount ?? 0, 2) }}</span>
                          <span class="ms-1">{{ __('translations.currency') }}</span>
                        </div>
                      </div>
                      <div class="d-flex justify-content-between mb-3">
                        <span class="fw-bold">{{ __('translations.total-discount') }}:</span>
                        <div>
                          <span class="fs-5">{{ number_format($discount ?? 0, 2) }}</span>
                          <span class="ms-1">{{ __('translations.currency') }}</span>
                        </div>
                      </div>
                      <div class="d-flex justify-content-between pt-2 border-top mt-2">
                        <span class="fw-bold fs-5">{{ __('translations.total') }}:</span>
                        <div>
                          <span class="fs-4 fw-bold text-primary">{{ number_format($invoice->total_price, 2) }}</span>
                          <span class="ms-1">{{ __('translations.currency') }}</span>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <!-- Thank You Note -->
                <div class="row mt-4">
                  <div class="col-md-12 text-center">
                    <p class="fs-5 fw-bold text-primary">{{ __('translations.thank-you') }}</p>
                  </div>
                </div>
              </div>

              <!-- Form Actions -->
              <div class="d-flex justify-content-between align-items-center">
                <a href="{{ route('admin.invoices.index') }}" class="btn btn-secondary">
                  <i class="fa fa-arrow-left me-1" aria-hidden="true"></i> {{ __('translations.back') }}
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Return Invoice Modal -->
<div class="modal fade" id="returnInvoiceModal" tabindex="-1" aria-labelledby="returnInvoiceModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-light">
        <h5 class="modal-title" id="returnInvoiceModalLabel">{{ __('translations.return-invoice') }}</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form action="{{ route('admin.invoices.return-invoice', $invoice->id) }}" method="POST" id="returnInvoiceForm">
          @csrf
          <p>{{ __('translations.confirm-return-invoice') }}</p>
          <div class="mb-3">
            <label class="form-label">{{ __('translations.reason') }} <span class="text-danger">*</span></label>
            <textarea class="form-control" name="return_reason" rows="3" required></textarea>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('translations.close') }}</button>
        <button type="submit" form="returnInvoiceForm" class="btn btn-danger">
          <i class="fa fa-undo me-1"></i> {{ __('translations.return') }}
        </button>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const printButton = document.getElementById('print-button');

    // Print button click handler
    printButton.addEventListener('click', function() {
      window.print();
    });
  });
</script>

<style>
  @media print {
    body * {
      visibility: hidden;
    }
    .printable-area, .printable-area * {
      visibility: visible;
    }
    .printable-area {
      position: absolute;
      left: 0;
      top: 0;
      width: 100%;
    }
    .card-header, .card-body > div:first-child, .card-body > div:last-child {
      display: none !important;
    }
  }
</style>
@endsection
