@extends('admin.layouts.main')
@section('title'){{ __('translations.products-create') }}@endsection
@section('sub-title'){{ __('translations.products') }}@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
  <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card card-docs mb-2">
            <div class="card-header">
              <div class="card-title m-0">
                <h3 class="fw-bolder m-0">{{ __('translations.products-create') }}</h3>
              </div>
            </div>
            <div class="card-body">
              <form action="{{route('admin.products.store')}}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-name')}} <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="name" required/>
                    @error('name')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-price')}} <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="price" required/>
                    @error('price')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-description')}} <span class="text-danger">*</span></label>
                    <textarea class="form-control" name="description" required></textarea>
                    @error('description')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>

                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-category')}} <span class="text-danger">*</span></label>
                    <select class="form-control" name="category_id" required>
                      @foreach($categories as $category)
                        <option value="{{$category->id}}">{{$category->name}}</option>
                      @endforeach
                    </select>
                    @error('category_id')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-image')}} <span class="text-danger">*</span></label>
                    <input type="file" class="form-control" name="image" required/>
                    @error('image')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>

                </div>
                <div class="d-flex pt-5 justify-content-between align-items-center">
                    <a href="{{route('admin.products.index')}}" class="btn btn-secondary">
                    {{__('translations.back')}} <i class="fa fa-undo" aria-hidden="true"></i>
                  </a>
                  <button type="submit" class="btn btn-primary">
                    {{__('translations.create')}} <i class="fa fa-check" aria-hidden="true"></i>
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
