@extends('admin.layouts.main')
@section('title'){{ __('translations.products-show') }}@endsection
@section('sub-title'){{ __('translations.products') }}@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
  <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card card-docs mb-2">
            <div class="card-header">
              <div class="card-title m-0">
                <h3 class="fw-bolder m-0">{{ __('translations.products-show') }}</h3>
              </div>
            </div>
            <div class="card-body">

                <div class="text-center mb-5">
                  <img src="{{asset('uploads/'.$product->image)}}" alt="{{$product->name}}" class="img-fluid img-thumbnail" style="width: 150px; height: 150px;">
                </div>

                <div class="row">
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-name')}} <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="name" value="{{$product->name}}" disabled/>
                    @error('name')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-price')}} <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="price" value="{{$product->price}}" disabled/>
                    @error('price')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-description')}} <span class="text-danger">*</span></label>
                    <textarea class="form-control" name="description" disabled>{{$product->description}}</textarea>
                    @error('description')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>

                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.products-category')}} <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="category" value="{{$product->category->name}}" disabled/>
                    @error('category')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>

                </div>
                <div class="d-flex pt-5 justify-content-center align-items-center">

                  <a href="{{route('admin.products.index')}}" class="btn btn-secondary">
                    {{__('translations.back')}} <i class="fa fa-undo" aria-hidden="true"></i>
                  </a>
                </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
