@extends('admin.layouts.main')
@section('title')
    {{ __('translations.edit-profile') }}
@endsection
@section('sub-title')
    {{ __('translations.dashboard') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-md-3">
                        <div class="card card-docs mb-2">
                            <div class="card-body">
                                <ul class="list-group list-group-unbordered">
                                    <li class="list-group-item w3-display-container">
                                        <form action="{{ route('admin.profile.picture.update') }}" method="post"
                                            enctype="multipart/form-data">
                                            @csrf
                                            @method('PUT')
                                            <input type="file" name="picture" accept="image/*" required>
                                            <a
                                                class="{{ app()->getLocale() == 'en' ? 'w3-display-right' : 'w3-display-left' }}">
                                                <button
                                                    class="btn btn-primary btn-sm">{{ __('translations.upload') }}</button>
                                            </a>
                                        </form>
                                    </li>
                                </ul>
                                <hr>
                                <div style="padding-right: 10px">
                                    <strong><i class="fa fa-book margin-r-4"></i>
                                        {{ __('translations.users-name') }}</strong>
                                    <p class="text-muted">{{ $user->name }}</p>
                                    <hr>
                                    <strong><i class="fa fa-envelope margin-r-4"></i>
                                        {{ __('translations.users-email') }}</strong>
                                    <p class="text-muted">{{ $user->email }}</p>
                                    <hr>
                                    <strong><i class="fa fa-phone-square margin-r-4"></i>
                                        {{ __('translations.users-phone') }}</strong>
                                    <p class="text-muted">{{ $user->phone }}</p>
                                    <hr>
                                    <strong><i class="fa fa-map margin-r-4"></i>
                                        {{ __('translations.users-address') }}</strong>
                                    <p class="text-muted">{{ $user->address ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-9">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.personal-info') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.profile.update') }}" method="post">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-name') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="name"
                                                value="{{ $user->name }}" required />
                                            @error('name')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-email') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="email" class="form-control" name="email"
                                                value="{{ $user->email }}" required />
                                            @error('email')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-phone') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="phone"
                                                value="{{ $user->phone }}" required />
                                            @error('phone')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-address') }}</label>
                                            <input type="text" class="form-control" name="address"
                                                value="{{ $user->address }}" />
                                            @error('address')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="d-flex pt-5 justify-content-between align-items-center">
                                        <a href="{{ route('admin.index') }}" class="btn btn-secondary">
                                            {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('translations.submit') }} <i class="fa fa-check" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>


                    <div class="col-3">
                    </div>
                    <div class="col-9">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.change-password') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.profile.password.update') }}" method="post">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <!-- Old Password Field -->
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.old-password') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="password" class="form-control" name="old_password" required />
                                            @error('old_password')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- New Password Field -->
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.new-password') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="password" class="form-control" name="password" required />
                                            @error('password')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- Confirm Password Field -->
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.confirm-password') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="password" class="form-control" name="password_confirmation"
                                                required />
                                            @error('password_confirmation')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="d-flex pt-5 justify-content-between align-items-center">
                                        <a href="{{ route('admin.index') }}" class="btn btn-secondary">
                                            {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('translations.submit') }} <i class="fa fa-check"
                                                aria-hidden="true"></i>
                                        </button>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>
@endsection
