@extends('admin.layouts.main')

@section('title', __('translations.clients-reports'))
@section('sub-title', __('translations.reports'))

@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <div class="row">
                <!-- Summary Cards -->
                <div class="col-md-4">
                    <div class="card card-body">
                        <h4 id="total_clients_display">{{ __('translations.total_clients') }}: {{ $totalClients }}</h4>
                    </div>
                </div>
                <!--<div class="col-md-4">-->
                <!--    <div class="card card-body">-->
                <!--        <h4 id="total_men_display">{{ __('translations.total_men') }}: {{ $totalMen }}</h4>-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="col-md-4">-->
                <!--    <div class="card card-body">-->
                <!--        <h4 id="total_women_display">{{ __('translations.total_women') }}: {{ $totalWomen }}</h4>-->
                <!--    </div>-->
                <!--</div>-->
            </div>

            <div class="card card-docs mb-2">
                <div class="card-header">
                    <div class="card-title m-0">
                        <h3 class="fw-bolder m-0">{{ __('translations.clients-reports') }}</h3>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-4">
                        @php
                            $filters = [
                                'first_name' => __('translations.first_name'),
                                'last_name' => __('translations.last_name'),
                                'phone' => __('translations.phone'),
                            ];
                        @endphp

                        @foreach ($filters as $key => $label)
                            <div class="col-md-3 mb-3">
                                <input type="text" id="{{ $key }}" class="form-control" placeholder="{{ $label }}">
                            </div>
                        @endforeach

                        <div class="col-md-3 mb-3">
                            <input type="date" id="birth_date" class="form-control" placeholder="{{ __('translations.birth_date') }}">
                        </div>

                        <div class="col-md-3 mb-3">
                            <select id="city_id" class="form-control">
                                <option value="">{{ __('translations.select_city') }}</option>
                                @foreach ($cities as $city)
                                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <select id="region_id" class="form-control">
                                <option value="">{{ __('translations.select_region') }}</option>
                                @foreach ($regions as $region)
                                    <option value="{{ $region->id }}">{{ $region->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <select id="gender" class="form-control">
                                <option value="">{{ __('translations.select_gender') }}</option>
                                <option value="man">{{ __('translations.male') }}</option>
                                <option value="women">{{ __('translations.female') }}</option>
                            </select>
                        </div>

                       <div class="d-flex  justify-content-around">
                        <div class="col-md-4 mb-3">
                            <button id="search_button" class="btn btn-primary w-100">{{ __('translations.search') }}</button>
                        </div>


                        <div class="col-md-4 mb-3">
                            <a href="{{ route('admin.clients.export') }}" class="btn btn-success w-100">{{ __('translations.Excel') }}</a>
                        </div>
                       </div>
                    </div>

                    <!-- Clients Table -->
                    <div id="reports-body">
                        @include('admin.reports.partials.clients_table', ['clients' => $clients])
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
$(document).ready(function() {
    $('#search_button').on('click', function() {
        let filters = {};
        $('#first_name, #last_name, #birth_date, #address, #phone, #city_id, #region_id, #gender').each(function() {
            if ($(this).val() !== '') {
                filters[$(this).attr('id')] = $(this).val();
            }
        });

        $.ajax({
            url: "{{ route('admin.clients.filter') }}",
            method: 'GET',
            data: filters,
            success: function(data) {
                $('#reports-body').html(data.html);
                $('#total_clients_display').text('{{ __('translations.total_clients') }}: ' + data.total_clients);
                $('#total_men_display').text('{{ __('translations.total_men') }}: ' + data.total_men);
                $('#total_women_display').text('{{ __('translations.total_women') }}: ' + data.total_women);
            }
        });
    });
});
</script>
@endsection
