@extends('admin.layouts.main')
@section('title')
    {{ __('translations.examinations-create') }}
@endsection
@section('sub-title')
    {{ __('translations.examinations') }}
@endsection
@section('content')

    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.examinations-create') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.examinations.store') }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <!-- Examination Code Field -->
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.Examination Code') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="code"
                                                value="{{ $examination_code }}" readonly />
                                            @error('code')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- Client Selection Section -->
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.Client name') }} <span
                                                    class="text-danger">*</span></label>
                                            <div class="d-flex">
                                                <select id="client-select" class="form-control" data-control="select2"
                                                    name="client_id" required>
                                                    <option value="" disabled selected>
                                                        {{ __('translations.select_client') }}</option>
                                                    @if (is_countable($clients) && count($clients) > 0)
                                                        @foreach ($clients as $client)
                                                            <option value="{{ $client->id }}">
                                                                {{ $client->first_name . ' ' . $client->last_name . ' - ' . $client->phone }}
                                                            </option>
                                                        @endforeach
                                                    @else
                                                        <option value="">{{ __('translations.no_clients') }}</option>
                                                    @endif
                                                </select>
                                                <a href="{{ route('admin.clients.create') }}"
                                                    class="btn btn-primary ms-3">{{ __('translations.create_client') }}</a>
                                            </div>
                                            @error('client_id')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- "Get Data" Button -->
                                        <a class="btn btn-primary ms-3" id="get-data-btn">Get Data</a>

                                        <!-- Type Selection Field -->
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.type') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" data-control="select2" name="type" required>
                                                <option value="" disabled selected>
                                                    {{ __('translations.select_type') }}</option>
                                                @if (is_countable($types) && count($types) > 0)
                                                    @foreach ($types as $type)
                                                        <option value="{{ $type }}">{{ $type }}</option>
                                                    @endforeach
                                                @else
                                                    <option value="">{{ __('translations.no_types') }}</option>
                                                @endif
                                            </select>
                                            @error('type')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- Examiner Selection Field -->
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.examiner') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" data-control="select2" name="examiner_id" required>
                                                <option value="">{{ __('translations.select_examiner') }}</option>
                                                @if (is_countable($examiners) && count($examiners) > 0)
                                                    @foreach ($examiners as $examiner)
                                                        <option value="{{ $examiner->id }}">{{ $examiner->name }}</option>
                                                    @endforeach
                                                @else
                                                    <option value="">{{ __('translations.no_examiners') }}</option>
                                                @endif
                                            </select>
                                            @error('examiner_id')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- Notes Field -->
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.Note') }} <span
                                                    class="text-danger">*</span></label>
                                            <textarea class="form-control" name="notes" rows="5"></textarea>
                                            @error('notes')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- Status Field (Hidden) -->
                                        <div class="col-md-6 mb-5">
                                            <input type="text" class="form-control" name="status"
                                                value="في انتظار التاكيد" hidden />
                                            @error('status')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>

                                        <!-- Details Table Section -->
                                        <div id="details-table" class="card-body" dir="ltr" style="display: none;">
                                            <!-- حاوية رئيسية باستخدام flexbox لعرض الجدولين بجانب بعضهما -->
                                            <div style="display: flex; justify-content: space-between; gap: 0;">
                                                <!-- الجدول الأول (تفاصيل العينين) -->
                                                <div style="flex: 1; padding-right: 10px;">
                                                    <table
                                                        class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                                                        <thead>
                                                            <tr class="fw-bolder fs-8 text-uppercase gs-0">
                                                                <th>Type</th>
                                                                <th>Sph</th>
                                                                <th>Cyl</th>
                                                                <th>Axis</th>
                                                                <th>A.D.D</th>
                                                                <th>I.P.D</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-gray-800 fw-bold">
                                                            @foreach ($formatted_data as $item)
                                                                <input type="hidden" class="form-control" name="data_id"
                                                                    value="{{ $item['id'] }}" />
                                                                <!-- صف العين اليمنى -->
                                                                <tr>
                                                                    <td>{{ $item['right_eye']['type'] }}</td>
                                                                    <td>{{ $item['right_eye']['sph'] ?? '--' }}</td>
                                                                    <td>{{ $item['right_eye']['cyl'] ?? '--' }}</td>
                                                                    <td>{{ $item['right_eye']['axis'] ?? '--' }}</td>
                                                                    <td>{{ $item['right_eye']['add'] ?? '--' }}</td>
                                                                    <td>{{ $item['right_eye']['lpd'] ?? '--' }}</td>
                                                                </tr>
                                                                <!-- صف العين اليسرى -->
                                                                <tr>
                                                                    <td>{{ $item['left_eye']['type'] }}</td>
                                                                    <td>{{ $item['left_eye']['sph'] ?? '--' }}</td>
                                                                    <td>{{ $item['left_eye']['cyl'] ?? '--' }}</td>
                                                                    <td>{{ $item['left_eye']['axis'] ?? '--' }}</td>
                                                                    <td>{{ $item['left_eye']['add'] ?? '--' }}</td>
                                                                    <td>{{ $item['left_eye']['lpd'] ?? '--' }}</td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>


                                            </div>
                                        </div>





                                        <!-- Hidden Inputs for Formatted Data -->
                                        @foreach ($formatted_data as $index => $item)
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][right_eye][sph]"
                                                value="{{ $item['right_eye']['sph'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][right_eye][cyl]"
                                                value="{{ $item['right_eye']['cyl'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][right_eye][axis]"
                                                value="{{ $item['right_eye']['axis'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][right_eye][lpd]"
                                                value="{{ $item['right_eye']['lpd'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][right_eye][add]"
                                                value="{{ $item['right_eye']['add'] }}">

                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][left_eye][sph]"
                                                value="{{ $item['left_eye']['sph'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][left_eye][cyl]"
                                                value="{{ $item['left_eye']['cyl'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][left_eye][axis]"
                                                value="{{ $item['left_eye']['axis'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][left_eye][lpd]"
                                                value="{{ $item['left_eye']['lpd'] }}">
                                            <input type="hidden"
                                                name="formatted_data[{{ $index }}][left_eye][add]"
                                                value="{{ $item['left_eye']['add'] }}">
                                        @endforeach

                                        <!-- Submit and Back Buttons -->
                                        <div class="d-flex pt-5 justify-content-between align-items-center">
                                            <a href="{{ route('admin.examinations.index') }}" class="btn btn-secondary">
                                                {{ __('translations.back') }} <i class="fa fa-undo"
                                                    aria-hidden="true"></i>
                                            </a>
                                            <button type="submit" class="btn btn-primary">
                                                {{ __('translations.create') }} <i class="fa fa-check"
                                                    aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>





    {{--
    <script>
        $(document).ready(function () {
    $('#client-select').on('change', function () {
        var clientId = $(this).val(); // الحصول على قيمة العميل المحددة

        if (clientId) {
            $.ajax({
                url: "{{ route('admin.getClientDetails') }}", // استبدل بـ route المناسب
                type: "GET",
                data: { client_id: clientId },
                success: function (response) {
                    // تحقق من وجود بيانات
                    if (response.success) {
                        $('#details-table').html(response.html).show();
                    } else {
                        $('#details-table').hide();
                    }
                },
                error: function () {
                    alert('حدث خطأ أثناء استرجاع البيانات');
                }
            });
        } else {
            $('#details-table').hide();
        }
    });
});

    </script> --}}

    <!-- جافاسكريبت -->
    <!-- تضمين مكتبة jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <script>
        $(document).ready(function() {
            // Toggle table visibility when client is selected
            $('#client-select').on('change', function() {
                var clientId = $(this).val();
                if (clientId) {
                    // Show table with a smooth fade-in effect
                    $('#details-table').stop(true, true).fadeIn(500); // You can use slideDown if you prefer
                } else {
                    // Hide the table and remove it from the DOM if no client is selected
                    $('#details-table').fadeOut(500, function() {
                        $(this).remove(); // Removes table from DOM after hiding
                    });
                }
            });

            // "Get Data" Button: Simulate page refresh when clicked
            $('#get-data-btn').on('click', function() {
                $(this).prop('disabled', true); // Disable the button to prevent multiple clicks
                $(this).text('Loading...'); // Change button text to "Loading..."

                setTimeout(function() {
                    // Reload the page after 1 second to simulate a data refresh
                    location.reload(); // This refreshes the entire page
                }, 1000); // 1-second delay before reloading the page
            });
        });
    </script>


@endsection
