@foreach ($reports as $examination)
<tr class="border-bottom">
    <td class="py-3 fw-bold text-primary">{{ $examination->code }}</td>
    <td>
        @if ($examination->client)
            <div class="d-flex align-items-center">
                <div class="symbol symbol-30px me-3 bg-light-primary rounded-circle">
                    <span class="text-primary">{{ substr($examination->client->first_name ?? '', 0, 1) }}</span>
                </div>
                <span>{{ $examination->client->first_name ?? '' }} {{ $examination->client->last_name ?? '' }}</span>
            </div>
        @else
            <span class="badge badge-light-danger">{{ __('translations.No Client') }}</span>
        @endif
    </td>
    <td>
        <span class="text-muted fs-7">{!! \Illuminate\Support\Str::limit($examination->notes, 80, '...') !!}</span>
    </td>
    <td><span class="badge badge-light-info">{{ $examination->type }}</span></td>
    <td>{{ $examination->created_at }}</td>
    <td>
        @php
            $statusClass = '';
            switch($examination->status) {
                case 'في انتظار التاكيد':
                    $statusClass = 'badge-light-warning';
                    break;
                case 'ارسال الي المشغل':
                    $statusClass = 'badge-light-primary';
                    break;
                case 'تم التجهيز':
                    $statusClass = 'badge-light-success';
                    break;
                case 'تم الاستلام':
                    $statusClass = 'badge-light-info';
                    break;
                case 'الغاء':
                    $statusClass = 'badge-light-danger';
                    break;
                default:
                    $statusClass = 'badge-light-secondary';
            }
        @endphp
        <span class="badge {{ $statusClass }}">{{ $examination->status }}</span>
    </td>
</tr>
@endforeach
