<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $setting->name }} </title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background: #f9f9f9;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: auto;
            background: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #ccc;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 1.8rem;
            color: #007bff;
        }

        .header p {
            margin: 5px 0;
            font-size: 1rem;
            color: #555;
        }

        .section {
            margin-bottom: 20px;
        }

        .section h2 {
            font-size: 1.4rem;
            color: #333;
            margin-bottom: 10px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }

        .details-list {
            display: flex;
            flex-direction: row;
            justify-content: space-between;
            padding: 0;
            margin: 0;
        }

        .details-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 1rem;
        }

        .details-item span {
            display: inline-block;
            color: #555;
        }

        .details-item .title {
            font-weight: bold;
            color: #333;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table th,
        table td {
            border: 1px solid #ccc;
            padding: 10px;
            text-align: center;
            font-size: 1rem;
        }

        table th {
            background: #f7f7f7;
            color: #333;
        }

        .footer {
            text-align: center;
            font-size: 0.9rem;
            color: #777;
            margin-top: 20px;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }

        @media print {
            body {
                margin: 0;
                padding: 0;
                background: #fff;
                color: #000;
            }

            .container {
                box-shadow: none;
                border-radius: 0;
            }

            .footer {
                display: none;
            }
        }
    </style>
</head>

<body dir="rtl">
    <div class="container">
        <div class="section">
            <ul class="details-list">
                <li class="details-item">
                    <span style="font-size: 20px" class="title">{{ __('translations.Examination Code') }}: </span>
                    <span style="font-size: 20px">{{ $examination->code }}</span>
                </li>
                <li class="details-item">
                    <span style="font-size: 20px" class="title">{{ __('translations.Client name') }}: </span>
                    <span style="font-size: 20px">{{ $examination->client->first_name }}
                        {{ $examination->client->last_name }}</span>
                </li>

                <li class="details-item">
                    <span class="title">{{ __('translations.type') }}: </span>
                    <span> {{ $examination->type }}</span>
                </li>
                <li class="details-item">
                    <span class="title">{{ __('translations.notes') }}: </span>
                    <span>{{ $examination->notes }}</span>
                </li>

            </ul>
        </div>

        <div class="section">
            <h2>{{ __('translations.Examination Results') }}</h2>
            <!-- حاوية رئيسية باستخدام flexbox لعرض الجدولين بجانب بعضهما -->
            <div style="display: flex; gap: 0;">
                <!-- الجدول الثاني (القيم المالية) -->
                <div style="flex: 0 0 30%; margin-left: -1px;">
                    <table class="table table-bordered" dir="ltr">
                        <tbody>
                            <tr>
                                <td style="width: 50%"></td>
                                <td style="width: 50%">{{ __('translations.price') }}</td>
                            </tr>

                            <tr>
                                <td style="width: 50%"></td>
                                <td style="width: 50%">{{ __('translations.paid') }}</td>
                            </tr>
                            <tr>
                                <td style="width: 50%"></td>
                                <td style="width: 50%">{{ __('translations.remaining') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <!-- الجدول الأول (النتائج التفصيلية) -->
                <div style="flex: 1;">
                    <table class="table table-bordered" dir="ltr">
                        <thead>
                            <tr class="fw-bold bg-light">
                                <th>{{ __('translations.Type') }}</th>
                                <th>{{ __('translations.Sph') }}</th>
                                <th>{{ __('translations.Cyl') }}</th>
                                <th>{{ __('translations.Axis') }}</th>
                                <th>{{ __('translations.L.P.D') }}</th>
                                <th>{{ __('translations.A.D.D') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="details-value">Rt</td>
                                <td>{{ $examination->details->where('type', 'R')->first()->sph ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'R')->first()->cyl ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'R')->first()->axis ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'R')->first()->lpd ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'R')->first()->add ?? '--' }}</td>
                            </tr>
                            <tr>
                                <td class="details-value">Lt</td>
                                <td>{{ $examination->details->where('type', 'L')->first()->sph ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'L')->first()->cyl ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'L')->first()->axis ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'L')->first()->lpd ?? '--' }}</td>
                                <td>{{ $examination->details->where('type', 'L')->first()->add ?? '--' }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>


            </div>
        </div>


    </div>

    <script>
        // فتح نافذة الطباعة تلقائيًا
        window.onload = function() {
            setTimeout(() => {
                window.print();
            }, 1000);
        };
    </script>
</body>

</html>
