@extends('admin.layouts.main')
@section('title')
    {{ __('translations.rooms-list') }}
@endsection
@section('sub-title')
    {{ __('translations.rooms') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.rooms-list') }}</h3>
                                </div>

                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center position-relative mb-4">
                                    <span class="svg-icon svg-icon-1 position-absolute ms-4">
                                        <svg width="18" height="18" viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                                        </svg>
                                    </span>
                                    <input type="text" data-kt-filter="search"
                                        class="form-control form-control-solid w-250px ps-14"
                                        placeholder="{{ __('translations.rooms-search') }}" />
                                </div>
                                <table id="kt_datatable_example"
                                    class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                                    <thead>
                                        <tr class="fw-bolder fs-8 text-uppercase gs-0">
                                            <th>{{ __('translations.room-name') }}</th>
                                            <th>{{ __('translations.room_code') }}</th>
                                            <th>{{ __('translations.room-examinations') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-800 fw-bold">
                                        @foreach ($rooms as $room)
                                            <tr>
                                                <td>{{ $room->name }}</td>
                                                <td>{{ $room->room_code }}</td>
                                                <td>{{ $room->examinations_count }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
