@extends('admin.layouts.main')

@section('title')
    {{ __('translations.examinations-show') }}
@endsection

@section('sub-title')
    {{ __('translations.examinations') }}
@endsection

@section('content')
    <style>
        /* تحسين تنسيق الحقول */
        .details-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 2rem;
            font-size: 1.2rem;
            padding: 0.8rem 1.2rem;
            border: 1px solid #eee;
            border-radius: 8px;
            background-color: #f9f9f9;
        }

        .details-title {
            font-weight: bold;
            color: #333;
            margin-right: 1rem;
        }

        .details-value {
            font-weight: 600;
            color: #3a3a3a;
        }

        .table th,
        .table td {
            font-size: 1.1rem;
            text-align: center;
        }

        .select-status {
            font-size: 1rem;
            padding: 0.5rem;
            border-radius: 6px;
            border: 1px solid #ccc;
            color: #333;
        }

        /* تحسين الطباعة */
        @media print {

            /* إخفاء الشريط العلوي الرئيسي عند الطباعة */
            header,
            .navbar,
            .card-header,
            .footer {
                display: none;
            }

            /* إخفاء الأزرار والحقول القابلة للتعديل أثناء الطباعة */
            .btn,
            .card-body>.d-flex,
            .card-title,
            .card-header .m-0 {
                display: none;
            }

            /* إخفاء العناوين الفرعية والعناوين في الطباعة */
            .content .d-flex {
                display: none;
            }

            .card-body {
                font-size: 1.2rem;
                line-height: 1.6;
            }

            /* تحسين تنسيق الجدول للطباعة */
            .table th,
            .table td {
                font-size: 1rem;
                text-align: left;
            }

            .table {
                border-collapse: collapse;
                width: 100%;
            }

            .table th,
            .table td {
                border: 1px solid #ccc;
                padding: 8px;
            }

            .details-item {
                padding: 1rem;
                margin-bottom: 1rem;
            }

            /* جعل التفاصيل واضحة للطباعة */
            .details-title {
                font-size: 1.2rem;
            }

            .details-value {
                font-size: 1.1rem;
            }

            /* إخفاء حواف الـ select عند الطباعة */
            .select-status {
                border: none;
                outline: none;
                background: none;
            }
        }
    </style>




    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.examination_details') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <!-- تفاصيل الفحص -->
                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.Examination Code') }}</span>
                                            <span class="details-value">{{ $examination->code }}</span>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.Client name') }}</span>
                                            <span class="details-value">
                                                {{ $examination->client->first_name }} {{ $examination->client->last_name }}
                                            </span>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.phone') }}</span>
                                            <span class="details-value">{{ $examination->client->phone }}</span>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.type') }}</span>
                                            <span class="details-value">{{ $examination->type }}</span>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="details-item">
                                            <span class="details-title">{{ __('translations.examiner') }}</span>
                                            <span class="details-value">{{ $examination->examiner->name }}</span>
                                        </div>
                                    </div>



                                    <div class="col-md-8">
                                        <div class="">
                                            <span class="details-title">{{ __('translations.Note') }} : {{ $examination->notes }}</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- جدول بيانات الفحص -->
                                <div class="card-body">
                                    <h5 class="mb-3">{{ __('translations.Examination Results') }}</h5>
                                    <table class="table table-bordered"  dir="ltr">
                                        <thead>
                                            <tr class="fw-bold bg-light">
                                                <th>{{ __('translations.Type') }}</th>
                                                <th>{{ __('translations.Sph') }}</th>
                                                <th>{{ __('translations.Cyl') }}</th>
                                                <th>{{ __('translations.Axis') }}</th>
                                                <th>{{ __('translations.A.D.D') }}</th>
                                                <th>{{ __('translations.I.P.D') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="details-value">Rt</td>
                                                <td>{{ $examination->details->where('type', 'R')->first()->sph ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'R')->first()->cyl ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'R')->first()->axis ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'R')->first()->lpd ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'R')->first()->add ?? '--' }}</td>
                                            </tr>
                                            <tr>
                                                <td class="details-value">Lt</td>
                                                <td>{{ $examination->details->where('type', 'L')->first()->sph ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'L')->first()->cyl ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'L')->first()->axis ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'L')->first()->lpd ?? '--' }}</td>
                                                <td>{{ $examination->details->where('type', 'L')->first()->add ?? '--' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- أزرار الرجوع والطباعة -->
                                <div class="d-flex pt-5 justify-content-between align-items-center">
                                    <a href="{{ route('admin.examinations.index') }}" class="btn btn-secondary">
                                        {{ __('translations.back') }} <i class="fa fa-undo"></i>
                                    </a>
                                    <a href="{{ route('admin.examinations.print', $examination->id) }}"
                                        class="btn btn-primary" target="_blank">
                                        {{ __('translations.print') }} <i class="fa fa-print"></i>
                                    </a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
