@extends('admin.layouts.main')
@section('title'){{ __('translations.roles-edit') }}@endsection
@section('sub-title'){{ __('translations.roles') }}@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
  <div class="post d-flex flex-column-fluid" id="kt_post">
    <div id="kt_content_container" class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card card-docs mb-2">
            <div class="card-header">
              <div class="card-title m-0">
                <h3 class="fw-bolder m-0">{{ __('translations.roles-edit') }}</h3>
              </div>
            </div>
            <div class="card-body">
              <form action="{{route('admin.roles.update', $role->id)}}" method="post">
                @csrf
                @method('PUT')
                <div class="row">
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.roles-name')}} <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="name" value="{{$role->name}}" @if($role->name == 'superadmin') readonly @endif required/>
                    @error('name')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12 mb-5">
                    <label class="form-label">{{__('translations.roles-displayname')}} <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="display_name" value="{{$role->display_name}}" required/>
                    @error('display_name')<div class="fv-plugins-message-container invalid-feedback"><strong>{{$message}}</strong></div>@enderror
                  </div>
                  <div class="col-md-12">
                    <div class="row">
                      @foreach ($permissions as $key => $permission)
                      <div class="card col-md-3">
                        <div class="card-body">
                          @php $key = explode('--', $key); @endphp
                          <h6 class="pb-1">{{__('translations.'.(!empty($key[1]) ? $key[1] : $key[0]))}}</h6>
                          @foreach ($permission as $item)
                          <div class="form-group pb-1">
                              <input type="checkbox" name="permissions[]" value="{{$item->id}}" @if(in_array($item->id, $rolePermissions)) checked @endif>
                              {{$item->display_name}}
                            </div>
                          @endforeach
                        </div>
                      </div>
                      @endforeach
                    </div>
                  </div>
                </div>
                <div class="d-flex pt-5 justify-content-between align-items-center">
                  <a href="{{route('admin.roles.index')}}" class="btn btn-secondary">
                    {{__('translations.back')}} <i class="fa fa-undo" aria-hidden="true"></i>
                  </a>
                  <button type="submit" class="btn btn-primary">
                    {{__('translations.edit')}} <i class="fa fa-check" aria-hidden="true"></i>
                  </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection