@extends('admin.layouts.main')
@section('title')
  {{ __('translations.roles-list') }}
@endsection
@section('sub-title')
  {{ __('translations.roles') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-flush shadow-sm">
              <div class="card-header border-0 pt-6">
                <div class="card-title">
                  <h3 class="card-label fw-bold text-dark">{{ __('translations.roles-list') }}</h3>
                </div>
                <div class="card-toolbar">
                  <div class="d-flex justify-content-end">
                    <div class="d-flex align-items-center position-relative me-4">
                      <span class="svg-icon svg-icon-2 position-absolute ms-4">
                        <svg width="18" height="18" viewBox="0 0 24 24">
                          <path fill="currentColor"
                            d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                        </svg>
                      </span>
                      <input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14"
                        placeholder="{{ __('translations.roles-search') }}" />
                    </div>
                    @permission('roles-create')
                      <a href="{{ route('admin.roles.create') }}" class="btn btn-primary btn-sm font-weight-bold">
                        <span class="svg-icon svg-icon-2">
                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                            fill="none">
                            <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                              transform="rotate(-90 11.364 20.364)" fill="white" stroke="white" stroke-width="3"></rect>
                            <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="white"
                              stroke="white" stroke-width="3"></rect>
                          </svg>
                        </span>
                        <span>{{ __('translations.roles-create') }}</span>
                      </a>
                    @endpermission
                  </div>
                </div>
              </div>
              <div class="card-body py-4">
                <table id="kt_datatable_example"
                  class="table table-rounded table-row-bordered table-row-gray-300 border gy-4 gs-7 align-middle">
                  <thead>
                    <tr class="fw-bold text-muted bg-light">
                      <th class="min-w-150px rounded-start">{{ __('translations.roles-name') }}</th>
                      <th>{{ __('translations.roles-permissions') }}</th>
                      <th class="min-w-100px text-end rounded-end">{{ __('translations.actions') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach ($roles as $role)
                      <tr>
                        <td>
                          <div class="d-flex align-items-center">
                            <div class="symbol symbol-40px me-3">
                              <div class="symbol-label bg-light-primary">
                                <span class="text-primary fw-bold">{{ substr($role->display_name, 0, 1) }}</span>
                              </div>
                            </div>
                            <div class="d-flex flex-column">
                              <span class="text-gray-800 fw-bold">{{ $role->display_name }}</span>
                            </div>
                          </div>
                        </td>
                        <td style="white-space: normal!important;">
                          <div class="d-flex flex-wrap gap-1">
                            @foreach ($role->permissions as $permission)
                              <span class="badge badge-light-success fs-7 fw-semibold">{{ $permission->display_name }}</span>
                            @endforeach
                          </div>
                        </td>
                        <td class="text-end">
                          @permission('roles-edit')
                            <div class="d-flex justify-content-end flex-shrink-0">
                              <a href="{{ route('admin.roles.edit', $role->id) }}" class="btn btn-icon btn-light-primary btn-sm me-1">
                                <span class="svg-icon svg-icon-3">
                                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path opacity="0.3" d="M21.4 8.35303L19.241 10.511L13.485 4.755L15.643 2.59595C16.0248 2.21423 16.5426 1.99988 17.0825 1.99988C17.6224 1.99988 18.1402 2.21423 18.522 2.59595L21.4 5.474C21.7817 5.85581 21.9962 6.37355 21.9962 6.91345C21.9962 7.45335 21.7817 7.97122 21.4 8.35303ZM3.68699 21.932L9.88699 19.865L4.13099 14.109L2.06399 20.309C1.98815 20.5354 1.97703 20.7787 2.03189 21.0111C2.08674 21.2436 2.2054 21.4561 2.37449 21.6248C2.54359 21.7934 2.75641 21.9115 2.989 21.9658C3.22158 22.0201 3.4647 22.0084 3.69099 21.932H3.68699Z" fill="currentColor"></path>
                                    <path d="M5.574 21.3L3.692 21.928C3.46591 22.0032 3.22334 22.0141 2.99144 21.9594C2.75954 21.9046 2.54744 21.7864 2.3789 21.6179C2.21036 21.4495 2.09202 21.2375 2.03711 21.0056C1.9822 20.7737 1.99289 20.5312 2.06799 20.3051L2.696 18.422L5.574 21.3ZM4.13499 14.105L9.891 19.861L19.245 10.507L13.489 4.75098L4.13499 14.105Z" fill="currentColor"></path>
                                  </svg>
                                </span>
                              </a>
                              <a href="#" class="btn btn-icon btn-light-danger btn-sm"
                                 onclick="event.preventDefault();
                                  if(confirm('هل أنت متأكد من عملية الحذف ؟')) {
                                  document.getElementById('delete-form-{{ $role->id }}').submit();
                                  }">
                                <span class="svg-icon svg-icon-3">
                                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                    <path d="M5 9C5 8.44772 5.44772 8 6 8H18C18.5523 8 19 8.44772 19 9V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V9Z" fill="currentColor"></path>
                                    <path opacity="0.5" d="M5 5C5 4.44772 5.44772 4 6 4H18C18.5523 4 19 4.44772 19 5V5C19 5.55228 18.5523 6 18 6H6C5.44772 6 5 5.55228 5 5V5Z" fill="currentColor"></path>
                                    <path opacity="0.5" d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4V4H9V4Z" fill="currentColor"></path>
                                  </svg>
                                </span>
                              </a>
                              <form id="delete-form-{{ $role->id }}"
                                action="{{ route('admin.roles.destroy', $role->id) }}" method="post"
                                style="display: none;">
                                @csrf @method('DELETE')
                              </form>
                            </div>
                          @endpermission
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
