@extends('admin.layouts.main')
@section('title')
  {{ __('translations.rooms-edit') }}
@endsection
@section('sub-title')
  {{ __('translations.rooms') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.rooms-edit') }}</h3>
                </div>
              </div>
              <div class="card-body">
                <form action="{{ route('admin.rooms.update', $room->id) }}" method="post" enctype="multipart/form-data">
                  @csrf
                  @method('PUT') <!-- تحديد الطريقة المطلوبة لتحديث البيانات -->
                  <div class="row">
                    <div class="col-md-12 mb-5">
                      <label class="form-label">{{ __('translations.room-room_code') }} <span
                          class="text-danger">*</span></label>
                      <input type="text" class="form-control" name="room_code" value="{{ $room->room_code }}"
                        required />
                      @error('room_code')
                        <div class="fv-plugins-message-container invalid-feedback"><strong>{{ $message }}</strong>
                        </div>
                      @enderror
                    </div>
                    <div class="col-md-12 mb-5">
                      <label class="form-label">{{ __('translations.room-name') }} <span
                          class="text-danger">*</span></label>
                      <input type="text" class="form-control" name="name" value="{{ $room->name }}" required />
                      @error('name')
                        <div class="fv-plugins-message-container invalid-feedback"><strong>{{ $message }}</strong>
                        </div>
                      @enderror
                    </div>
                  </div>

                  <div class="d-flex pt-5 justify-content-between align-items-center">
                    <a href="{{ route('admin.rooms.index') }}" class="btn btn-secondary">
                      {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                    </a>
                    <button type="submit" class="btn btn-primary">
                      {{ __('translations.edit') }} <i class="fa fa-check" aria-hidden="true"></i>
                    </button>
                  </div>
                </form>

              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
