@extends('admin.layouts.main')
@section('title')
    {{ __('translations.backup_settings') }}
@endsection
@section('sub-title')
    {{ __('translations.database_backup_management') }}
@endsection
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <div class="card shadow-sm border-0 mb-5">
                <div class="card-header border-0" style="background: linear-gradient(135deg, #3a7bd5, #2196f3)">
                    <div class="card-title m-0">
                        <h3 class="fw-bold m-0 text-white">{{ __('translations.database_backup_management') }}</h3>
                    </div>
                    <div class="card-toolbar">
                        <a href="{{ route('admin.settings.backups.create') }}" class="btn btn-success">
                            <i class="fas fa-plus me-1"></i>{{ __('translations.create_backup') }}
                        </a>
                    </div>
                </div>
                <div class="card-body p-4">
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>{{ session('success') }}</strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <strong>{{ session('error') }}</strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-rounded table-striped border gy-7 gs-7">
                            <thead>
                                <tr class="fw-semibold fs-6 text-gray-800 border-bottom border-gray-200">
                                    <th>{{ __('translations.backup_name') }}</th>
                                    <th>{{ __('translations.date') }}</th>
                                    <th>{{ __('translations.size') }}</th>
                                    <th>{{ __('translations.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($backupFiles as $backup)
                                <tr>
                                    <td>{{ $backup['name'] }}</td>
                                    <td>{{ $backup['date'] }}</td>
                                    <td>{{ $backup['size'] }}</td>
                                    <td>
                                        <div class="d-flex justify-content-start flex-shrink-0">
                                            <a href="{{ route('admin.settings.backups.download', $backup['name']) }}" class="btn btn-icon btn-bg-light btn-active-color-primary btn-sm me-1" title="{{ __('translations.download') }}">
                                                <i class="fas fa-download text-primary"></i>
                                            </a>
                                            <a href="{{ route('admin.settings.backups.delete', $backup['name']) }}" class="btn btn-icon btn-bg-light btn-active-color-danger btn-sm" title="{{ __('translations.delete') }}" onclick="return confirm('{{ __('translations.are_you_sure') }}')">
                                                <i class="fas fa-trash text-danger"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center py-4">{{ __('translations.no_backups_found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-header border-0 bg-light">
                    <div class="card-title m-0">
                        <h3 class="fw-bold m-0">{{ __('translations.backup_instructions') }}</h3>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="alert alert-info">
                        <h5 class="alert-heading">{{ __('translations.how_to_use_backups') }}</h5>
                        <hr>
                        <p>{{ __('translations.backup_explanation_1') }}</p>
                        <p>{{ __('translations.backup_explanation_2') }}</p>
                        <ul>
                            <li>{{ __('translations.backup_instruction_1') }}</li>
                            <li>{{ __('translations.backup_instruction_2') }}</li>
                            <li>{{ __('translations.backup_instruction_3') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
