@extends('admin.layouts.main')
@section('title')
    {{ __('translations.settings') }}
@endsection
@section('sub-title')
    {{ __('translations.settings-edit') }}
@endsection
@section('styles')
<style>
    .settings-card {
        border-radius: 10px;
        background-color: #fff;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .settings-tabs {
        padding: 1rem;
    }

    .settings-tab {
        display: flex;
        align-items: center;
        padding: 0.75rem 1rem;
        margin-bottom: 0.5rem;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
    }

    .settings-tab.active {
        background-color: #f1f8ff;
        color: #0d6efd;
    }

    .settings-tab:hover:not(.active) {
        background-color: #f8f9fa;
    }

    .settings-tab-icon {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 0.75rem;
        font-size: 14px;
    }

    .settings-tab-text {
        font-weight: 500;
        font-size: 14px;
    }

    .tab-content {
        display: none;
        padding: 1.5rem;
    }

    .tab-content.active {
        display: block;
        animation: fadeIn 0.3s;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .form-control {
        border-radius: 8px;
        padding: 0.6rem 1rem;
        border: 1px solid #e0e0e0;
        transition: all 0.2s;
    }

    .form-control:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.15rem rgba(13, 110, 253, 0.1);
    }

    .form-label {
        font-weight: 500;
        color: #555;
        margin-bottom: 0.5rem;
        font-size: 14px;
    }

    .input-group-text {
        border-radius: 8px 0 0 8px;
        border: 1px solid #e0e0e0;
        background-color: #f9f9f9;
    }

    .btn {
        border-radius: 8px;
        padding: 0.6rem 1.25rem;
        font-weight: 500;
        transition: all 0.2s;
    }

    .btn-primary {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }

    .btn-primary:hover {
        background-color: #0b5ed7;
        border-color: #0b5ed7;
    }

    .btn-light {
        background-color: #f8f9fa;
        border-color: #e0e0e0;
        color: #555;
    }

    .btn-light:hover {
        background-color: #e9ecef;
        border-color: #ddd;
    }

    .tab-content-header {
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 1px solid #f1f1f4;
    }

    .tab-content-header h3 {
        font-size: 18px;
        color: #333;
    }

    .upload-zone {
        border: 2px dashed #ddd;
        border-radius: 10px;
        padding: 2rem;
        text-align: center;
        transition: all 0.2s;
        background-color: #fafafa;
    }

    .upload-zone:hover {
        border-color: #0d6efd;
        background-color: #f8f9fa;
    }

    .logo-preview {
        max-width: 100%;
        max-height: 100px;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
</style>
@endsection

@section('content')
<div class="content d-flex flex-column flex-column-fluid">
    <div class="container-fluid">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h1 class="fs-4 fw-bold text-dark">{{ __('translations.settings') }}</h1>
        </div>

        <form id="settings-form" action="{{ route('admin.settings.update') }}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="row g-4">

                <!-- Content -->
                <div class="col-12 col-lg-12">
                    <div class="settings-card">
                        <!-- Company Tab -->
                        <div id="company-tab" class="tab-content active">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0">{{ __('translations.company_information') }}</h3>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-name_ar') }}</label>
                                    <input type="text" class="form-control @error('name_ar') is-invalid @enderror"
                                        name="name_ar" value="{{ $setting->translate('ar')->name }}" required />
                                    @error('name_ar')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-name_en') }}</label>
                                    <input type="text" class="form-control @error('name_en') is-invalid @enderror"
                                        name="name_en" value="{{ $setting->translate('en')->name }}" required />
                                    @error('name_en')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-12">
                                    <label class="form-label">{{ __('translations.settings-email') }}</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-envelope text-primary"></i>
                                        </span>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                                            name="email" value="{{ $setting->email }}" required />
                                    </div>
                                    @error('email')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Contact Tab -->
                        <div id="contact-tab" class="tab-content">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0">{{ __('translations.contact_information') }}</h3>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-address_ar') }}</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-map-marker text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control @error('address_ar') is-invalid @enderror"
                                            name="address_ar" value="{{ $setting->translate('ar')->address }}" required />
                                    </div>
                                    @error('address_ar')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-address_en') }}</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-map-marker text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control @error('address_en') is-invalid @enderror"
                                            name="address_en" value="{{ $setting->translate('en')->address }}" required />
                                    </div>
                                    @error('address_en')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-phone1') }}</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-phone text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control @error('phone1') is-invalid @enderror"
                                            name="phone1" value="{{ $setting->phone1 }}" required />
                                    </div>
                                    @error('phone1')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-phone2') }}</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-phone text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control @error('phone2') is-invalid @enderror"
                                            name="phone2" value="{{ $setting->phone2 }}" required />
                                    </div>
                                    @error('phone2')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Description Tab -->
                        <div id="description-tab" class="tab-content">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0">{{ __('translations.description') }}</h3>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-description_ar') }}</label>
                                    <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                        name="description_ar" rows="6" required>{{ $setting->translate('ar')->description }}</textarea>
                                    @error('description_ar')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">{{ __('translations.settings-description_en') }}</label>
                                    <textarea class="form-control @error('description_en') is-invalid @enderror"
                                        name="description_en" rows="6" required>{{ $setting->translate('en')->description }}</textarea>
                                    @error('description_en')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Media Tab -->
                        <div id="media-tab" class="tab-content">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0">{{ __('translations.media') }}</h3>
                            </div>

                            <div class="row justify-content-center g-4">
                                @if(isset($setting->logo))
                                <div class="col-12 text-center mb-3">
                                    <div class="mb-3">
                                        <img src="{{ asset('storage/' . $setting->logo) }}" alt="Current Logo"
                                            class="logo-preview border p-2">
                                        <p class="text-muted small mt-2">{{ __('translations.current_logo') }}</p>
                                    </div>
                                </div>
                                @endif

                                <div class="col-md-8">
                                    <div class="upload-zone">
                                        <i class="fa fa-cloud-upload text-primary fs-3 mb-2"></i>
                                        <h5 class="mb-3">{{ __('translations.settings-logo') }}</h5>
                                        <input type="file" class="form-control d-none" name="logo" accept="image/*" id="logo-upload">
                                        <button type="button" id="logo-trigger" class="btn btn-primary">
                                            <i class="fa fa-upload me-1"></i> {{ __('translations.choose_file') }}
                                        </button>
                                        <p class="text-muted small mt-2" id="selected-file">{{ __('translations.no_file_selected') }}</p>
                                        @error('logo')
                                            <div class="text-danger mt-2">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <a href="{{ route('admin.index') }}" class="btn btn-light me-2">
                                    <i class="fa fa-times me-1"></i> {{ __('translations.cancel') }}
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save me-1"></i> {{ __('translations.edit') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Tab navigation
        const tabs = document.querySelectorAll('.settings-tab');
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', function() {
                const targetTab = this.getAttribute('data-tab');

                // Update active tab
                tabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');

                // Update tab content
                tabContents.forEach(content => content.classList.remove('active'));
                document.getElementById(`${targetTab}-tab`).classList.add('active');
            });
        });

        // File upload trigger
        document.getElementById('logo-trigger').addEventListener('click', function() {
            document.getElementById('logo-upload').click();
        });

        // File upload display
        document.getElementById('logo-upload').addEventListener('change', function() {
            const fileName = this.files[0] ? this.files[0].name : '{{ __("translations.no_file_selected") }}';
            document.getElementById('selected-file').textContent = fileName;
        });
    });
</script>
@endsection
