@extends('admin.layouts.main')
@section('title')
    {{ __('translations.invotek settings') }}
@endsection
@section('sub-title')
    {{ __('translations.invotek settings') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.invotek settings') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.settings.invotek.update') }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.url') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="url"
                                                value="{{ $invotek->url }}" required />
                                            @error('url')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.user_code') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="user_code"
                                                value="{{ $invotek->user_code }}" required />
                                            @error('user_code')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.type') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="type"
                                                value="{{ $invotek->type }}" required disabled />
                                        </div>
                                        <div class="col-md-6 mb-5">
                                            <label class="form-label">{{ __('translations.active-status') }} <span
                                                    class="text-danger">*</span></label>
                                            <select name="active" class="form-control">
                                                <option value="1" {{ $invotek->active == 1 ? 'selected' : '' }}>
                                                    {{ __('translations.active') }}
                                                </option>
                                                <option value="0" {{ $invotek->active == 0 ? 'selected' : '' }}>
                                                    {{ __('translations.inactive') }}
                                                </option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="d-flex pt-5 justify-content-between align-items-center">
                                        <a href="{{ route('admin.index') }}" class="btn btn-secondary">
                                            {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('translations.edit') }} <i class="fa fa-check" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
