@extends('admin.layouts.main')
@section('title')
    {{ __('translations.theme_settings') }}
@endsection
@section('sub-title')
    {{ __('translations.theme_settings_edit') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                          
                            <div class="card-body">
                                <form action="{{ route('admin.settings.theme.update') }}" method="post" id="theme-settings-form">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="card shadow-sm rounded border-0 mb-5">
                                                <div class="card-header border-0 bg-light py-3">
                                                    <h4 class="card-title fw-bold m-0">
                                                        <i class="fas fa-palette me-2"></i>{{ __('translations.colors') }}
                                                    </h4>
                                                </div>
                                                <div class="card-body p-4">
                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.sidebar_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="sidebar_bg_color_text" value="{{ $themeSettings->sidebar_bg_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="sidebar_bg_color" value="{{ $themeSettings->sidebar_bg_color }}" />
                                                        </div>
                                                        @error('sidebar_bg_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.sidebar_text_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="sidebar_text_color_text" value="{{ $themeSettings->sidebar_text_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="sidebar_text_color" value="{{ $themeSettings->sidebar_text_color }}" />
                                                        </div>
                                                        @error('sidebar_text_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.header_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="header_bg_color_text" value="{{ $themeSettings->header_bg_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="header_bg_color" value="{{ $themeSettings->header_bg_color }}" />
                                                        </div>
                                                        @error('header_bg_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.header_text_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="header_text_color_text" value="{{ $themeSettings->header_text_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="header_text_color" value="{{ $themeSettings->header_text_color }}" />
                                                        </div>
                                                        @error('header_text_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.primary_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="primary_color_text" value="{{ $themeSettings->primary_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="primary_color" value="{{ $themeSettings->primary_color }}" />
                                                        </div>
                                                        @error('primary_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.secondary_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="secondary_color_text" value="{{ $themeSettings->secondary_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="secondary_color" value="{{ $themeSettings->secondary_color }}" />
                                                        </div>
                                                        @error('secondary_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.text_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="text_color_text" value="{{ $themeSettings->text_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="text_color" value="{{ $themeSettings->text_color }}" />
                                                        </div>
                                                        @error('text_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-0">
                                                        <label class="form-label fw-bold">{{ __('translations.link_color') }}</label>
                                                        <div class="input-group color-picker-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-palette"></i>
                                                            </span>
                                                            <input type="text" class="form-control form-control-solid color-value" name="link_color_text" value="{{ $themeSettings->link_color }}" readonly/>
                                                            <input type="color" class="form-control form-control-solid color-picker" name="link_color" value="{{ $themeSettings->link_color }}" />
                                                        </div>
                                                        @error('link_color')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="card shadow-sm rounded border-0 mb-5">
                                                <div class="card-header border-0 bg-light py-3">
                                                    <h4 class="card-title fw-bold m-0">
                                                        <i class="fas fa-font me-2"></i>{{ __('translations.typography') }}
                                                    </h4>
                                                </div>
                                                <div class="card-body p-4">
                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.font_family') }}</label>
                                                        <select class="form-select form-select-solid" name="font_family" id="font-family-select">
                                                            <option value="Poppins, Arial, sans-serif" {{ $themeSettings->font_family == 'Poppins, Arial, sans-serif' ? 'selected' : '' }}>Poppins</option>
                                                            <option value="Roboto, Arial, sans-serif" {{ $themeSettings->font_family == 'Roboto, Arial, sans-serif' ? 'selected' : '' }}>Roboto</option>
                                                            <option value="Open Sans, Arial, sans-serif" {{ $themeSettings->font_family == 'Open Sans, Arial, sans-serif' ? 'selected' : '' }}>Open Sans</option>
                                                            <option value="Tajawal, Arial, sans-serif" {{ $themeSettings->font_family == 'Tajawal, Arial, sans-serif' ? 'selected' : '' }}>Tajawal</option>
                                                            <option value="Cairo, Arial, sans-serif" {{ $themeSettings->font_family == 'Cairo, Arial, sans-serif' ? 'selected' : '' }}>Cairo</option>
                                                        </select>
                                                        @error('font_family')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.base_font_size') }}</label>
                                                        <div class="input-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-text-height"></i>
                                                            </span>
                                                            <select class="form-select form-select-solid" name="base_font_size" id="base-font-size">
                                                                <option value="12px" {{ $themeSettings->base_font_size == '12px' ? 'selected' : '' }}>12px</option>
                                                                <option value="13px" {{ $themeSettings->base_font_size == '13px' ? 'selected' : '' }}>13px</option>
                                                                <option value="14px" {{ $themeSettings->base_font_size == '14px' ? 'selected' : '' }}>14px</option>
                                                                <option value="15px" {{ $themeSettings->base_font_size == '15px' ? 'selected' : '' }}>15px</option>
                                                                <option value="16px" {{ $themeSettings->base_font_size == '16px' ? 'selected' : '' }}>16px</option>
                                                            </select>
                                                        </div>
                                                        @error('base_font_size')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.heading_font_size') }}</label>
                                                        <div class="input-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-heading"></i>
                                                            </span>
                                                            <select class="form-select form-select-solid" name="heading_font_size" id="heading-font-size">
                                                                <option value="1rem" {{ $themeSettings->heading_font_size == '1rem' ? 'selected' : '' }}>Small (1rem)</option>
                                                                <option value="1.25rem" {{ $themeSettings->heading_font_size == '1.25rem' ? 'selected' : '' }}>Medium (1.25rem)</option>
                                                                <option value="1.5rem" {{ $themeSettings->heading_font_size == '1.5rem' ? 'selected' : '' }}>Large (1.5rem)</option>
                                                                <option value="1.75rem" {{ $themeSettings->heading_font_size == '1.75rem' ? 'selected' : '' }}>X-Large (1.75rem)</option>
                                                            </select>
                                                        </div>
                                                        @error('heading_font_size')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>

                                                    <div class="mb-4">
                                                        <label class="form-label fw-bold">{{ __('translations.menu_font_size') }}</label>
                                                        <div class="input-group">
                                                            <span class="input-group-text">
                                                                <i class="fas fa-list"></i>
                                                            </span>
                                                            <select class="form-select form-select-solid" name="menu_font_size" id="menu-font-size">
                                                                <option value="0.85rem" {{ $themeSettings->menu_font_size == '0.85rem' ? 'selected' : '' }}>Small (0.85rem)</option>
                                                                <option value="1rem" {{ $themeSettings->menu_font_size == '1rem' ? 'selected' : '' }}>Medium (1rem)</option>
                                                                <option value="1.15rem" {{ $themeSettings->menu_font_size == '1.15rem' ? 'selected' : '' }}>Large (1.15rem)</option>
                                                            </select>
                                                        </div>
                                                        @error('menu_font_size')
                                                            <div class="fv-plugins-message-container invalid-feedback">
                                                                <strong>{{ $message }}</strong>
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card shadow-sm rounded border-0 mb-5">
                                                <div class="card-header border-0 bg-light py-3">
                                                    <h4 class="card-title fw-bold m-0">
                                                        <i class="fas fa-cog me-2"></i>{{ __('translations.general_settings') }}
                                                    </h4>
                                                </div>
                                                <div class="card-body p-4">
                                                    <div class="form-check form-switch form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="checkbox" id="darkModeSwitch" name="is_dark_mode" {{ $themeSettings->is_dark_mode ? 'checked' : '' }} />
                                                        <label class="form-check-label ms-2" for="darkModeSwitch">{{ __('translations.dark_mode') }}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <div class="card shadow-sm rounded border-0 p-0 mb-5">
                                                <div class="card-header border-0 bg-light py-3">
                                                    <h4 class="card-title fw-bold m-0">
                                                        <i class="fas fa-eye me-2"></i>{{ __('translations.preview') }}
                                                    </h4>
                                                </div>
                                                <div class="card-body p-4">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div id="sidebar-preview" class="p-5 rounded mb-5 shadow-sm" style="background-color: {{ $themeSettings->sidebar_bg_color }};">
                                                                <h5 class="text-white">{{ __('translations.sidebar_preview') }}</h5>
                                                                <div class="d-flex align-items-center mt-3">
                                                                    <span style="color: {{ $themeSettings->sidebar_text_color }}; opacity: 0.7;">&bullet;</span>
                                                                    <span class="ms-2" style="color: {{ $themeSettings->sidebar_text_color }};">{{ __('translations.menu_item') }}</span>
                                                                </div>
                                                                <div class="d-flex align-items-center mt-2">
                                                                    <span style="color: {{ $themeSettings->primary_color }}; opacity: 0.7;">&bullet;</span>
                                                                    <span class="ms-2" style="color: {{ $themeSettings->primary_color }};">{{ __('translations.active_menu_item') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div id="header-preview" class="p-5 rounded mb-5 shadow-sm" style="background-color: {{ $themeSettings->header_bg_color }};">
                                                                <h5 style="color: {{ $themeSettings->header_text_color }};">{{ __('translations.header_preview') }}</h5>
                                                                <div class="d-flex align-items-center mt-3">
                                                                    <span style="color: {{ $themeSettings->header_text_color }};">{{ __('translations.header_text') }}</span>
                                                                    <a href="#" class="ms-3" style="color: {{ $themeSettings->link_color }};">{{ __('translations.link_text') }}</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div id="content-preview" class="p-5 rounded shadow-sm" style="border: 1px solid rgba(0,0,0,0.1); background-color: {{ $themeSettings->is_dark_mode ? '#1e1e2d' : '#ffffff' }};">
                                                                <h3 style="font-family: {{ $themeSettings->font_family }}; font-size: {{ $themeSettings->heading_font_size }}; color: {{ $themeSettings->text_color }};">{{ __('translations.heading_preview') }}</h3>
                                                                <p style="font-family: {{ $themeSettings->font_family }}; font-size: {{ $themeSettings->base_font_size }}; color: {{ $themeSettings->text_color }};">{{ __('translations.paragraph_preview') }}</p>
                                                                <a href="#" style="color: {{ $themeSettings->link_color }};">{{ __('translations.link_preview') }}</a>
                                                                <div class="mt-3">
                                                                    <button type="button" class="btn btn-sm" style="background-color: {{ $themeSettings->primary_color }}; color: #ffffff;">{{ __('translations.primary_button') }}</button>
                                                                    <button type="button" class="btn btn-sm ms-2" style="background-color: {{ $themeSettings->secondary_color }}; color: #ffffff;">{{ __('translations.secondary_button') }}</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-5">
                                        <div class="col-12">
                                            <div class="d-flex justify-content-center justify-content-md-start">
                                                <button type="submit" class="btn btn-primary px-5">
                                                    <i class="fas fa-save me-2"></i>{{ __('translations.save_changes') }}
                                                </button>
                                                <a href="{{ route('admin.settings') }}" class="btn btn-secondary ms-3 px-5">
                                                    <i class="fas fa-times me-2"></i>{{ __('translations.cancel') }}
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize color inputs with text display
        const colorPickers = document.querySelectorAll('.color-picker');
        colorPickers.forEach(picker => {
            const textInput = picker.parentElement.querySelector('.color-value');
            const pickerName = picker.name;

            // Set initial text value
            textInput.value = picker.value;

            // Add event listener for color changes
            picker.addEventListener('input', function(e) {
                textInput.value = e.target.value;
                updatePreview();
            });

            // Make the text input click activate the color picker
            textInput.addEventListener('click', function() {
                picker.click();
            });
        });

        // Initialize select inputs with enhanced styling
        const fontFamilySelect = document.getElementById('font-family-select');
        const baseFontSizeSelect = document.getElementById('base-font-size');
        const headingFontSizeSelect = document.getElementById('heading-font-size');
        const menuFontSizeSelect = document.getElementById('menu-font-size');

        [fontFamilySelect, baseFontSizeSelect, headingFontSizeSelect, menuFontSizeSelect].forEach(select => {
            select.addEventListener('change', updatePreview);
        });

        // Dark mode switch with animation
        const darkModeSwitch = document.getElementById('darkModeSwitch');
        darkModeSwitch.addEventListener('change', function() {
            const contentPreview = document.getElementById('content-preview');
            contentPreview.style.transition = 'background-color 0.3s ease';
            updatePreview();
        });

        // Add form submission with visual feedback
        const form = document.getElementById('theme-settings-form');
        form.addEventListener('submit', function(e) {
            const submitButton = form.querySelector('button[type="submit"]');
            submitButton.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>' + submitButton.textContent;
            submitButton.disabled = true;
            // Form will continue submission normally
        });

        // Real-time preview update function
        function updatePreview() {
            // Get all values
            const sidebarColor = document.querySelector('input[name="sidebar_bg_color"]').value;
            const sidebarTextColor = document.querySelector('input[name="sidebar_text_color"]').value;
            const headerColor = document.querySelector('input[name="header_bg_color"]').value;
            const headerTextColor = document.querySelector('input[name="header_text_color"]').value;
            const primaryColor = document.querySelector('input[name="primary_color"]').value;
            const secondaryColor = document.querySelector('input[name="secondary_color"]').value;
            const textColor = document.querySelector('input[name="text_color"]').value;
            const linkColor = document.querySelector('input[name="link_color"]').value;
            const fontFamily = document.querySelector('select[name="font_family"]').value;
            const baseFont = document.querySelector('select[name="base_font_size"]').value;
            const headingFont = document.querySelector('select[name="heading_font_size"]').value;
            const isDarkMode = document.getElementById('darkModeSwitch').checked;

            // Update sidebar preview with animation
            const sidebarPreview = document.getElementById('sidebar-preview');
            sidebarPreview.style.transition = 'background-color 0.3s ease';
            sidebarPreview.style.backgroundColor = sidebarColor;
            sidebarPreview.querySelectorAll('div span:nth-child(1)')[0].style.color = sidebarTextColor;
            sidebarPreview.querySelectorAll('div span:nth-child(2)')[0].style.color = sidebarTextColor;
            sidebarPreview.querySelectorAll('div span:nth-child(2)')[1].style.color = primaryColor;

            // Update header preview
            const headerPreview = document.getElementById('header-preview');
            headerPreview.style.transition = 'background-color 0.3s ease';
            headerPreview.style.backgroundColor = headerColor;
            headerPreview.querySelector('h5').style.color = headerTextColor;
            headerPreview.querySelectorAll('div span')[0].style.color = headerTextColor;
            headerPreview.querySelector('div a').style.color = linkColor;
            headerPreview.querySelector('div a').style.transition = 'color 0.3s ease';

            // Update content preview
            const contentPreview = document.getElementById('content-preview');
            contentPreview.style.backgroundColor = isDarkMode ? '#1e1e2d' : '#ffffff';

            // Apply font-family to all preview elements
            const previewElements = contentPreview.querySelectorAll('h3, p, a, button');
            previewElements.forEach(element => {
                element.style.fontFamily = fontFamily;
                element.style.transition = 'all 0.3s ease';
            });

            contentPreview.querySelector('h3').style.fontSize = headingFont;
            contentPreview.querySelector('h3').style.color = textColor;
            contentPreview.querySelector('p').style.fontSize = baseFont;
            contentPreview.querySelector('p').style.color = textColor;
            contentPreview.querySelector('a').style.color = linkColor;

            // Button animations
            const buttons = contentPreview.querySelectorAll('button');
            buttons.forEach(button => {
                button.style.transition = 'background-color 0.3s ease';
            });
            buttons[0].style.backgroundColor = primaryColor;
            buttons[1].style.backgroundColor = secondaryColor;

            // Add hover effects to buttons
            buttons.forEach(button => {
                button.addEventListener('mouseover', function() {
                    this.style.opacity = '0.9';
                });
                button.addEventListener('mouseout', function() {
                    this.style.opacity = '1';
                });
            });
        }

        // Initial preview update
        updatePreview();

        // Add reset button functionality
        const resetDefaults = function() {
            if (confirm('{{ __('translations.reset_confirmation') }}')) {
                // Default values
                document.querySelector('input[name="sidebar_bg_color"]').value = '#1e1e2d';
                document.querySelector('input[name="header_bg_color"]').value = '#ffffff';
                document.querySelector('input[name="primary_color"]').value = '#00a3ff';
                document.querySelector('input[name="secondary_color"]').value = '#f1416c';
                document.querySelector('input[name="text_color"]').value = '#181c32';
                document.querySelector('input[name="link_color"]').value = '#009ef7';
                document.querySelector('select[name="font_family"]').value = 'Poppins, Arial, sans-serif';
                document.querySelector('select[name="base_font_size"]').value = '14px';
                document.querySelector('select[name="heading_font_size"]').value = '1.25rem';
                document.querySelector('select[name="menu_font_size"]').value = '1rem';
                document.getElementById('darkModeSwitch').checked = false;

                // Update all color text inputs
                document.querySelectorAll('.color-picker').forEach(picker => {
                    const textInput = picker.parentElement.querySelector('.color-value');
                    textInput.value = picker.value;
                });

                updatePreview();
            }
        };

        // Add a reset button to the form
        const actionsContainer = document.querySelector('.row.mt-5 .col-12 .d-flex');
        const resetButton = document.createElement('button');
        resetButton.type = 'button';
        resetButton.className = 'btn btn-light-danger ms-3 px-5';
        resetButton.innerHTML = '<i class="fas fa-redo me-2"></i>{{ __('translations.reset') }}';
        resetButton.addEventListener('click', resetDefaults);
        actionsContainer.appendChild(resetButton);
    });
</script>
@endsection
