@extends('admin.layouts.main')
@section('title')
    {{ __('translations.theme_presets') }}
@endsection
@section('sub-title')
    {{ __('translations.theme_presets') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="alert alert-info text-center p-4 shadow-sm">
                            <h5 class="alert-heading mb-0 fw-bold"><i class="fas fa-info-circle me-2"></i>{{ __('translations.select_theme_instruction') }}</h5>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mb-5">
                    <div class="card-header">
                        <div class="card-title m-0">
                            <h3 class="fw-bolder m-0"><i class="fas fa-paint-brush me-2"></i>{{ __('translations.theme_settings') }}</h3>
                        </div>
                        <div class="card-toolbar">
                            <a href="{{ route('admin.settings.theme') }}" class="btn btn-primary">
                                <i class="fas fa-palette me-2"></i>{{ __('translations.theme_presets') }}
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="theme-switcher mb-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    <i class="fas fa-eye fs-2"></i>
                                </div>
                                <div>
                                    <h4 class="mb-0">{{ __('translations.theme_preview') }}</h4>
                                    <p class="text-muted">{{ __('translations.select_theme_from_options') }}</p>
                                </div>
                            </div>

                            <ul class="nav nav-pills nav-pills-custom mb-4" id="theme-tabs" role="tablist">
                                @foreach($colorSchemes as $key => $scheme)
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link @if($loop->first) active @endif" id="theme-tab-{{ $key }}" data-bs-toggle="pill" href="#theme-content-{{ $key }}" role="tab">
                                        <div class="d-flex align-items-center">
                                            <div class="color-swatch rounded-circle me-2" style="width: 18px; height: 18px; background-color: {{ $scheme['primary_color'] }};"></div>
                                            <span>{{ $scheme['name'] }}</span>
                                        </div>
                                    </a>
                                </li>
                                @endforeach
                            </ul>

                            <div class="tab-content" id="theme-tab-content">
                                @foreach($colorSchemes as $key => $scheme)
                                <div class="tab-pane fade @if($loop->first) show active @endif" id="theme-content-{{ $key }}" role="tabpanel">
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <div class="theme-preview-container shadow-sm rounded overflow-hidden">
                                                <div class="theme-preview-sidebar" style="background-color: {{ $scheme['sidebar_bg_color'] }}; color: {{ $scheme['sidebar_text_color'] }}; width: 100%; height: 120px; padding: 1rem;">
                                                    <h5 style="color: {{ $scheme['sidebar_text_color'] }}; font-family: {{ $scheme['font_family'] }};">{{ __('translations.sidebar_preview') }}</h5>
                                                    <div class="d-flex align-items-center mt-2">
                                                        <div class="rounded py-1 px-3 me-2" style="background-color: {{ $scheme['primary_color'] }}; color: #fff;">
                                                            {{ __('translations.dashboard') }}
                                                        </div>
                                                        <div>{{ __('translations.menu_item') }}</div>
                                                    </div>
                                                </div>
                                                <div class="theme-preview-header d-flex align-items-center justify-content-between" style="background-color: {{ $scheme['header_bg_color'] }}; color: {{ $scheme['header_text_color'] }}; height: 60px; padding: 0 1rem;">
                                                    <h6 class="m-0" style="color: {{ $scheme['header_text_color'] }}; font-family: {{ $scheme['font_family'] }};">{{ __('translations.header_preview') }}</h6>
                                                    <div class="d-flex align-items-center">
                                                        <span class="me-3"><i class="fas fa-bell"></i></span>
                                                        <span><i class="fas fa-user-circle"></i></span>
                                                    </div>
                                                </div>
                                                <div class="theme-preview-body p-4" style="min-height: 200px; background-color: #fff;">
                                                    <h4 style="color: {{ $scheme['text_color'] }}; font-family: {{ $scheme['font_family'] }};">{{ __('translations.content_preview') }}</h4>
                                                    <p style="color: {{ $scheme['text_color'] }}; font-family: {{ $scheme['font_family'] }};">
                                                        هذا نص تجريبي لعرض لون النص. يمكنك رؤية <a href="javascript:;" style="color: {{ $scheme['link_color'] }};">رابط بهذا اللون</a> ضمن المحتوى.
                                                    </p>
                                                    <div class="mt-3">
                                                        <button class="btn me-2" style="background-color: {{ $scheme['primary_color'] }}; color: #fff;">{{ __('translations.primary_button') }}</button>
                                                        <button class="btn" style="background-color: {{ $scheme['secondary_color'] }}; color: #fff;">{{ __('translations.secondary_button') }}</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="color-palette p-4 rounded shadow-sm h-100">
                                                <h5 class="mb-4">{{ __('translations.color_palette') }}</h5>

                                                <div class="color-item d-flex align-items-center justify-content-between mb-3">
                                                    <span>{{ __('translations.primary_color') }}</span>
                                                    <div class="color-badge d-flex align-items-center">
                                                        <div class="color-sample rounded" style="width: 30px; height: 30px; background-color: {{ $scheme['primary_color'] }};"></div>
                                                        <span class="ms-2 text-muted small">{{ $scheme['primary_color'] }}</span>
                                                    </div>
                                                </div>

                                                <div class="color-item d-flex align-items-center justify-content-between mb-3">
                                                    <span>{{ __('translations.secondary_color') }}</span>
                                                    <div class="color-badge d-flex align-items-center">
                                                        <div class="color-sample rounded" style="width: 30px; height: 30px; background-color: {{ $scheme['secondary_color'] }};"></div>
                                                        <span class="ms-2 text-muted small">{{ $scheme['secondary_color'] }}</span>
                                                    </div>
                                                </div>

                                                <div class="color-item d-flex align-items-center justify-content-between mb-3">
                                                    <span>{{ __('translations.sidebar_bg_color') }}</span>
                                                    <div class="color-badge d-flex align-items-center">
                                                        <div class="color-sample rounded" style="width: 30px; height: 30px; background-color: {{ $scheme['sidebar_bg_color'] }};"></div>
                                                        <span class="ms-2 text-muted small">{{ $scheme['sidebar_bg_color'] }}</span>
                                                    </div>
                                                </div>

                                                <div class="color-item d-flex align-items-center justify-content-between mb-3">
                                                    <span>{{ __('translations.header_bg_color') }}</span>
                                                    <div class="color-badge d-flex align-items-center">
                                                        <div class="color-sample rounded" style="width: 30px; height: 30px; background-color: {{ $scheme['header_bg_color'] }};"></div>
                                                        <span class="ms-2 text-muted small">{{ $scheme['header_bg_color'] }}</span>
                                                    </div>
                                                </div>

                                                <div class="font-preview mt-4 mb-4">
                                                    <span class="d-block mb-2">{{ __('translations.font_family') }}:</span>
                                                    <p class="p-2 rounded bg-light" style="font-family: {{ $scheme['font_family'] }};">
                                                        {{ explode(',', $scheme['font_family'])[0] }}
                                                    </p>
                                                </div>

                                                <form action="{{ route('admin.settings.theme.presets.apply') }}" method="post" class="mt-4">
                                                    @csrf
                                                    <input type="hidden" name="theme" value="{{ $key }}">
                                                    <button type="submit" class="btn btn-lg w-100" style="background-color: {{ $scheme['primary_color'] }}; color: #ffffff;">
                                                        <i class="fas fa-check-circle me-2"></i>{{ __('translations.apply_this_theme') }}
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between align-items-center mt-5">
                    <a href="{{ route('admin.settings.theme') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>{{ __('translations.back_to_settings') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('styles')
<style>
    .theme-preview-container {
        border: 1px solid #eee;
    }

    .nav-pills-custom .nav-link {
        color: #6c757d;
        background: #fff;
        position: relative;
        border: 1px solid #e4e6ef;
        margin-right: 10px;
    }

    .nav-pills-custom .nav-link.active {
        color: #5d78ff;
        background: #fff;
        border-color: #5d78ff;
    }

    .nav-pills-custom .nav-link.active:after {
        content: '';
        position: absolute;
        left: 45%;
        bottom: -10px;
        width: 10px;
        height: 10px;
        background: #fff;
        transform: rotate(45deg);
        border-right: 1px solid #5d78ff;
        border-bottom: 1px solid #5d78ff;
    }

    .color-badge {
        min-width: 100px;
    }
</style>
@endsection
