@extends('admin.layouts.main')
@section('title')
    {{ __('translations.users-edit') }}
@endsection
@section('sub-title')
    {{ __('translations.users') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.users-edit') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.users.update', $user->id) }}" method="post">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-name') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="name"
                                                value="{{ $user->name }}" required />
                                            @error('name')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                        <!-- Room Selection -->
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.rooms') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" data-control="select2" name="room_id" required>
                                                <option value="">اختر الغرفة</option>
                                                @foreach ($rooms as $room)
                                                    <option value="{{ $room->id }}"
                                                        {{ $user->room_id == $room->id ? 'selected' : '' }}>
                                                        {{ $room->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('room_id')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong>
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-email') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="email" class="form-control" name="email"
                                                value="{{ $user->email }}" required />
                                            @error('email')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-phone') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="phone"
                                                value="{{ $user->phone }}" required />
                                            @error('phone')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-role') }} <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-control" data-control="select2" name="role" required>
                                                @foreach ($roles as $role)
                                                    <option value="{{ $role->name }}"
                                                        {{ $user->roles->contains($role) ? 'selected' : '' }}>
                                                        {{ $role->display_name }}</option>
                                                @endforeach
                                            </select>
                                            @error('role')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.users-address') }}</label>
                                            <input type="text" class="form-control" name="address"
                                                value="{{ $user->address }}" />
                                            @error('address')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="d-flex pt-5 justify-content-between align-items-center">
                                        <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                                            {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('translations.create') }} <i class="fa fa-check" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
