@extends('admin.layouts.main')
@section('title')
  {{ __('translations.users-list') }}
@endsection
@section('sub-title')
  {{ __('translations.users') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.users-list') }}</h3>
                </div>
                <div class="card-toolbar">
                  @permission('users-create')
                    <a href="{{ route('admin.users.create') }}" class="btn btn-primary">
                      <span class="svg-icon svg-icon-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                          fill="none">
                          <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                            transform="rotate(-90 11.364 20.364)" fill="white" stroke="white" stroke-width="3"></rect>
                          <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="white"
                            stroke="white" stroke-width="3"></rect>
                        </svg>
                      </span>
                      <span>{{ __('translations.users-create') }}</span>
                    </a>
                  @endpermission
                </div>
              </div>
              <div class="card-body">
                <div class="d-flex align-items-center position-relative mb-4">
                  <span class="svg-icon svg-icon-1 position-absolute ms-4">
                    <svg width="18" height="18" viewBox="0 0 24 24">
                      <path fill="currentColor"
                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                    </svg>
                  </span>
                  <input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14"
                    placeholder="{{ __('translations.users-search') }}" />
                </div>
                <table id="kt_datatable_example"
                  class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                  <thead>
                    <tr class="fw-bolder fs-8 text-uppercase gs-0">
                      <th>{{ __('translations.users-name') }}</th>
                      <th>{{ __('translations.users-email') }}</th>
                      <th>{{ __('translations.users-role') }}</th>
                      <th>{{ __('translations.users-phone') }}</th>
                      <th>{{ __('translations.users-address') }}</th>
                      <th>{{ __('translations.actions') }}</th>
                    </tr>
                  </thead>
                  <tbody class="text-gray-800 fw-bold">
                    @foreach ($users as $user)
                      <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>
                          @foreach ($user->roles as $role)
                            {{ $role->display_name }}
                          @endforeach
                        </td>
                        <td>{{ $user->phone }}</td>
                        <td>{{ $user->address ?? 'N/A' }}</td>
                        <td>
                          <button class="btn btn-light btn-sm dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('translations.actions') }}
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @permission('users-edit')
                              <a class="dropdown-item" href="{{ route('admin.users.edit', $user->id) }}">
                                {{ __('translations.edit') }}
                              </a>
                              <a class="dropdown-item" href="#"
                                onclick="event.preventDefault();
                                    if(confirm('هل أنت متأكد من عملية الحذف ؟')) {
                                    document.getElementById('delete-form-{{ $user->id }}').submit();  
                                    }">
                                {{ __('translations.delete') }}
                              </a>
                              <form id="delete-form-{{ $user->id }}"
                                action="{{ route('admin.users.destroy', $user->id) }}" method="post"
                                style="display: none;">
                                @csrf @method('DELETE')
                              </form>
                            @endpermission
                          </div>
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
