@extends('admin.layouts.main')
@section('title')
    {{ __('translations.whatsapp') }}
@endsection
@section('sub-title')
    {{ __('translations.whatsapp-edit') }}
@endsection

@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.whatsapp-edit') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">


                                <form action="{{ route('admin.settings.whatsapp.update') }}" method="post"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.status') }} <span
                                                    class="text-danger">*</span></label>
                                            <div class="d-flex align-items-center">
                                                <button type="button"
                                                    class="btn btn-{{ $whatsapp->active == 1 ? 'success' : 'danger' }} btn-sm"
                                                    id="toggleActiveBtn">
                                                    {{ $whatsapp->active == 1 ? __('translations.active') : __('translations.inactive') }}
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.whatsapp-domain') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="domain"
                                                value="{{ $whatsapp->domain }}" required />
                                            @error('domain')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>

                                        <div class="col-md-4 mb-5">
                                            <label class="form-label">{{ __('translations.whatsapp-app_key') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="app_key"
                                                value="{{ $whatsapp->app_key }}" required />
                                            @error('app_key')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>

                                        <div class="col-md-4 mb-5">
                                            <label class="form-label">{{ __('translations.whatsapp-auth_key') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="auth_key"
                                                value="{{ $whatsapp->auth_key }}" required />
                                            @error('auth_key')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>

                                        <div class="col-md-4 mb-5">
                                            <label class="form-label">{{ __('translations.Country Code') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="code"
                                                value="{{ $whatsapp->code }}" required />
                                            @error('code')
                                                <div class="fv-plugins-message-container invalid-feedback">
                                                    <strong>{{ $message }}</strong></div>
                                            @enderror
                                        </div>



                                        <div class="d-flex pt-5 justify-content-between align-items-center">
                                            <a href="{{ route('admin.settings') }}" class="btn btn-secondary">
                                                {{ __('translations.back') }} <i class="fa fa-undo" aria-hidden="true"></i>
                                            </a>
                                            <button type="submit" class="btn btn-primary">
                                                {{ __('translations.edit') }} <i class="fa fa-check"
                                                    aria-hidden="true"></i>
                                            </button>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script>
        document.getElementById('toggleActiveBtn').addEventListener('click', function() {
            var currentStatus = {{ $whatsapp->active }}; // Get the current active status
            var newStatus = currentStatus === 1 ? 0 : 1; // Toggle the status

            // Send AJAX request to update the status
            fetch('{{ route('admin.settings.whatsapp.updateStatus') }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        active: newStatus
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Update the button UI after successful status change
                        var button = document.getElementById('toggleActiveBtn');
                        if (newStatus === 1) {
                            button.classList.remove('btn-danger');
                            button.classList.add('btn-success');
                            button.innerText = '{{ __('translations.active') }}';
                        } else {
                            button.classList.remove('btn-success');
                            button.classList.add('btn-danger');
                            button.innerText = '{{ __('translations.inactive') }}';
                        }
                    } else {
                        alert('حدث خطأ أثناء تغيير الحالة.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                });
        });
    </script>
@endsection
