@extends('admin.layouts.main')

@section('title')
    {{ __('translations.settings') }}
@endsection

@section('sub-title')
    {{ __('translations.whatsapp templates') }}
@endsection

@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    @foreach($templates as $template)
                        <div class="col-md-4">
                            <a href="{{ route('admin.whatsapp.show', $template->id) }}" class="card card-custom bg-light-primary text-center p-4 m-4 shadow-sm hover-shadow-lg transition-all">
                                <div class="card-body position-relative">
                                    
                                    @if($template->active == 1)
                                    <span class="badge position-absolute top-0 end-0 bg-success px-3 py-2 text-white">
                                        {{ __('translations.active') }}
                                    </span>
                                    
                                    @else
                                         <span class="badge position-absolute top-0 end-0 bg-danger px-3 py-2 text-white">
                                        {{ __('translations.inactive') }}
                                    </span>
                                    
                                    @endif
                                    <!-- Custom Icon for Template -->
                                    <div class="icon-wrapper mb-3">
                                        <i class="fas fa-comment-dots fa-3x text-primary"></i> <!-- Change this to any icon you want -->
                                    </div>
                                    <h5 class="fw-bold text-dark">{{ $template->name }}</h5>
                                    <p class="text-muted">{{ $template->code }}</p>
                                </div>
                            </a>
                        </div>
                    @endforeach 
                </div>
            </div>
        </div>
    </div>
@endsection
