@extends('admin.layouts.main')
@section('title')
    {{ __('translations.settings') }}
@endsection
@section('sub-title')
    {{ __('translations.edit whatsapp template') }}
@endsection
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-docs mb-5">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">{{ __('translations.edit whatsapp template') }}</h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.whatsapp.update', $template->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    

                                    <div class="row">
                                        <div class="col-md-12 mb-5">
                                            <label class="form-label">{{ __('translations.status') }} <span
                                                    class="text-danger">*</span></label>
                                            <div class="d-flex align-items-center">
                                             <button id="toggleActiveBtn" 
        class="btn {{ $template->active ? 'btn-success' : 'btn-danger' }}">
    {{ $template->active ? __('translations.active') : __('translations.inactive') }}
</button>
<input type="hidden" name="active" class="form-control" id="name"
                                                    value="{{ $template->active == 1 ? 0 : 1   }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="name">{{ __('translations.name') }}</label>
                                                <input type="text" name="name" class="form-control" id="name"
                                                    value="{{ $template->name }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="code">{{ __('translations.code') }}</label>
                                                <input type="text" name="code" class="form-control" id="code"
                                                    value="{{ $template->code }}" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="message">{{ __('translations.message') }}</label>
                                        <textarea name="message" class="form-control" id="message" rows="6" required>{{ $template->message }}</textarea>
                                    </div>

                                    <div class="form-group">
                                        <label>{{ __('translations.available variables') }}</label>
                                        <ul>
                                            @foreach ($variables as $variable)
                                                <li>{{ $variable }}</li>
                                            @endforeach
                                        </ul>
                                    </div>

                                    <button type="submit" class="btn btn-primary">{{ __('translations.update') }}</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<script>
    document.getElementById('toggleActiveBtn').addEventListener('click', function() {
        // Safely pass the ID and current status from Blade to JavaScript
        const id = {{ json_encode($template->id) }};
        const currentStatus = {{ json_encode($template->active) }};
        const newStatus = currentStatus === 1 ? 0 : 1;

        // Get the button element
        var button = document.getElementById('toggleActiveBtn');
        button.disabled = true; // Disable the button to prevent duplicate clicks

        // Send the AJAX request to update the status
        fetch(`{{ route('admin.whatsappTemplate.updateStatus', ':id') }}`.replace(':id', id), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
                active: newStatus
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update the button appearance and text based on the new status
                if (newStatus === 1) {
                    button.classList.remove('btn-danger');
                    button.classList.add('btn-success');
                    button.innerText = '{{ __('translations.active') }}';
                } else {
                    button.classList.remove('btn-success');
                    button.classList.add('btn-danger');
                    button.innerText = '{{ __('translations.inactive') }}';
                }
            } else {
                // Show an error message if the backend fails
                alert(data.message || 'An error occurred while updating the status.');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while updating the status. Please try again.');
        })
        .finally(() => {
            button.disabled = false; // Re-enable the button regardless of success or failure
        });
    });
</script>

@endsection
