@extends('admin.layouts.main')
@section('title')
  {{ __('translations.expense-categories-edit') }}
@endsection
@section('sub-title')
    {{ __('translations.expense-categories-edit') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.expense-categories-edit') }}: {{ $expenseCategory->name }}</h3>
                </div>
                <div class="card-toolbar">
                  <a href="{{ route('admin.expense-categories.index') }}" class="btn btn-sm btn-light-primary">
                    {{ __('translations.back') }}
                  </a>
                </div>
              </div>
              <div class="card-body py-12">
                <form action="{{ route('admin.expense-categories.update', $expenseCategory->id) }}" method="post" class="form">
                  @csrf
                  @method('PUT')
                  <div class="row mb-12">
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label required">{{ __('translations.expense-category-name') }}</label>
                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $expenseCategory->name) }}" required>
                        @error('name')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group mb-6">
                        <label class="form-label">{{ __('translations.expense-category-description') }}</label>
                        <textarea name="description" rows="4" class="form-control @error('description') is-invalid @enderror">{{ old('description', $expenseCategory->description) }}</textarea>
                        @error('description')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12">
                      <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary">
                          <span class="indicator-label">{{ __('translations.update') }}</span>
                        </button>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
