@extends('admin.layouts.main')
@section('title')
  {{ __('translations.expenses-create') }}
@endsection
@section('sub-title')
  {{ __('translations.expenses-create') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.expenses-create') }}</h3>
                </div>
                <div class="card-toolbar">
                  <a href="{{ route('admin.expenses.index') }}" class="btn btn-sm btn-light-primary">
                    {{ __('translations.back') }}
                  </a>
                </div>
              </div>
              <div class="card-body py-12">
                <form action="{{ route('admin.expenses.store') }}" method="post" class="form" enctype="multipart/form-data">
                  @csrf
                  <div class="row mb-6">
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label required">{{ __('translations.expense-title') }}</label>
                        <input type="text" name="title" class="form-control @error('title') is-invalid @enderror" value="{{ old('title') }}" required>
                        @error('title')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label required">{{ __('translations.expense-amount') }}</label>
                        <input type="number" step="0.01" name="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" required>
                        @error('amount')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                  </div>

                  <div class="row mb-6">
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label required">{{ __('translations.expense-date') }}</label>
                        <input type="date" name="expense_date" class="form-control @error('expense_date') is-invalid @enderror" value="{{ old('expense_date', date('Y-m-d')) }}" required>
                        @error('expense_date')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label required">{{ __('translations.expense-category') }}</label>
                        <select name="expense_category_id" class="form-control @error('expense_category_id') is-invalid @enderror" required>
                          <option value="">{{ __('translations.select_category') }}</option>
                          @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('expense_category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                          @endforeach
                        </select>
                        @error('expense_category_id')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                  </div>

                  <div class="row mb-6">
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label">{{ __('translations.expense-status') }}</label>
                        <select name="status" class="form-control @error('status') is-invalid @enderror">
                          <option value="approved" {{ old('status') == 'approved' ? 'selected' : '' }}>{{ __('translations.expense-approved') }}</option>
                          <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>{{ __('translations.expense-pending') }}</option>
                          <option value="rejected" {{ old('status') == 'rejected' ? 'selected' : '' }}>{{ __('translations.expense-rejected') }}</option>
                        </select>
                        @error('status')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group mb-6">
                        <label class="form-label">{{ __('translations.expense-receipt') }}</label>
                        <input type="file" name="receipt_image" class="form-control @error('receipt_image') is-invalid @enderror">
                        @error('receipt_image')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                        <small class="text-muted">{{ __('translations.allowed_file_types') }}: JPG, PNG. {{ __('translations.max_file_size') }}: 2MB</small>
                      </div>
                    </div>
                  </div>

                  <div class="row mb-6">
                    <div class="col-md-12">
                      <div class="form-group mb-6">
                        <label class="form-label">{{ __('translations.expense-description') }}</label>
                        <textarea name="description" rows="4" class="form-control @error('description') is-invalid @enderror">{{ old('description') }}</textarea>
                        @error('description')
                          <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-12">
                      <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-primary">
                          <span class="indicator-label">{{ __('translations.create') }}</span>
                        </button>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
