@extends('admin.layouts.main')
@section('title')
  {{ __('translations.expenses-list') }}
@endsection
@section('sub-title')
  {{ __('translations.expenses-list') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.expenses-list') }}</h3>
                </div>
                <div class="card-toolbar">
                  <a href="{{ route('admin.expenses.create') }}" class="btn btn-primary">
                    <span class="svg-icon svg-icon-2">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none">
                        <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                          transform="rotate(-90 11.364 20.364)" fill="white" stroke="white" stroke-width="3"></rect>
                        <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="white"
                          stroke="white" stroke-width="3"></rect>
                      </svg>
                    </span>
                    <span>{{ __('translations.expenses-create') }}</span>
                  </a>
                </div>
              </div>
              <div class="card-body">
                <div class="d-flex align-items-center position-relative mb-4">
                  <span class="svg-icon svg-icon-1 position-absolute ms-4">
                    <svg width="18" height="18" viewBox="0 0 24 24">
                      <path fill="currentColor"
                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                    </svg>
                  </span>
                  <input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14"
                    placeholder="{{ __('translations.search') }}" />
                </div>
                @if(session('success'))
                  <div class="alert alert-success">
                      {{ session('success') }}
                  </div>
                @endif
                <table id="kt_datatable_example"
                  class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                  <thead>
                    <tr class="fw-bolder fs-8 text-uppercase gs-0">
                      <th>#</th>
                      <th>{{ __('translations.expense-title') }}</th>
                      <th>{{ __('translations.expense-amount') }}</th>
                      <th>{{ __('translations.expense-date') }}</th>
                      <th>{{ __('translations.expense-category') }}</th>
                      <th>{{ __('translations.expense-status') }}</th>
                      <th>{{ __('translations.actions') }}</th>
                    </tr>
                  </thead>
                  <tbody class="text-gray-800 fw-bold">
                    @foreach ($expenses as $expense)
                      <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $expense->title }}</td>
                        <td>{{ number_format($expense->amount, 2) }}</td>
                        <td>{{ $expense->expense_date->format('Y-m-d') }}</td>
                        <td>{{ $expense->category->name }}</td>
                        <td>
                          <span class="badge badge-{{ $expense->status == 'approved' ? 'success' : ($expense->status == 'pending' ? 'warning' : 'danger') }} cursor-pointer status-badge"
                                data-bs-toggle="modal" data-bs-target="#statusModal{{ $expense->id }}">
                            {{ $expense->status == 'approved' ? __('translations.expense-approved') : ($expense->status == 'pending' ? __('translations.expense-pending') : __('translations.expense-rejected')) }}
                          </span>

                          <!-- Status Change Modal -->
                          <div class="modal fade" id="statusModal{{ $expense->id }}" tabindex="-1" aria-labelledby="statusModalLabel{{ $expense->id }}" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-fullscreen-sm-down">
                              <div class="modal-content shadow-sm border-0">
                                <div class="modal-header bg-light">
                                  <h5 class="modal-title fw-bold" id="statusModalLabel{{ $expense->id }}">
                                    <i class="fas fa-edit me-2 text-primary"></i>{{ __('translations.change-expense-status') }}
                                  </h5>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{ __('translations.close') }}"></button>
                                </div>
                                <form action="{{ route('admin.expenses.updateStatus', $expense->id) }}" method="POST">
                                  @csrf
                                  @method('PATCH')
                                  <div class="modal-body py-4">
                                    <div class="text-center mb-4">
                                      <div class="d-inline-block p-3 rounded-circle
                                        {{ $expense->status == 'approved' ? 'bg-success' : ($expense->status == 'pending' ? 'bg-warning' : 'bg-danger') }}
                                        bg-opacity-10 mb-3">
                                        <i class="fas
                                          {{ $expense->status == 'approved' ? 'fa-check' : ($expense->status == 'pending' ? 'fa-clock' : 'fa-times') }}
                                          fa-2x
                                          {{ $expense->status == 'approved' ? 'text-success' : ($expense->status == 'pending' ? 'text-warning' : 'text-danger') }}
                                        "></i>
                                      </div>
                                      <h6 class="fw-semibold">{{ __('translations.expense-current-status') }}:
                                        <span class="badge badge-{{ $expense->status == 'approved' ? 'success' : ($expense->status == 'pending' ? 'warning' : 'danger') }}">
                                          {{ $expense->status == 'approved' ? __('translations.expense-approved') : ($expense->status == 'pending' ? __('translations.expense-pending') : __('translations.expense-rejected')) }}
                                        </span>
                                      </h6>
                                    </div>
                                    <div class="form-group">
                                      <label for="status" class="form-label fw-semibold">{{ __('translations.expense-new-status') }}</label>
                                      <select class="form-select form-select-solid" name="status" id="status" style="width: 80%;">
                                        <option value="pending" {{ $expense->status == 'pending' ? 'selected' : '' }}>{{ __('translations.expense-pending') }}</option>
                                        <option value="approved" {{ $expense->status == 'approved' ? 'selected' : '' }}>{{ __('translations.expense-approved') }}</option>
                                        <option value="rejected" {{ $expense->status == 'rejected' ? 'selected' : '' }}>{{ __('translations.expense-rejected') }}</option>
                                      </select>
                                    </div>
                                  </div>
                                  <div class="modal-footer border-top-0">
                                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                      <i class="fas fa-times-circle me-1"></i>{{ __('translations.close') }}
                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                      <i class="fas fa-save me-1"></i>{{ __('translations.save-changes') }}
                                    </button>
                                  </div>
                                </form>
                              </div>
                            </div>
                          </div>
                        </td>
                        <td>
                          <button class="btn btn-light btn-sm dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('translations.actions') }}
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="{{ route('admin.expenses.show', $expense->id) }}">
                              {{ __('translations.show') }}
                            </a>
                            <a class="dropdown-item" href="{{ route('admin.expenses.edit', $expense->id) }}">
                              {{ __('translations.edit') }}
                            </a>
                            <a class="dropdown-item" href="#"
                              onclick="event.preventDefault();
                                  if(confirm('{{ __('translations.deletemsg') }}')) {
                                  document.getElementById('delete-form-{{ $expense->id }}').submit();
                                  }">
                              {{ __('translations.delete') }}
                            </a>
                            <form id="delete-form-{{ $expense->id }}"
                              action="{{ route('admin.expenses.destroy', $expense->id) }}" method="post"
                              style="display: none;">
                              @csrf @method('DELETE')
                            </form>
                          </div>
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>

                <div class="d-flex justify-content-center mt-5">
                  {{ $expenses->links() }}
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection

@section('scripts')
<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Add cursor pointer styling and enhance mobile click handling
    document.querySelectorAll('.status-badge').forEach(badge => {
      badge.style.cursor = 'pointer';

      // Add additional touch event listener for mobile devices
      badge.addEventListener('touchend', function(e) {
        e.preventDefault();
        const targetId = this.getAttribute('data-bs-target');
        const modalElement = document.querySelector(targetId);
        if (modalElement) {
          const bsModal = new bootstrap.Modal(modalElement);
          bsModal.show();
        }
      });
    });
  });
</script>
@endsection
