@extends('admin.layouts.main')
@section('title')
  {{ __('translations.expenses-show') }}
@endsection
@section('sub-title')
  {{ __('translations.expenses-show') }}
@endsection
@section('content')
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0">{{ __('translations.expenses-show') }}: {{ $expense->title }}</h3>
                </div>
                <div class="card-toolbar">
                  <a href="{{ route('admin.expenses.index') }}" class="btn btn-sm btn-light-primary me-2">
                    <span class="svg-icon svg-icon-muted svg-icon-2hx">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path d="M9.60001 11H21C21.6 11 22 11.4 22 12C22 12.6 21.6 13 21 13H9.60001V11Z" fill="currentColor"/>
                        <path d="M6.2238 13.2561C5.54282 12.5572 5.54281 11.4429 6.22379 10.7439L10.377 6.48107C10.8779 5.96697 11.75 6.32158 11.75 7.03934V16.9607C11.75 17.6785 10.8779 18.0331 10.377 17.519L6.2238 13.2561Z" fill="currentColor"/>
                        <rect opacity="0.3" x="2" y="4" width="2" height="16" rx="1" fill="currentColor"/>
                      </svg>
                    </span>
                    {{ __('translations.back') }}
                  </a>
                  <a href="{{ route('admin.expenses.edit', $expense->id) }}" class="btn btn-sm btn-primary me-2">
                    <span class="svg-icon svg-icon-muted svg-icon-2hx">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                        <path opacity="0.3" d="M21.4 8.35303L19.241 10.511L13.485 4.755L15.643 2.59595C16.0248 2.21423 16.5426 1.99988 17.0825 1.99988C17.6224 1.99988 18.1402 2.21423 18.522 2.59595L21.4 5.474C21.7817 5.85581 21.9962 6.37355 21.9962 6.91345C21.9962 7.45335 21.7817 7.97122 21.4 8.35303ZM3.68699 21.932L9.88699 19.865L4.13099 14.109L2.06399 20.309C1.98815 20.5354 1.97703 20.7787 2.03189 21.0111C2.08674 21.2436 2.2054 21.4561 2.37449 21.6248C2.54359 21.7934 2.75641 21.9115 2.989 21.9658C3.22158 22.0201 3.4647 22.0084 3.69099 21.932H3.68699Z" fill="currentColor" />
                        <path d="M5.574 21.3L3.692 21.928C3.46591 22.0032 3.22334 22.0141 2.99144 21.9594C2.75954 21.9046 2.54744 21.7864 2.3789 21.6179C2.21036 21.4495 2.09202 21.2375 2.03711 21.0056C1.9822 20.7737 1.99289 20.5312 2.06799 20.3051L2.696 18.422L5.574 21.3ZM4.13499 14.105L9.891 19.861L19.245 10.507L13.489 4.75098L4.13499 14.105Z" fill="currentColor" />
                      </svg>
                    </span>
                    {{ __('translations.edit') }}
                  </a>
                </div>
              </div>
              <div class="card-body py-12">
                <div class="row mb-6">
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-title') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->title }}</div>
                  </div>
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-amount') }}</div>
                    <div class="fs-5 text-gray-600">{{ number_format($expense->amount, 2) }}</div>
                  </div>
                </div>

                <div class="row mb-6">
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-date') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->expense_date->format('Y-m-d') }}</div>
                  </div>
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-category') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->category->name }}</div>
                  </div>
                </div>

                <div class="row mb-6">
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-status') }}</div>
                    <div class="fs-5">
                      <span class="badge badge-{{ $expense->status == 'approved' ? 'success' : ($expense->status == 'pending' ? 'warning' : 'danger') }}">
                        {{ $expense->status == 'approved' ? __('translations.expense-approved') : ($expense->status == 'pending' ? __('translations.expense-pending') : __('translations.expense-rejected')) }}
                      </span>
                    </div>
                  </div>
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.Create By') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->creator ? $expense->creator->name : __('translations.not_specified') }}</div>
                  </div>
                </div>

                <div class="row mb-6">
                  <div class="col-lg-12">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-description') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->description ?: __('translations.no_description') }}</div>
                  </div>
                </div>

                @if($expense->receipt_image)
                <div class="row mb-6">
                  <div class="col-lg-12">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.expense-receipt') }}</div>
                    <div class="fs-5 text-gray-600">
                      <img src="{{ asset('storage/' . $expense->receipt_image) }}" alt="Receipt Image" style="max-width: 100%; max-height: 400px;">
                    </div>
                  </div>
                </div>
                @endif

                <div class="row mb-6">
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.created_at') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->created_at->format('Y-m-d H:i') }}</div>
                  </div>
                  <div class="col-lg-6">
                    <div class="fw-bold fs-5 text-gray-800 mb-2">{{ __('translations.updated_at') }}</div>
                    <div class="fs-5 text-gray-600">{{ $expense->updated_at->format('Y-m-d H:i') }}</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection
