<?php

use App\Exports\ClientsExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\RoomController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\ClientsController;
use App\Http\Controllers\Admin\DelayedController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\ReportsController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\DeliveryController;
use App\Http\Controllers\Admin\RecievedController;
use App\Http\Controllers\Admin\WhatsappController;
use App\Http\Controllers\Admin\Auth\AuthController;
use App\Http\Controllers\Admin\CancelledController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\DelayedCancelledController;
use App\Http\Controllers\Admin\DelayedDeliveriesController;
use App\Http\Controllers\Admin\DelayedOperationsController;
use App\Http\Controllers\Admin\DelayedReceptionsController;
use App\Http\Controllers\Admin\ExaminersController;
use App\Http\Controllers\Admin\OperationController;
use App\Http\Controllers\Admin\ReceptionController;
use App\Http\Controllers\Admin\ExaminationsController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\ExpenseController;
/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
*/
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');

Route::prefix('admin')->name('admin.')->group(function () {
    // login routes
    Route::post('login', [AuthController::class, 'login'])->name('login.store');

    Route::middleware(['auth', 'setLocale'])->group(function () {
        // dashboard routes
        Route::get('/', [DashboardController::class, 'index'])->name('index');

        // locale routes
        Route::post('locale', [DashboardController::class, 'setLocale'])->name('setLocale');



        // users routes
        Route::resource('users', UserController::class)->except('show');

        // roles routes
        Route::resource('roles', RoleController::class)->except('show');

        // clients routes
        Route::resource('clients', ClientsController::class);
        Route::get('/cities/{cityId}/regions', [ClientsController::class, 'getRegionsByCity']);
        // Route::get('/get-client-details', [ClientsController::class, 'getClientDetails'])->name('getClientDetails');
        Route::get('/get-examination-details', [ClientsController::class, 'getExaminationDetails']);





        // rooms routes
        Route::resource('rooms', RoomController::class)->except('show');

        // examinations routes
        Route::resource('examinations', ExaminationsController::class);
        Route::post('examinations/{id}/update-status-inline', [ExaminationsController::class, 'updateStatusInline'])->name('examinations.update-status.inline');
        Route::post('examinations/{id}/update-category-inline', [ExaminationsController::class, 'updateCategoryInline'])->name('examinations.update-category');
        Route::get('examinations/{id}/update-status', [ExaminationsController::class, 'updateStatusForm'])->name('examinations.update-status');
        Route::post('examinations/{id}/update-status', [ExaminationsController::class, 'updateStatus'])->name('examinations.update-status');
        Route::post('admin/examinations/{id}/confirm', [ExaminationsController::class, 'confirmExamination'])->name('examinations.confirm');
        Route::get('examinations/{id}/print', [ExaminationsController::class, 'print'])->name('examinations.print');
        Route::get('examination/data', [ExaminationsController::class, 'sateAjax'])->name('examinations.sateAjax');
        Route::get('examination/last', [ExaminationsController::class, 'fetchLastExamination'])->name('examination.last');


        // Route::get('/get-examination-details', [ExaminationsController::class, 'getExaminationDetails']);

        Route::get('/admin/clients', [ReportsController::class, 'clients'])->name('client.all');
        Route::get('/admin/clients/filter', [ReportsController::class, 'filter_client'])->name('clients.filter');




        Route::get('/admin/clients/export', function () {
            return Excel::download(new ClientsExport, 'clients.xlsx');
        })->name('clients.export');








        // examinations routes
        Route::resource('examiners', ExaminersController::class)->except('show');


        Route::resource('reports', ReportsController::class)->except('show');
        Route::get('reports/examiners', [ReportsController::class, 'examiner'])->name('reports.examiner');
        Route::get('reports/rooms', [ReportsController::class, 'room'])->name('reports.room');
        Route::get('/reports/filter', [ReportsController::class, 'filter'])->name('reports.filter');



        // receptions routes
        Route::resource('receptions', ReceptionController::class);

        Route::post('receptions/{id}/update-status', [ReceptionController::class, 'updateStatus'])->name('receptions.update-status');
        Route::post('receptions/{id}/update-special', [ReceptionController::class, 'updateSpecial'])->name('receptions.update-special');
        Route::get('receptions/{id}/print', [ReceptionController::class, 'print'])->name('receptions.print');
        Route::get('receptions/print_special/{id}', [ReceptionController::class, 'printSpecial'])->name('receptions.print_special');
        Route::get('receptions/{id}/show_examination', [ReceptionController::class, 'show_examination'])->name('receptions.show_examination');


        // invoices routes
        Route::resource('invoices', InvoiceController::class);
        Route::get('invoices/{id}/update-status', [InvoiceController::class, 'updateStatusForm'])->name('invoices.update-status');
        Route::post('invoices/{id}/update-status', [InvoiceController::class, 'updateStatus'])->name('invoices.update-status.submit');
        Route::post('invoices/{id}/update-special', [InvoiceController::class, 'updateSpecial'])->name('invoices.update-special');
        Route::get('invoices/{id}/print', [InvoiceController::class, 'print'])->name('invoices.print');
        Route::get('invoices/print_special/{id}', [InvoiceController::class, 'printSpecial'])->name('invoices.print_special');
        Route::get('invoices/{id}/show_examination', [InvoiceController::class, 'show_examination'])->name('invoices.show_examination');

        //Categories routes
        Route::resource('categories', CategoryController::class);

        //Products routes
        Route::resource('products', ProductController::class);

        // Expenses routes
        Route::resource('expense-categories', ExpenseCategoryController::class);
        Route::resource('expenses', ExpenseController::class);
        Route::patch('expenses/{expense}/update-status', [ExpenseController::class, 'updateStatus'])->name('expenses.updateStatus');

        // Financial Reports routes
        Route::prefix('financial-reports')->name('financial-reports.')->controller(App\Http\Controllers\Admin\FinancialReportsController::class)->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('/expenses', 'expenses')->name('expenses');
            Route::get('/profits', 'profits')->name('profits');
            Route::get('/sales', 'sales')->name('sales');
            Route::get('/top-products', 'topProducts')->name('top-products');
        });

        // operations routes
        Route::resource('operations', OperationController::class);
        Route::get('operations/{id}/update-status', [OperationController::class, 'updateStatusForm'])->name('operations.update-status');
        Route::post('operations/{id}/update-status', [OperationController::class, 'updateStatus'])->name('operations.update-status.submit');
        Route::post('operations/{id}/update-special', [OperationController::class, 'updateSpecial'])->name('operations.update-special');
        Route::get('operations/{id}/update-category', [OperationController::class, 'updateCategoryForm'])->name('operations.update-category');
        Route::post('operations/{id}/update-category', [OperationController::class, 'updateCategory'])->name('operations.update-category.submit');
        Route::get('operations/{id}/print', [OperationController::class, 'print'])->name('operations.print');
        Route::get('operations/print_special/{id}', [OperationController::class, 'printSpecial'])->name('operations.print_special');


        // deliveries routes
        Route::resource('deliveries', DeliveryController::class);
        Route::get('deliveries/{id}/update-status', [DeliveryController::class, 'updateStatusForm'])->name('deliveries.update-status');
        Route::post('deliveries/{id}/update-status', [DeliveryController::class, 'updateStatus'])->name('deliveries.update-status.submit');
        Route::post('deliveries/{id}/update-special', [DeliveryController::class, 'updateSpecial'])->name('deliveries.update-special');
        Route::get('deliveries/{id}/print', [DeliveryController::class, 'print'])->name('deliveries.print');
        Route::get('deliveries/print_special/{id}', [DeliveryController::class, 'printSpecial'])->name('deliveries.print_special');

        // deliveries routes
        Route::resource('recieveds', RecievedController::class);
        Route::get('recieveds/{id}/update-status', [RecievedController::class, 'updateStatusForm'])->name('recieveds.update-status');
        Route::post('recieveds/{id}/update-status', [RecievedController::class, 'updateStatus'])->name('recieveds.update-status.submit');
        Route::post('recieveds/{id}/update-special', [RecievedController::class, 'updateSpecial'])->name('recieveds.update-special');
        Route::get('recieveds/print_special/{id}', [RecievedController::class, 'printSpecial'])->name('recieveds.print_special');


        // cancelled routes
        Route::resource('cancelled', CancelledController::class);
        Route::get('cancelled/{id}/update-status', [CancelledController::class, 'updateStatusForm'])->name('cancelled.update-status');
        Route::post('cancelled/{id}/update-status', [CancelledController::class, 'updateStatus'])->name('cancelled.update-status.submit');
        Route::post('cancelled/{id}/update-special', [CancelledController::class, 'updateSpecial'])->name('cancelled.update-special');
        Route::get('cancelled/{id}/print', [CancelledController::class, 'print'])->name('cancelled.print');
        Route::get('cancelled/print_special/{id}', [CancelledController::class, 'printSpecial'])->name('cancelled.print_special');


        // delayed routes
        Route::resource('delayed', DelayedController::class);
        Route::post('delayed/{id}/update-status', [DelayedController::class, 'updateStatus'])->name('delayed.update-status');
        Route::post('delayed/{id}/update-special', [DelayedController::class, 'updateSpecial'])->name('delayed.update-special');
        Route::get('delayed/{id}/print', [DelayedController::class, 'print'])->name('delayed.print');
        Route::get('delayed/{id}/show_examination', [DelayedController::class, 'show_examination'])->name('delayed.show_examination');
        Route::get('delayed/print_special/{id}', [DelayedController::class, 'printSpecial'])->name('delayed.print_special');


        // delayed routes
        Route::resource('delayed-receptions', DelayedReceptionsController::class);
        Route::post('delayed-receptions/{id}/update-status', [DelayedReceptionsController::class, 'updateStatus'])->name('delayed.receptions.update-status');
        Route::post('delayed-receptions/{id}/update-special', [DelayedReceptionsController::class, 'updateSpecial'])->name('delayed.receptions.update-special');
        Route::get('delayed-receptions/{id}/print', [DelayedReceptionsController::class, 'print'])->name('delayed.receptions.print');
        Route::get('delayed-receptions/print_special/{id}', [DelayedReceptionsController::class, 'printSpecial'])->name('delayed.receptions.print_special');
        Route::get('delayed-receptions/{id}/show_examination', [DelayedReceptionsController::class, 'show_examination'])->name('delayed.receptions.show_examination');


        // delayed-operations routes
        Route::resource('delayed-operations', DelayedOperationsController::class);
        Route::post('delayed-operations/{id}/update-status', [DelayedOperationsController::class, 'updateStatus'])->name('delayed.operations.update-status');
        Route::post('delayed-operations/{id}/update-special', [DelayedOperationsController::class, 'updateSpecial'])->name('delayed.operations.update-special');
        Route::get('delayed-operations/{id}/print', [DelayedOperationsController::class, 'print'])->name('delayed.operations.print');
        Route::get('delayed-operations/{id}/show_examination', [DelayedOperationsController::class, 'show_examination'])->name('delayed.operations.show_examination');
        Route::get('delayed-operations/print_special/{id}', [DelayedOperationsController::class, 'printSpecial'])->name('delayed.operations.print_special');


        // delayed routes
        Route::resource('delayed-deliveries', DelayedDeliveriesController::class);
        Route::post('delayed-deliveries/{id}/update-status', [DelayedDeliveriesController::class, 'updateStatus'])->name('delayed.deliveries.update-status');
        Route::post('delayed-deliveries/{id}/update-special', [DelayedDeliveriesController::class, 'updateSpecial'])->name('delayed.deliveries.update-special');
        Route::get('delayed-deliveries/{id}/print', [DelayedDeliveriesController::class, 'print'])->name('delayed.deliveries.print');
        Route::get('delayed-deliveries/print_special/{id}', [DelayedDeliveriesController::class, 'printSpecial'])->name('delayed.deliveries.print_special');
        Route::get('delayed-deliveries/{id}/show_examination', [DelayedDeliveriesController::class, 'show_examination'])->name('delayed.deliveries.show_examination');











        // settings routes
        Route::get('settings-management', [SettingController::class, 'all'])->name('settings');
        Route::get('settings', [SettingController::class, 'index'])->name('settings.general');
        Route::post('settings/update', [SettingController::class, 'update'])->name('settings.update');

        Route::get('theme-settings', [App\Http\Controllers\Admin\ThemeSettingsController::class, 'index'])->name('settings.theme');
        Route::post('theme-settings/update', [App\Http\Controllers\Admin\ThemeSettingsController::class, 'update'])->name('settings.theme.update');
        Route::get('theme-presets', [App\Http\Controllers\Admin\ThemeSettingsController::class, 'presets'])->name('settings.theme.presets');
        Route::post('theme-presets/apply', [App\Http\Controllers\Admin\ThemeSettingsController::class, 'applyPreset'])->name('settings.theme.presets.apply');

        Route::get('whatsapp', [SettingController::class, 'whatsapp'])->name('settings.whatsapp');
        Route::post('whatsapp/update', [SettingController::class, 'whatsapp_update'])->name('settings.whatsapp.update');
        Route::post('whatsapp/update-status', [SettingController::class, 'updateStatus'])->name('settings.whatsapp.updateStatus');

        Route::get('whatsapp-template', [WhatsAppController::class, 'home'])->name('whatsapp.template.home');
        Route::get('whatsapp-template-show{id}', [WhatsAppController::class, 'show'])->name('whatsapp.show');
        Route::put('whatsapp-template-update{id}', [WhatsAppController::class, 'update'])->name('whatsapp.update');
        Route::post('whatsapp-template/update-status{id}', [WhatsAppController::class, 'updateStatus'])->name('whatsappTemplate.updateStatus');
        Route::get('/settings/cron-job', [WhatsAppController::class, 'cron'])->name('settings.cron-job');

        // profile routes
        Route::get('profile', [ProfileController::class, 'index'])->name('profile.index');
        Route::put('profile/update', [ProfileController::class, 'update'])->name('profile.update');
        Route::put('profile/picture/update', [ProfileController::class, 'updatePicture'])->name('profile.picture.update');
        Route::put('profile/password/update', [ProfileController::class, 'updatePassword'])->name('profile.password.update');

        // logout routes
        Route::post('logout', [AuthController::class, 'logout'])->name('logout');



        // invotek routes
        Route::get('invotek', [SettingController::class, 'invotek'])->name('settings.invotek');
        Route::post('invotek/update', [SettingController::class, 'invotek_update'])->name('settings.invotek.update');

        Route::get('return-invoices', [InvoiceController::class, 'returnInvoiceIndex'])->name('invoices.return-invoice-index');
        Route::post('return-invoice/{id}', [InvoiceController::class, 'returnInvoice'])->name('invoices.return-invoice');
        Route::post('resend-invoice/{id}', [InvoiceController::class, 'resendInvoice'])->name('invoices.resend-invoice');
        Route::get('not-resend-invoices', [InvoiceController::class, 'notResendInvoiceIndex'])->name('invoices.not-resend-invoice-index');

        // Database backup routes
        Route::get('backups', [App\Http\Controllers\Admin\BackupController::class, 'index'])->name('settings.backups');
        Route::get('backups/create', [App\Http\Controllers\Admin\BackupController::class, 'create'])->name('settings.backups.create');
        Route::get('backups/download/{filename}', [App\Http\Controllers\Admin\BackupController::class, 'download'])->name('settings.backups.download');
        Route::get('backups/delete/{filename}', [App\Http\Controllers\Admin\BackupController::class, 'delete'])->name('settings.backups.delete');

        // Cache management routes
        Route::get('cache', [App\Http\Controllers\Admin\CacheController::class, 'index'])->name('settings.cache');
        Route::get('cache/clear-cache', [App\Http\Controllers\Admin\CacheController::class, 'clearCache'])->name('settings.cache.clear-cache');
        Route::get('cache/clear-view', [App\Http\Controllers\Admin\CacheController::class, 'clearView'])->name('settings.cache.clear-view');
        Route::get('cache/clear-config', [App\Http\Controllers\Admin\CacheController::class, 'clearConfig'])->name('settings.cache.clear-config');
        Route::get('cache/clear-route', [App\Http\Controllers\Admin\CacheController::class, 'clearRoute'])->name('settings.cache.clear-route');
        Route::get('cache/clear-logs', [App\Http\Controllers\Admin\CacheController::class, 'clearLogs'])->name('settings.cache.clear-logs');
        Route::get('cache/clear-all', [App\Http\Controllers\Admin\CacheController::class, 'clearAll'])->name('settings.cache.clear-all');
    });
});
