<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\FrontendController;
use Illuminate\Support\Facades\File;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
*/

// واجهة الموقع
Route::middleware(['setLocale'])->group(function () {
    // locale routes
    Route::post('locale', [HomeController::class, 'setLocale'])->name('setLocale');

    // frontend routes
    Route::get('/', function() {
        return File::get(public_path() . '/landing/index.html');
    })->name('front.index');

});

// لوحة التحكم (قم بتحميلها بعد المسارات الرئيسية لتجنب التعارض)
require __DIR__.'/admin/web.php';
