-- Database: tikpart_eyes
-- Generated on: 2025-04-16 17:20:22

SET FOREIGN_KEY_CHECKS=0;

-- Table structure for table `cancelleds`
DROP TABLE IF EXISTS `cancelleds`;
CREATE TABLE `cancelleds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `examination_id` bigint unsigned NOT NULL,
  `status` enum('في انتظار التاكيد','الغاء') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'الغاء',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cancelleds_examination_id_foreign` (`examination_id`),
  CONSTRAINT `cancelleds_examination_id_foreign` FOREIGN KEY (`examination_id`) REFERENCES `examinations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `categories`
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `categories`
INSERT INTO `categories` VALUES (1,'نظارات','2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'عدسات','2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'منتجات أخرى','2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `cities`
DROP TABLE IF EXISTS `cities`;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `cities`
INSERT INTO `cities` VALUES (1,'عمان','2025-04-16 00:08:34','2025-04-16 00:08:34'),(2,'إربد','2025-04-16 00:08:34','2025-04-16 00:08:34'),(3,'الزرقاء','2025-04-16 00:08:34','2025-04-16 00:08:34'),(4,'العقبة','2025-04-16 00:08:34','2025-04-16 00:08:34'),(5,'المفرق','2025-04-16 00:08:34','2025-04-16 00:08:34'),(6,'جرش','2025-04-16 00:08:34','2025-04-16 00:08:34'),(7,'مادبا','2025-04-16 00:08:34','2025-04-16 00:08:34'),(8,'السلط','2025-04-16 00:08:34','2025-04-16 00:08:34'),(9,'الكرك','2025-04-16 00:08:34','2025-04-16 00:08:34'),(10,'الطفيلة','2025-04-16 00:08:34','2025-04-16 00:08:34'),(11,'معان','2025-04-16 00:08:34','2025-04-16 00:08:34'),(12,'عجلون','2025-04-16 00:08:34','2025-04-16 00:08:34');

-- Table structure for table `clients`
DROP TABLE IF EXISTS `clients`;
CREATE TABLE `clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` enum('man','woman') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `region_id` bigint unsigned DEFAULT NULL,
  `country_code` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clients_city_id_index` (`city_id`),
  KEY `clients_region_id_index` (`region_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `clients`
INSERT INTO `clients` VALUES (1,'محمد','عبد الرحمن',1095193236,NULL,20,'123 Street, Cairo, Egypt',1,1,NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'محمود','احمد',01118759692,NULL,20,'456 Street, Giza, Egypt',2,2,NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `company_info`
DROP TABLE IF EXISTS `company_info`;
CREATE TABLE `company_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iconImage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `contactus`
DROP TABLE IF EXISTS `contactus`;
CREATE TABLE `contactus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `svgIcon` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `URL` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `countries`
DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name_ar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Country name in Arabic',
  `code` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Country code',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `countries`
INSERT INTO `countries` VALUES (1,'السعودية','SA',+966,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'مصر','EG',+20,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'الإمارات','AE',+971,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(4,'الكويت','KW',+965,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(5,'قطر','QA',+974,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(6,'البحرين','BH',+973,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(7,'عمان','OM',+968,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(8,'اليمن','YE',+967,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(9,'الأردن','JO',+962,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(10,'العراق','IQ',+964,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(11,'سوريا','SY',+963,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(12,'لبنان','LB',+961,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(13,'فلسطين','PS',+970,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(14,'الجزائر','DZ',+213,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(15,'المغرب','MA',+212,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(16,'تونس','TN',+216,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(17,'ليبيا','LY',+218,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(18,'السودان','SD',+249,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(19,'موريتانيا','MR',+222,'2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `cvs`
DROP TABLE IF EXISTS `cvs`;
CREATE TABLE `cvs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pdf` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `data`
DROP TABLE IF EXISTS `data`;
CREATE TABLE `data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `data_rt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_lt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lpd_rt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lpd_lt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `add_rt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `add_lt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_code` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `data_room_code_index` (`room_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `deliveries`
DROP TABLE IF EXISTS `deliveries`;
CREATE TABLE `deliveries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `examination_id` bigint unsigned NOT NULL,
  `status` enum('بانتظار الاستلام',' الغاء') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'بانتظار الاستلام',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deliveries_examination_id_foreign` (`examination_id`),
  CONSTRAINT `deliveries_examination_id_foreign` FOREIGN KEY (`examination_id`) REFERENCES `examinations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `examination_details`
DROP TABLE IF EXISTS `examination_details`;
CREATE TABLE `examination_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `sph` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cyl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `axis` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lpd` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('R','L') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `examination_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `examination_details_examination_id_foreign` (`examination_id`),
  CONSTRAINT `examination_details_examination_id_foreign` FOREIGN KEY (`examination_id`) REFERENCES `examinations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `examination_details`
INSERT INTO `examination_details` VALUES (1,0,0,NULL,0.00,NULL,'R',1,'2025-04-16 00:52:14','2025-04-16 00:52:14'),(2,0,0,NULL,0.00,NULL,'L',1,'2025-04-16 00:52:14','2025-04-16 00:52:14');

-- Table structure for table `examinations`
DROP TABLE IF EXISTS `examinations`;
CREATE TABLE `examinations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('نظارات','عدسات') COLLATE utf8mb4_unicode_ci NOT NULL,
  `make_from` enum('examinations','receptions') COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('في انتظار التاكيد','ارسال الي المشغل','تم التجهيز','تم الاستلام','الغاء') COLLATE utf8mb4_unicode_ci NOT NULL,
  `special` enum('عادي','مميز','مستعجل','تحضير','توصيل') COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` enum('a','b','c','d') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `room_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_id` bigint unsigned DEFAULT NULL,
  `examiner_id` bigint unsigned NOT NULL,
  `create_by` bigint unsigned DEFAULT NULL,
  `update_by` bigint unsigned DEFAULT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `examinations_room_code_index` (`room_code`),
  KEY `examinations_client_id_index` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `examinations`
INSERT INTO `examinations` VALUES (1,'P-001',NULL,NULL,'نظارات','receptions','في انتظار التاكيد','عادي',NULL,NULL,1,12,3,3,'P','2025-04-16 00:52:14','2025-04-16 00:52:14');

-- Table structure for table `examiners`
DROP TABLE IF EXISTS `examiners`;
CREATE TABLE `examiners` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `examiners_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `examiners`
INSERT INTO `examiners` VALUES (1,'Dr. Yasser Khaled','yasser.khaled@example.com',01011223344,'101 Elm Street, Cairo, Egypt',42,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'Dr. Layla Ramadan','layla.ramadan@example.com',01233445566,'202 Maple Road, Giza, Egypt',35,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'Dr. Samir Fawzy','samir.fawzy@example.com',01055667788,'303 Oak Avenue, Alexandria, Egypt',48,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(4,'Dr. Rania Hossam','rania.hossam@example.com',01166778899,'404 Pine Street, Tanta, Egypt',38,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(5,'Dr. Khaled Mostafa','khaled.mostafa@example.com',01578889900,'505 Birch Lane, Mansoura, Egypt',52,'2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `expense_categories`
DROP TABLE IF EXISTS `expense_categories`;
CREATE TABLE `expense_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_created_by_foreign` (`created_by`),
  KEY `expense_categories_updated_by_foreign` (`updated_by`),
  CONSTRAINT `expense_categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `expense_categories_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `expense_categories`
INSERT INTO `expense_categories` VALUES (1,'الإيجار والسكن','تشمل الإيجار، الرهن العقاري، والصيانة المنزلية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'المرافق','الكهرباء، الماء، الغاز، الإنترنت، الهاتف',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'الطعام','البقالة، المطاعم، الطلبات الخارجية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(4,'النقل','الوقود، صيانة السيارة، النقل العام، التاكسي',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(5,'الصحة','التأمين الصحي، الأدوية، زيارات الطبيب، العلاجات الطبية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(6,'التعليم','الرسوم الدراسية، الكتب، اللوازم المدرسية، الدورات التدريبية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(7,'الملابس','الملابس، الأحذية، الإكسسوارات',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(8,'الترفيه','السينما، الرياضة، السفر، الهوايات',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(9,'الديون','سداد القروض، بطاقات الائتمان، الديون الشخصية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(10,'التوفير والاستثمار','حسابات التوفير، الاستثمارات، صناديق التقاعد',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(11,'الهدايا والتبرعات','الهدايا، التبرعات الخيرية، المناسبات الاجتماعية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(12,'الضرائب','ضريبة الدخل، ضريبة الممتلكات، الضرائب الأخرى',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(13,'التأمين','تأمين السيارة، تأمين المنزل، تأمين الحياة',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(14,'الاشتراكات','اشتراكات الخدمات الرقمية، الصحف، المجلات، النوادي',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(15,'العناية الشخصية','مستحضرات التجميل، الحلاقة، الصالونات',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(16,'الأجهزة والإلكترونيات','الهواتف، الكمبيوترات، الأجهزة المنزلية',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(17,'مصاريف الأطفال','الحضانة، الألعاب، مستلزمات الأطفال',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(18,'مصاريف الحيوانات الأليفة','الطعام، الرعاية البيطرية، مستلزمات الحيوانات',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(19,'الاتصالات','فواتير الهاتف المحمول، الإنترنت، خدمات الاتصالات',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(20,'أخرى','مصاريف متنوعة غير مصنفة في الفئات السابقة',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `expenses`
DROP TABLE IF EXISTS `expenses`;
CREATE TABLE `expenses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `expense_date` date NOT NULL,
  `expense_category_id` bigint unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `receipt_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'approved',
  `created_by` bigint unsigned DEFAULT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_expense_category_id_foreign` (`expense_category_id`),
  KEY `expenses_created_by_foreign` (`created_by`),
  KEY `expenses_updated_by_foreign` (`updated_by`),
  CONSTRAINT `expenses_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `expenses_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `expenses`
INSERT INTO `expenses` VALUES (1,'Consectetur irure h',59.00,'2017-08-21',18,'Ab rerum corrupti mطكمط',NULL,'approved',1,NULL,'2025-04-16 00:36:07','2025-04-16 00:36:07'),(2,'شهر4',10.00,'2025-04-16',1,NULL,NULL,'approved',1,NULL,'2025-04-16 17:14:46','2025-04-16 17:14:46');

-- Table structure for table `failed_jobs`
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `gallery`
DROP TABLE IF EXISTS `gallery`;
CREATE TABLE `gallery` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `header_info`
DROP TABLE IF EXISTS `header_info`;
CREATE TABLE `header_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `invoice_details`
DROP TABLE IF EXISTS `invoice_details`;
CREATE TABLE `invoice_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `invoice_details`
INSERT INTO `invoice_details` VALUES (1,'نظارات جاهزة',100,1,100.00,0,1,1,'2025-04-16 00:52:13','2025-04-16 00:52:13'),(2,'نظارات جاهزة',100,1,100.00,0,2,1,'2025-04-16 17:12:28','2025-04-16 17:12:28');

-- Table structure for table `invoices`
DROP TABLE IF EXISTS `invoices`;
CREATE TABLE `invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `number` bigint NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `origin_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `original_uid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_method_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sent_to_invotek` tinyint(1) NOT NULL DEFAULT '0',
  `einv_qr` text COLLATE utf8mb4_unicode_ci,
  `issue_date` date NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoices_number_unique` (`number`),
  UNIQUE KEY `invoices_uuid_unique` (`uuid`),
  UNIQUE KEY `invoices_origin_number_unique` (`origin_number`),
  UNIQUE KEY `invoices_original_uid_unique` (`original_uid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `invoices`
INSERT INTO `invoices` VALUES (1,202504160001,NULL,NULL,NULL,NULL,100.00,'returned',011,1,2,'AQACAnt9AwVmYWxzZQQBMgUHRUlONTQ0NQYABwoyMDI1LTAyLTI1CAcxMjUwMTQwCTfYudio2K/Yp9mE2YTYqSDZhdit2YXYr9iw2YrYqCDYudio2K/Yp9mE2YTYqSDYs9mE2LfYp9mGCmBNRVFDSUZvZ1lqeWkzcDVteHUwSnVRZUtZM09hbEVzSy9yak1PVk5HcUFXMUMrRGFBaUErTkZ6SUtaY1I4M1lxVmFkNlJuakFMTjBZK1dkNDNpOWpIR0dXRVNOZ3F3PT0=','2025-04-16',NULL,'2025-04-16 00:52:13','2025-04-16 17:12:29'),(2,202504160002,NULL,202504160001,'78fe9cf4-5b53-425a-97bc-12e627aad3a9','ارجاع',100.00,'pending',011,1,0,NULL,'2025-04-16',NULL,'2025-04-16 17:12:28','2025-04-16 17:12:28');

-- Table structure for table `invoteks`
DROP TABLE IF EXISTS `invoteks`;
CREATE TABLE `invoteks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `user_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('income','general') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'income',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `invoteks`
INSERT INTO `invoteks` VALUES (1,'https://invotik-live.innovationstars.net',1,48236968,'income','2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `jobs`
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `media`
DROP TABLE IF EXISTS `media`;
CREATE TABLE `media` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `collection_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `disk` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `conversions_disk` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` bigint unsigned NOT NULL,
  `manipulations` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_properties` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `generated_conversions` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `responsive_images` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_column` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `messages`
DROP TABLE IF EXISTS `messages`;
CREATE TABLE `messages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `migrations`
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `migrations`
INSERT INTO `migrations` VALUES (1,'2013_11_25_143904_create_rooms_table',1),(2,'2014_10_12_000000_create_users_table',1),(3,'2014_10_12_100000_create_password_reset_tokens_table',1),(4,'2019_08_19_000000_create_failed_jobs_table',1),(5,'2019_12_14_000001_create_personal_access_tokens_table',1),(6,'2024_11_12_132057_laratrust_setup_tables',1),(7,'2024_11_20_180817_create_company_info_table',1),(8,'2024_11_20_180917_create_contactus_table',1),(9,'2024_11_20_180942_create_cvs_table',1),(10,'2024_11_20_180957_create_gallery_table',1),(11,'2024_11_20_181005_create_header_info_table',1),(12,'2024_11_20_181159_create_media_table',1),(13,'2024_11_20_181210_create_messages_table',1),(14,'2024_11_20_181912_create_user_profiles_table',1),(15,'2024_11_21_185441_create_clients_table',1),(16,'2024_11_21_185751_create_cities_table',1),(17,'2024_11_21_185820_create_regions_table',1),(18,'2024_11_21_784588_create_settings_table',1),(19,'2024_11_21_784598_create_settings_translations_table',1),(20,'2024_11_22_175931_create_examiners_table',1),(21,'2024_11_22_203613_create_examinations_table',1),(22,'2024_11_22_204505_create_examination_details_table',1),(23,'2024_11_24_091659_create_receptions_table',1),(24,'2024_11_24_112420_create_operations_table',1),(25,'2024_11_24_114117_create_deliveries_table',1),(26,'2024_11_24_134142_create_cancelleds_table',1),(27,'2024_11_25_105056_create_recieveds_table',1),(28,'2024_11_25_134945_create_whatsapps_table',1),(29,'2024_11_25_144314_create_data_table',1),(30,'2024_11_27_131639_create_whatsapp_templates_table',1),(31,'2024_12_03_112552_create_jobs_table',1),(32,'2024_12_09_215939_create_countries_table',1),(33,'2025_04_11_204829_create_categories_table',1),(34,'2025_04_11_204846_create_products_table',1),(35,'2025_04_11_205148_create_invoices_table',1),(36,'2025_04_11_205207_create_invoice_details_table',1),(37,'2025_04_11_220322_create_invoteks_table',1),(38,'2025_04_15_201017_create_expense_categories_table',1),(39,'2025_04_15_201027_create_expenses_table',1),(40,'2025_04_15_230018_create_theme_settings_table',1);

-- Table structure for table `operations`
DROP TABLE IF EXISTS `operations`;
CREATE TABLE `operations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `examination_id` bigint unsigned NOT NULL,
  `status` enum('ارسال الي المشغل',' الغاء') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ارسال الي المشغل',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `operations_examination_id_foreign` (`examination_id`),
  CONSTRAINT `operations_examination_id_foreign` FOREIGN KEY (`examination_id`) REFERENCES `examinations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `password_reset_tokens`
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `permission_role`
DROP TABLE IF EXISTS `permission_role`;
CREATE TABLE `permission_role` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `permission_role`
INSERT INTO `permission_role` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(1,2),(2,2),(3,2),(4,2),(5,2),(6,2),(7,2),(8,2),(9,2),(10,2),(11,2),(12,2),(13,2),(14,2),(15,2),(16,2),(17,2),(18,2),(19,2),(20,2),(21,2),(22,2),(23,2),(24,2),(25,2),(26,2),(27,2),(28,2),(29,2),(30,2),(31,2),(32,2),(33,2),(34,2),(35,2),(36,2),(37,2),(38,2),(39,2),(40,2),(41,2),(42,2),(43,2),(44,2),(45,2),(46,2),(47,2),(48,2),(49,2);

-- Table structure for table `permission_user`
DROP TABLE IF EXISTS `permission_user`;
CREATE TABLE `permission_user` (
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`permission_id`,`user_type`),
  KEY `permission_user_permission_id_foreign` (`permission_id`),
  CONSTRAINT `permission_user_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `permissions`
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `permissions`
INSERT INTO `permissions` VALUES (1,'dashboard-view','عرض لوحة التحكم',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(2,'roles-list','عرض مستوى الصلاحيات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(3,'roles-create','اضافة مستوى الصلاحيات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(4,'roles-edit','تعديل مستوى الصلاحيات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(5,'roles-delete','حذف مستوى الصلاحيات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(6,'users-list','عرض المستخدمين',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(7,'users-create','اضافة المستخدمين',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(8,'users-edit','تعديل المستخدمين',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(9,'users-delete','حذف المستخدمين',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(10,'clients-list','عرض العملاء',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(11,'clients-show','عرض العملاء',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(12,'clients-create','اضافة العملاء',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(13,'clients-edit','تعديل العملاء',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(14,'clients-delete','حذف العملاء',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(15,'reports-examinations','عرض  تقرير الفحوصات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(16,'reports-clients','عرض  تقرير العملاء',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(17,'receptions-list','عرض  قائمة الاستقبال',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(18,'receptions-create','اضافة فحص سريع',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(19,'receptions-edit','تعديل فحص سريع',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(20,'receptions-show','عرض  فحوصات الاستقبال',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(21,'receptions-delete','حذف فحوصات ',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(22,'settings','اعدادات النظام',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(23,'whatsapp','اعدادات الواتساب',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(24,'categories-list','عرض  قائمة الاصناف',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(25,'categories-create','اضافة الاصناف',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(26,'categories-edit','تعديل الاصناف',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(27,'categories-delete','حذف الاصناف',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(28,'products-list','عرض  قائمة المنتجات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(29,'products-create','اضافة المنتجات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(30,'products-edit','تعديل المنتجات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(31,'products-delete','حذف المنتجات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(32,'products-show','عرض المنتجات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(33,'expense-categories-list','عرض فئات المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(34,'expense-categories-create','إضافة فئات المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(35,'expense-categories-edit','تعديل فئات المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(36,'expense-categories-delete','حذف فئات المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(37,'expenses-list','عرض المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(38,'expenses-create','إضافة المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(39,'expenses-edit','تعديل المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(40,'expenses-show','عرض تفاصيل المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(41,'expenses-delete','حذف المصروفات',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(42,'invoices-list','عرض  قائمة الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(43,'invoices-create','اضافة الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(44,'invoices-edit','تعديل الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(45,'invoices-show','عرض الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(46,'invoices-delete','حذف الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(47,'invoices-return','ارجاع الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(48,'finance-reports','تقارير مالية',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(49,'invoices-resend','ارسال الفواتير',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34');

-- Table structure for table `personal_access_tokens`
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `products`
DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_category_id_foreign` (`category_id`),
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `products`
INSERT INTO `products` VALUES (1,'نظارات جاهزة',100,'نظارات جاهزة','products/1744396310.jpg',1,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'عدسات جاهزة',100,'عدسات جاهزة','products/1744396310.jpg',2,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'منتجات أخرى',100,'منتجات أخرى','products/1744396310.jpg',3,'2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `receptions`
DROP TABLE IF EXISTS `receptions`;
CREATE TABLE `receptions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `examination_id` bigint unsigned NOT NULL,
  `status` enum('تم التأكيد',' الغاء') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'تم التأكيد',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `receptions_examination_id_foreign` (`examination_id`),
  CONSTRAINT `receptions_examination_id_foreign` FOREIGN KEY (`examination_id`) REFERENCES `examinations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `recieveds`
DROP TABLE IF EXISTS `recieveds`;
CREATE TABLE `recieveds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `examination_id` bigint unsigned NOT NULL,
  `status` enum('تم الاستلام',' الغاء') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'تم الاستلام',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `recieveds_examination_id_foreign` (`examination_id`),
  CONSTRAINT `recieveds_examination_id_foreign` FOREIGN KEY (`examination_id`) REFERENCES `examinations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `regions`
DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `regions_city_id_index` (`city_id`)
) ENGINE=InnoDB AUTO_INCREMENT=405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `regions`
INSERT INTO `regions` VALUES (1,'أم أذينة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(2,'أم السماق',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(3,'الجبيهة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(4,'الذراع الغربي',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(5,'الشميساني',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(6,'الصويفية',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(7,'المحطة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(8,'الهاشمي الشمالي',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(9,'بيادر وادي السير',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(10,'جبل الأشرفية',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(11,'جبل التاج',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(12,'جبل الجوفة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(13,'جبل الحسين',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(14,'جبل القصور',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(15,'جبل اللويبدة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(16,'جبل المريخ',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(17,'جبل النزهة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(18,'جبل النصر',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(19,'جبل النظيف',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(20,'جبل عمان',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(21,'حي الرابية',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(22,'حي الطفايلة',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(23,'حي المزارع',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(24,'حي غمدان',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(25,'حي نزال',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(26,'خلدا',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(27,'دابوق',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(28,'ضاحية النخيل',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(29,'ضاحية الياسمين',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(30,'طبربور',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(31,'عبدون',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(32,'عمان الشرقية',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(33,'عمان الغربية',1,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(34,'إربد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(35,'أبسر أبو علي',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(36,'أبو القين',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(37,'أبو اللوقس',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(38,'أبو زياد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(39,'أبو سيدو',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(40,'أبو هابيل',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(41,'أرخيم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(42,'أم الهوى',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(43,'أم قيس',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(44,'إبدر',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(45,'إرحابا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(46,'إزمال',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(47,'إيدون',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(48,'اسكايين',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(49,'الأشرفية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(50,'الإبراهيمية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(51,'الباقورة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(52,'البويضة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(53,'الحصن',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(54,'الحمة الأردنية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(55,'الخراج',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(56,'الخريبة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(57,'الذنيبة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(58,'الرحمة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(59,'الرفيد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(60,'الرقة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(61,'الرهوة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(62,'الزعترة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(63,'الزوية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(64,'السيلة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(65,'الشجرة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(66,'الشونة الشمالية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(67,'الشيخ حسين',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(68,'الصريح',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(69,'الصوان',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(70,'الطرة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(71,'الطيبة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(72,'العدسية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(73,'العشة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(74,'القصفة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(75,'الكورة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(76,'المخيبة التحتا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(77,'المزار الشمالي',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(78,'المزيريب',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(79,'المشارع',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(80,'المغير',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(81,'المنشية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(82,'المنصورة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(83,'النعيمة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(84,'الوسية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(85,'اليرموك',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(86,'البارحة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(87,'برشتا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(88,'بشرى',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(89,'بلدية السرو',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(90,'بيت إيدس',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(91,'بيت رأس',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(92,'بيت يافا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(93,'تبنة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(94,'تقبل',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(95,'ججين',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(96,'جحفية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(97,'جديتا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(98,'جفين',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(99,'جمحة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(100,'جنين الصفا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34');
INSERT INTO `regions` VALUES (101,'حاتم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(102,'حبراص',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(103,'حبكا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(104,'حرثا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(105,'حريما',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(106,'حكما',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(107,'حوارة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(108,'حور',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(109,'حوفا المزار',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(110,'حوفا الوسطية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(111,'خربة الحاوي',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(112,'خرجا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(113,'دوقره',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(114,'دير أبي سعيد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(115,'دير السعنة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(116,'دير يوسف',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(117,'زبدة الوسطية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(118,'زحر',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(119,'زمال',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(120,'زوبيا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(121,'سال',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(122,'سبيرة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(123,'سحم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(124,'سما الروسان',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(125,'سمر',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(126,'سموع',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(127,'سوم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(128,'شطنا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(129,'صما',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(130,'صمد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(131,'صيدور',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(132,'طبقة فحل',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(133,'عالية',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(134,'عزريت',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(135,'عقربا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(136,'علعال',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(137,'عمراوة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(138,'عنبة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(139,'فوعره',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(140,'قرية مرحبا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(141,'قم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(142,'قميم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(143,'كتم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(144,'كركمة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(145,'كريمة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(146,'كفر أبيل',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(147,'كفر أسد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(148,'كفر الماء',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(149,'كفر جايز',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(150,'كفر راكب',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(151,'كفر رحتا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(152,'كفر سوم',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(153,'كفر عان',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(154,'كفر عوان',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(155,'كفر كيفيا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(156,'كفر يوبا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(157,'ماجد',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(158,'مخربا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(159,'مخيم الشهيد عزمي المفتي',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(160,'مرو',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(161,'ملكا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(162,'مندح',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(163,'ناطفة',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(164,'هام',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(165,'وادي الريان',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(166,'وادي العرب',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(167,'وقاص',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(168,'يبلا',2,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(169,'الزرقاء',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(170,'المنطقة الحرة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(171,'حي الزواهرة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(172,'حي ابن سينا',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(173,'حي الأميرة هيا',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(174,'حي الأمير محمد',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(175,'مدينة الشرق',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(176,'الزرقاء الجديدة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(177,'ياجوز',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(178,'حي جبر',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(179,'حي معصوم',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(180,'حي رمزي',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(181,'حي الحسين',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(182,'مدينة المجد',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(183,'حي الجندي',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(184,'حي الفلاح',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(185,'حي الجنينة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(186,'حي الأمير عبد الله',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(187,'حي الأمير علي',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(188,'جبل الأمير حسن',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(189,'حي الأمير حمزة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(190,'حي الأميرة رحمة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(191,'حي جناعة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(192,'إسكان الأمير هاشم تطوير النقب',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(193,'الفاخورة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(194,'حي العراتفة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(195,'الشمالي',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(196,'حي النزهة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(197,'جبل طارق الحلايبة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(198,'حي المصفاة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(199,'حي الزواهرة',3,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(200,'
            مركز المدينة',4,'2025-04-16 00:08:34','2025-04-16 00:08:34');
INSERT INTO `regions` VALUES (201,'شاطئ الجنوب',4,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(202,'المفرق',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(203,'أبو السوس',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(204,'أرينبة النعيمات',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(205,'أم الجمال',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(206,'أم النعام',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(207,'الخالدية',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(208,'الرحمات',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(209,'الرويشد',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(210,'الزهور',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(211,'السعيدية',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(212,'العاقب',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(213,'الكوم الأحمر',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(214,'بلعما',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(215,'بويضة الحوامده',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(216,'بويضة العليمات',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(217,'تل رماح',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(218,'حيان الرويبض',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(219,'خراب المطوي',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(220,'خربة السمرا',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(221,'خريسان',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(222,'خشاع القن',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(223,'خشاع سليتين',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(224,'خطلة',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(225,'رسم الحصان',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(226,'روضة أبو الهيال',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(227,'روضة الأمير حمزة',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(228,'روضة بسمة',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(229,'سبع أصير',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(230,'عمرة وعميرة',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(231,'كوم الرف',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(232,'نادرة',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(233,'نايفة',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(234,'هويشان',5,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(235,'جرش',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(236,'سوف',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(237,'ساكب',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(238,'كفر خل',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(239,'الكتة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(240,'ريمون',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(241,'بليلا',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(242,'قفقفا',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(243,'نحلة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(244,'الربوة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(245,'دير الليات',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(246,'الحداده',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(247,'مقبله',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(248,'الكفير',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(249,'زقريط',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(250,'الجبارات',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(251,'عصفور',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(252,'الرشايدة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(253,'ام رامح',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(254,'عنيبه',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(255,'جبا',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(256,'ام الزيتون',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(257,'النبي هود',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(258,'الحسينيات',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(259,'ام قنطرة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(260,'نجدة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(261,'المجر',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(262,'العبارة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(263,'جملا',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(264,'قريع',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(265,'دبين',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(266,'الرياشي',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(267,'الحازية',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(268,'عمامه',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(269,'الشيخ مفرج',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(270,'السبطه',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(271,'ديرعجلون',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(272,'الجنيدية',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(273,'المشيرفة',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(274,'الفيحاء',6,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(275,'مادبا',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(276,'المامونية',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(277,'الفيحاء',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(278,'الواحة',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(279,'الفالحة',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(280,'حوية البلاونة',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(281,'التيم',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(282,'الروابي',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(283,'الجبيل',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(284,'الهلالية',7,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(285,'السلط',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(286,'زي',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(287,'أم جوزة',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(288,'الدير الشرقية',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(289,'اليزيدية',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(290,'يرقا',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(291,'إيرا',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(292,'آلان',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(293,'الرميمين',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(294,'مودري',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(295,'الزعتري',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(296,'حديب',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(297,'وادي عناقة',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(298,'ام خروبه',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(299,'وادي الصحن',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(300,'أم العمد',8,'2025-04-16 00:08:34','2025-04-16 00:08:34');
INSERT INTO `regions` VALUES (301,'الدعم',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(302,'السلوف',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(303,'جلعاد',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(304,'الوصية',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(305,'المشيرفة',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(306,'وادي شعيب',8,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(307,'الكرك',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(308,'ادر',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(309,'الشهابية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(310,'منشية ابو حمور',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(311,'الجديدة',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(312,'راكين',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(313,'العدنانية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(314,'الثنية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(315,'بتير',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(316,'الغوير',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(317,'مدين',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(318,'سمرا',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(319,'مرود',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(320,'بذان وبردى',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(321,'البقيع',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(322,'زحوم',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(323,'المشيرفه',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(324,'عينون',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(325,'موميا',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(326,'وادي ابن حماد',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(327,'سكا',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(328,'الراشديه',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(329,'الوسيه',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(330,'المامونية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(331,'الصالحية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(332,'المحمودية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(333,'ام رمانة',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(334,'العزيزية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(335,'العباسية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(336,'العبدلية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(337,'اللجون',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(338,'قريفله',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(339,'الحويه',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(340,'كمله',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(341,'المريغه',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(342,'الزغرية',9,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(343,'الطفيله',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(344,'العين البيضا',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(345,'العيص، عيمة',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(346,'الحسين',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(347,'عابل',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(348,'النمتة',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(349,'أبو بنا',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(350,'شيظم',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(351,'السلع',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(352,'أرحاب',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(353,'اضباعة',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(354,'مجادل',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(355,'صوبميح',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(356,'عفرا',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(357,'عابور',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(358,'تلعة حسين',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(359,'المعطن',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(360,'البربيطة',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(361,'اللعبان',10,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(362,'معان',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(363,'المحطة',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(364,'دبة الكرم',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(365,'عقيقه',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(366,'الطاحونه',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(367,'العوينة',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(368,'البريكة',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(369,'المبروكة',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(370,'حطيه',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(371,'محطة الجرذانه',11,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(372,'عجلون',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(373,'عنجرة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(374,'عين جنا',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(375,'الهاشمية',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(376,'الوهادنة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(377,'حلاوة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(378,'دير الصمادية الشمالي',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(379,'خشيبة الفوقا',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(380,'الجبل الاخضر',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(381,'الشكارة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(382,'الفاخرة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(383,'محنا,اشتفينا',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(384,'الطيارة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(385,'ام الينابيع',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(386,'الساخنة,الحنش',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(387,'خربة السوق',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(388,'الزراعة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(389,'كفر الدره',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(390,'الجب',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(391,'الحزار',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(392,'الزيزفونة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(393,'السرابيس',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(394,'ام الخشب',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(395,'خلة سالم',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(396,'خلة وردة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(397,'النقب',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(398,'عويمر',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(399,'الزعترة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(400,'ابو الزيتون',12,'2025-04-16 00:08:34','2025-04-16 00:08:34');
INSERT INTO `regions` VALUES (401,'لستب',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(402,'الصفصافة',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(403,'دير الصمادية الجنوبي',12,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(404,'الصوان',12,'2025-04-16 00:08:34','2025-04-16 00:08:34');

-- Table structure for table `role_user`
DROP TABLE IF EXISTS `role_user`;
CREATE TABLE `role_user` (
  `role_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`,`role_id`,`user_type`),
  KEY `role_user_role_id_foreign` (`role_id`),
  CONSTRAINT `role_user_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `role_user`
INSERT INTO `role_user` VALUES (1,1,'App\Models\User'),(2,2,'App\Models\User'),(2,3,'App\Models\User');

-- Table structure for table `roles`
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `roles`
INSERT INTO `roles` VALUES (1,'superadmin','سوبر ادمن',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(2,'admin','ادمن',NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34');

-- Table structure for table `rooms`
DROP TABLE IF EXISTS `rooms`;
CREATE TABLE `rooms` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `rooms`
INSERT INTO `rooms` VALUES (1,'Room 1',1,NULL,'2025-04-16 00:08:34','2025-04-16 00:08:34'),(2,'Room 2',2,'A','2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'Room 3',3,'B','2025-04-16 00:08:35','2025-04-16 00:08:35'),(4,'الاستقبال',4,'P','2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `settings`
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `settings`
INSERT INTO `settings` VALUES (1,'admin@gmail.com',065865799,065865799,NULL,'2025-04-16 00:09:05','2025-04-16 00:09:05');

-- Table structure for table `settings_translations`
DROP TABLE IF EXISTS `settings_translations`;
CREATE TABLE `settings_translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings_id` bigint unsigned NOT NULL,
  `locale` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `settings_translations_settings_id_foreign` (`settings_id`),
  CONSTRAINT `settings_translations_settings_id_foreign` FOREIGN KEY (`settings_id`) REFERENCES `settings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `settings_translations`
INSERT INTO `settings_translations` VALUES (1,1,'ar','شركة نجوم الابتكار','الأردن','تأسست شركة نجوم الابتكار عام 2025 في عمان لتقدم الأفضل في عالم البصريات:
- فحص نظر مجاني
- نظارات طبية وشمسية
- عدسات طبية وملونة',NULL,NULL),(2,1,'en','Star Innovation','Jordan','Founded in 2025 in Amman, Star Innovation offers the best in the world of optics:
- Free vision test
- Medical and sunglasses
- Medical and colored lenses',NULL,NULL);

-- Table structure for table `theme_settings`
DROP TABLE IF EXISTS `theme_settings`;
CREATE TABLE `theme_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `sidebar_bg_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#1e1e2d',
  `header_bg_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#ffffff',
  `primary_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#009ef7',
  `secondary_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#E4E6EF',
  `font_family` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Poppins, Arial, sans-serif',
  `base_font_size` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '13px',
  `heading_font_size` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.25rem',
  `menu_font_size` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1rem',
  `text_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#3F4254',
  `link_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#009ef7',
  `is_dark_mode` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `theme_settings`
INSERT INTO `theme_settings` VALUES (1,'#1e1e2d','#ffffff','#00a3ff','#f1416c','Poppins, Arial, sans-serif','14px','1.25rem','1rem','#181c32','#009ef7',0,'2025-04-16 00:08:35','2025-04-16 01:06:40');

-- Table structure for table `user_profiles`
DROP TABLE IF EXISTS `user_profiles`;
CREATE TABLE `user_profiles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street_addr_1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street_addr_2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_phone_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pin_code` bigint DEFAULT NULL,
  `facebook_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkdin_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_profiles_user_id_foreign` (`user_id`),
  CONSTRAINT `user_profiles_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table structure for table `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `picture` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `room_code` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_phone_unique` (`phone`),
  KEY `users_room_code_foreign` (`room_code`),
  CONSTRAINT `users_room_code_foreign` FOREIGN KEY (`room_code`) REFERENCES `rooms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `users`
INSERT INTO `users` VALUES (1,'محمود احمد','m@gmail.com','$2y$12$cLEwNRtlGR0tGRaGev458.hQcIfmKznWzlo2puTm.02DXguGfUGrK','بنى سويف',01118759692,NULL,NULL,NULL,1,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'احمد البطل','elbatal@gmail.com','$2y$12$l6xYKfG8te.VvN7lQLOchu.srN2KIKD3LCWWFkIlqf1XhL4o3T5N6','بنى سويف',01021512341,NULL,NULL,NULL,1,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'Yazan Sultan','yazanslt@gmail.com','$2y$12$7rkHZ3YZ9m0VzQjtPvTDwe1sFCHQn8WNyKsQSoT/tPgj3GdKhNtbi','Saudi Arabia','٠٧٩٥٨٩٨٦٩٦',NULL,NULL,NULL,4,'2025-04-16 00:22:29','2025-04-16 00:22:29');

-- Table structure for table `whatsapp_templates`
DROP TABLE IF EXISTS `whatsapp_templates`;
CREATE TABLE `whatsapp_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `age_range` json DEFAULT NULL,
  `months` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `whatsapp_templates_name_unique` (`name`),
  UNIQUE KEY `whatsapp_templates_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `whatsapp_templates`
INSERT INTO `whatsapp_templates` VALUES (1,'إنشاء فحص جديد',1,'add_examination','عزيزي العميل {name}، تم إنشاء الفحص الخاص بك برمز {examination_number} بتاريخ {date}. يرجى التوجه إلى قسم الاستقبال لإتمام الفحص. شكراً لك، مركز سمير للبصريات.',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(2,'تأكيد الفحص من الاستقبال',1,'reception_confirmation','عزيزي العميل {name}، نود إعلامك بأن الفحص الخاص بك برقم {examination_number} الذي تم تسجيله بتاريخ {date} قد تم إرساله إلى المشغل وهو الآن قيد التنفيذ. شكراً لك، مركز سمير للبصريات.',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(3,'بانتظار التسليم',1,'examination_pending_delivery','عزيزي العميل {name}، تم الانتهاء من {type} الخاص بك. يرجى التوجه إلى قسم الاستلام في المركز لاستلام الفحص. شكراً لك، مركز الدكتور سمير للبصريات.',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(4,'تم التسليم',1,'examination_delivered','عزيزي العميل {name}، تم استلام {type} بنجاح. شكراً لك، مركز الدكتور سمير للبصريات.',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(5,'إلغاء الفحص',1,'examination_cancelled','عزيزي العميل {name}، نود إعلامك بأن الفحص الخاص بك برقم {examination_number} الذي تم تسجيله بتاريخ {date} قد تم إلغاؤه. نعتذر عن أي إزعاج قد يسببه هذا. شكراً لك، مركز سمير للبصريات.',NULL,NULL,'2025-04-16 00:08:35','2025-04-16 00:08:35'),(6,'تذكير فحص للفئة العمرية من 6 إلى 18 سنة',1,'reminder_age_6_to_18','عزيزي العميل {name}، نود تذكيرك بأن الفحص الخاص بك برمز {examination_number} يحتاج إلى متابعة دورية. يُرجى تحديد موعد جديد لإتمام الفحص. شكراً لك، مركز سمير للبصريات.','[6, 18]','[3]','2025-04-16 00:08:35','2025-04-16 00:08:35'),(7,'تذكير فحص للفئة العمرية من 18 إلى 25 سنة',1,'reminder_age_18_to_25','عزيزي العميل {name}، لقد مر 6 أشهر على الفحص الخاص بك برقم {examination_number}. يُرجى تحديد موعد جديد لإتمام الفحص. شكراً لك، مركز سمير للبصريات.','[18, 25]','[6]','2025-04-16 00:08:35','2025-04-16 00:08:35'),(8,'تذكير فحص للفئة العمرية من 25 سنة فأكثر',1,'reminder_age_25_and_above','عزيزي العميل {name}، لقد مر 6 أشهر على الفحص الخاص بك برقم {examination_number}. يُرجى تحديد موعد جديد لإتمام الفحص. شكراً لك، مركز سمير للبصريات.','[25, null]','[6]','2025-04-16 00:08:35','2025-04-16 00:08:35');

-- Table structure for table `whatsapps`
DROP TABLE IF EXISTS `whatsapps`;
CREATE TABLE `whatsapps` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `app_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '20',
  `auth_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Data for table `whatsapps`
INSERT INTO `whatsapps` VALUES (1,'ed7530e7-b957-4f28-b70b-be8eb2ac6745',1,20,'6GzPpLBT0rxaLXjJ3lyL2y6XcEByjQqy2MKS6gcPx2UcyE2kRd','https://sender.tek-part-ns.cloud','2025-04-16 00:08:34','2025-04-16 00:08:34');

SET FOREIGN_KEY_CHECKS=1;
