<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.examinations-reports')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.reports')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card shadow-lg border-0 mb-4">
                            <div class="card-header bg-gradient-primary text-white py-4">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0 text-white"><?php echo e(__('translations.examinations-reports')); ?></h3>
                                </div>
                            </div>
                            <div class="card-body p-4">
                                <!-- Search box and status filter -->
                                <div class="row g-3 mb-5">
                                    <div class="col-md-3">
                                        <div class="position-relative">
                                            <span class="svg-icon svg-icon-1 position-absolute ms-3 top-50 translate-middle-y text-primary">
                                                <svg width="18" height="18" viewBox="0 0 24 24">
                                                    <path fill="currentColor"
                                                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                                                </svg>
                                            </span>
                                            <input type="text" data-kt-filter="search" class="form-control border-0 shadow-sm ps-11"
                                                placeholder="<?php echo e(__('translations.search')); ?>" />
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <select data-control="select2" class="form-select border-0 shadow-sm" id="status_filter">
                                            <option value=""><?php echo e(__('translations.select_status')); ?></option>
                                            <option value="في انتظار التاكيد"><?php echo e(__('translations.waiting-for-confirmation')); ?></option>
                                            <option value="ارسال الي المشغل"><?php echo e(__('translations.sent-to-operator')); ?></option>
                                            <option value="تم التجهيز"><?php echo e(__('translations.prepared')); ?></option>
                                            <option value="تم الاستلام"><?php echo e(__('translations.received')); ?></option>
                                            <option value="الغاء"><?php echo e(__('translations.cancelled')); ?></option>
                                        </select>
                                    </div>

                                    <div class="col-md-2">
                                        <input type="date" id="from_date" class="form-control border-0 shadow-sm" placeholder="<?php echo e(__('translations.from_date')); ?>" />
                                    </div>

                                    <div class="col-md-2">
                                        <input type="date" id="to_date" class="form-control border-0 shadow-sm" placeholder="<?php echo e(__('translations.to_date')); ?>" />
                                    </div>

                                    <div class="col-md-3">
                                        <button id="search_button" class="btn btn-gradient-primary shadow-sm w-100">
                                            <i class="fas fa-search me-2"></i><?php echo e(__('translations.search')); ?>

                                        </button>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table id="kt_datatable_example" class="table table-striped table-hover border-0">
                                        <thead class="bg-light">
                                            <tr class="text-dark fs-7">
                                                <th class="rounded-start py-3"><?php echo e(__('translations.Examination Code')); ?></th>
                                                <th><?php echo e(__('translations.Client name')); ?></th>
                                                <th><?php echo e(__('translations.Note')); ?></th>
                                                <th><?php echo e(__('translations.type')); ?></th>
                                                <th><?php echo e(__('translations.Date')); ?></th>
                                                <th class="rounded-end"><?php echo e(__('translations.status')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody id="reports-body">
                                            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="border-bottom">
                                                    <td class="py-3 fw-bold text-primary"><?php echo e($examination->code); ?></td>
                                                    <td>
                                                        <?php if($examination->client): ?>
                                                            <div class="d-flex align-items-center">
                                                                <div class="symbol symbol-30px me-3 bg-light-primary rounded-circle">
                                                                    <span class="text-primary"><?php echo e(substr($examination->client->first_name ?? '', 0, 1)); ?></span>
                                                                </div>
                                                                <span><?php echo e($examination->client->first_name ?? ''); ?> <?php echo e($examination->client->last_name ?? ''); ?></span>
                                                            </div>
                                                        <?php else: ?>
                                                            <span class="badge badge-light-danger"><?php echo e(__('translations.No Client')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <span class="text-muted fs-7"><?php echo \Illuminate\Support\Str::limit($examination->notes, 80, '...'); ?></span>
                                                    </td>
                                                    <td><span class="badge badge-light-info"><?php echo e($examination->type); ?></span></td>
                                                    <td><?php echo e($examination->created_at); ?></td>
                                                    <td>
                                                        <?php
                                                            $statusClass = '';
                                                            switch($examination->status) {
                                                                case 'في انتظار التاكيد':
                                                                    $statusClass = 'badge-light-warning';
                                                                    break;
                                                                case 'ارسال الي المشغل':
                                                                    $statusClass = 'badge-light-primary';
                                                                    break;
                                                                case 'تم التجهيز':
                                                                    $statusClass = 'badge-light-success';
                                                                    break;
                                                                case 'تم الاستلام':
                                                                    $statusClass = 'badge-light-info';
                                                                    break;
                                                                case 'الغاء':
                                                                    $statusClass = 'badge-light-danger';
                                                                    break;
                                                                default:
                                                                    $statusClass = 'badge-light-secondary';
                                                            }
                                                        ?>
                                                        <span class="badge <?php echo e($statusClass); ?>"><?php echo e($examination->status); ?></span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#search_button').on('click', function() {
                var status = $('#status_filter').val();
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();

                $.ajax({
                    url: "<?php echo e(route('admin.reports.filter')); ?>",
                    type: 'GET',
                    data: {
                        status: status,
                        from_date: from_date,
                        to_date: to_date
                    },
                    success: function(response) {
                        $('#reports-body').html(response);
                    },
                    error: function(xhr, status, error) {
                        console.error("Error:", error);
                    }
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/reports/index.blade.php ENDPATH**/ ?>