<?php $__env->startSection('title'); ?>
  <?php echo e(__('translations.expenses-list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
  <?php echo e(__('translations.expenses-list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
      <div id="kt_content_container" class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card card-docs mb-2">
              <div class="card-header">
                <div class="card-title m-0">
                  <h3 class="fw-bolder m-0"><?php echo e(__('translations.expenses-list')); ?></h3>
                </div>
                <div class="card-toolbar">
                  <a href="<?php echo e(route('admin.expenses.create')); ?>" class="btn btn-primary">
                    <span class="svg-icon svg-icon-2">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                        fill="none">
                        <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                          transform="rotate(-90 11.364 20.364)" fill="white" stroke="white" stroke-width="3"></rect>
                        <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="white"
                          stroke="white" stroke-width="3"></rect>
                      </svg>
                    </span>
                    <span><?php echo e(__('translations.expenses-create')); ?></span>
                  </a>
                </div>
              </div>
              <div class="card-body">
                <div class="d-flex align-items-center position-relative mb-4">
                  <span class="svg-icon svg-icon-1 position-absolute ms-4">
                    <svg width="18" height="18" viewBox="0 0 24 24">
                      <path fill="currentColor"
                        d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                    </svg>
                  </span>
                  <input type="text" data-kt-filter="search" class="form-control form-control-solid w-250px ps-14"
                    placeholder="<?php echo e(__('translations.search')); ?>" />
                </div>
                <?php if(session('success')): ?>
                  <div class="alert alert-success">
                      <?php echo e(session('success')); ?>

                  </div>
                <?php endif; ?>
                <table id="kt_datatable_example"
                  class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                  <thead>
                    <tr class="fw-bolder fs-8 text-uppercase gs-0">
                      <th>#</th>
                      <th><?php echo e(__('translations.expense-title')); ?></th>
                      <th><?php echo e(__('translations.expense-amount')); ?></th>
                      <th><?php echo e(__('translations.expense-date')); ?></th>
                      <th><?php echo e(__('translations.expense-category')); ?></th>
                      <th><?php echo e(__('translations.expense-status')); ?></th>
                      <th><?php echo e(__('translations.actions')); ?></th>
                    </tr>
                  </thead>
                  <tbody class="text-gray-800 fw-bold">
                    <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($expense->title); ?></td>
                        <td><?php echo e(number_format($expense->amount, 2)); ?></td>
                        <td><?php echo e($expense->expense_date->format('Y-m-d')); ?></td>
                        <td><?php echo e($expense->category->name); ?></td>
                        <td>
                          <span class="badge badge-<?php echo e($expense->status == 'approved' ? 'success' : ($expense->status == 'pending' ? 'warning' : 'danger')); ?> cursor-pointer status-badge"
                                data-bs-toggle="modal" data-bs-target="#statusModal<?php echo e($expense->id); ?>">
                            <?php echo e($expense->status == 'approved' ? __('translations.expense-approved') : ($expense->status == 'pending' ? __('translations.expense-pending') : __('translations.expense-rejected'))); ?>

                          </span>

                          <!-- Status Change Modal -->
                          <div class="modal fade" id="statusModal<?php echo e($expense->id); ?>" tabindex="-1" aria-labelledby="statusModalLabel<?php echo e($expense->id); ?>" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-fullscreen-sm-down">
                              <div class="modal-content shadow-sm border-0">
                                <div class="modal-header bg-light">
                                  <h5 class="modal-title fw-bold" id="statusModalLabel<?php echo e($expense->id); ?>">
                                    <i class="fas fa-edit me-2 text-primary"></i><?php echo e(__('translations.change-expense-status')); ?>

                                  </h5>
                                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo e(__('translations.close')); ?>"></button>
                                </div>
                                <form action="<?php echo e(route('admin.expenses.updateStatus', $expense->id)); ?>" method="POST">
                                  <?php echo csrf_field(); ?>
                                  <?php echo method_field('PATCH'); ?>
                                  <div class="modal-body py-4">
                                    <div class="text-center mb-4">
                                      <div class="d-inline-block p-3 rounded-circle
                                        <?php echo e($expense->status == 'approved' ? 'bg-success' : ($expense->status == 'pending' ? 'bg-warning' : 'bg-danger')); ?>

                                        bg-opacity-10 mb-3">
                                        <i class="fas
                                          <?php echo e($expense->status == 'approved' ? 'fa-check' : ($expense->status == 'pending' ? 'fa-clock' : 'fa-times')); ?>

                                          fa-2x
                                          <?php echo e($expense->status == 'approved' ? 'text-success' : ($expense->status == 'pending' ? 'text-warning' : 'text-danger')); ?>

                                        "></i>
                                      </div>
                                      <h6 class="fw-semibold"><?php echo e(__('translations.expense-current-status')); ?>:
                                        <span class="badge badge-<?php echo e($expense->status == 'approved' ? 'success' : ($expense->status == 'pending' ? 'warning' : 'danger')); ?>">
                                          <?php echo e($expense->status == 'approved' ? __('translations.expense-approved') : ($expense->status == 'pending' ? __('translations.expense-pending') : __('translations.expense-rejected'))); ?>

                                        </span>
                                      </h6>
                                    </div>
                                    <div class="form-group">
                                      <label for="status" class="form-label fw-semibold"><?php echo e(__('translations.expense-new-status')); ?></label>
                                      <select class="form-select form-select-solid" name="status" id="status" style="width: 80%;">
                                        <option value="pending" <?php echo e($expense->status == 'pending' ? 'selected' : ''); ?>><?php echo e(__('translations.expense-pending')); ?></option>
                                        <option value="approved" <?php echo e($expense->status == 'approved' ? 'selected' : ''); ?>><?php echo e(__('translations.expense-approved')); ?></option>
                                        <option value="rejected" <?php echo e($expense->status == 'rejected' ? 'selected' : ''); ?>><?php echo e(__('translations.expense-rejected')); ?></option>
                                      </select>
                                    </div>
                                  </div>
                                  <div class="modal-footer border-top-0">
                                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                      <i class="fas fa-times-circle me-1"></i><?php echo e(__('translations.close')); ?>

                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                      <i class="fas fa-save me-1"></i><?php echo e(__('translations.save-changes')); ?>

                                    </button>
                                  </div>
                                </form>
                              </div>
                            </div>
                          </div>
                        </td>
                        <td>
                          <button class="btn btn-light btn-sm dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(__('translations.actions')); ?>

                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="<?php echo e(route('admin.expenses.show', $expense->id)); ?>">
                              <?php echo e(__('translations.show')); ?>

                            </a>
                            <a class="dropdown-item" href="<?php echo e(route('admin.expenses.edit', $expense->id)); ?>">
                              <?php echo e(__('translations.edit')); ?>

                            </a>
                            <a class="dropdown-item" href="#"
                              onclick="event.preventDefault();
                                  if(confirm('<?php echo e(__('translations.deletemsg')); ?>')) {
                                  document.getElementById('delete-form-<?php echo e($expense->id); ?>').submit();
                                  }">
                              <?php echo e(__('translations.delete')); ?>

                            </a>
                            <form id="delete-form-<?php echo e($expense->id); ?>"
                              action="<?php echo e(route('admin.expenses.destroy', $expense->id)); ?>" method="post"
                              style="display: none;">
                              <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            </form>
                          </div>
                        </td>
                      </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>

                <div class="d-flex justify-content-center mt-5">
                  <?php echo e($expenses->links()); ?>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Add cursor pointer styling and enhance mobile click handling
    document.querySelectorAll('.status-badge').forEach(badge => {
      badge.style.cursor = 'pointer';

      // Add additional touch event listener for mobile devices
      badge.addEventListener('touchend', function(e) {
        e.preventDefault();
        const targetId = this.getAttribute('data-bs-target');
        const modalElement = document.querySelector(targetId);
        if (modalElement) {
          const bsModal = new bootstrap.Modal(modalElement);
          bsModal.show();
        }
      });
    });
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/expenses/index.blade.php ENDPATH**/ ?>