<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="mb-8">

<?php
    $themeSettings = \App\Models\ThemeSettings::first() ?? new \App\Models\ThemeSettings();
?>
                    <!-- Stats Overview -->
                    <?php if(auth()->user()->isSuperAdmin()): ?>
                        <!-- Summary Cards Row -->
                        <div class="row g-5 g-xl-10 mb-5">
                            <div class="col-xl-3 col-lg-6 col-md-6">
                                <div class="card card-xl-stretch mb-xl-8 shadow-sm" style="background-color: #F6F8FF; border-radius: 15px; border-left: 5px solid #3a7bd5;">
                                    <div class="card-body p-5">
                                        <div class="d-flex align-items-center">
                                            <div class="symbol symbol-50px me-5">
                                                <span class="symbol-label bg-primary-light">
                                                    <i class="fas fa-users text-primary fs-1"></i>
                                                </span>
                                            </div>
                                            <div class="d-flex flex-column">
                                                <span class="text-dark fw-bolder fs-4"><?php echo e($usersCount); ?></span>
                                                <span class="text-muted fw-bold"><?php echo e(__('translations.users-count')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 col-md-6">
                                <div class="card card-xl-stretch mb-xl-8 shadow-sm" style="background-color: #F0FFF4; border-radius: 15px; border-left: 5px solid #4CAF50;">
                                    <div class="card-body p-5">
                                        <div class="d-flex align-items-center">
                                            <div class="symbol symbol-50px me-5">
                                                <span class="symbol-label bg-success-light">
                                                    <i class="fas fa-user-tie text-success fs-1"></i>
                                                </span>
                                            </div>
                                            <div class="d-flex flex-column">
                                                <span class="text-dark fw-bolder fs-4"><?php echo e($clientsCount); ?></span>
                                                <span class="text-muted fw-bold"><?php echo e(__('translations.clients-count')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 col-md-6">
                                <div class="card card-xl-stretch mb-xl-8 shadow-sm" style="background-color: #FFF9EA; border-radius: 15px; border-left: 5px solid #FF9800;">
                                    <div class="card-body p-5">
                                        <div class="d-flex align-items-center">
                                            <div class="symbol symbol-50px me-5">
                                                <span class="symbol-label bg-warning-light">
                                                    <i class="fas fa-clipboard-list text-warning fs-1"></i>
                                                </span>
                                            </div>
                                            <div class="d-flex flex-column">
                                                <span class="text-dark fw-bolder fs-4"><?php echo e($examinationsCount); ?></span>
                                                <span class="text-muted fw-bold"><?php echo e(__('translations.examinations-count')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-3 col-lg-6 col-md-6">
                                <div class="card card-xl-stretch mb-xl-8 shadow-sm" style="background-color: #FFF5F8; border-radius: 15px; border-left: 5px solid #F44336;">
                                    <div class="card-body p-5">
                                        <div class="d-flex align-items-center">
                                            <div class="symbol symbol-50px me-5">
                                                <span class="symbol-label bg-danger-light">
                                                    <i class="fas fa-calendar-day text-danger fs-1"></i>
                                                </span>
                                            </div>
                                            <div class="d-flex flex-column">
                                                <span class="text-dark fw-bolder fs-4"><?php echo e($examinationsTodayCount); ?></span>
                                                <span class="text-muted fw-bold"><?php echo e(__('translations.examinationsToday-count')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Sales & Invoice Statistics -->
                        <div class="row g-5 g-xl-10 mb-5">
                            <div class="col-xl-8">
                                <div class="card shadow" style="border-radius: 15px;">
                                    <div class="card-header border-0 pt-5">
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-bolder fs-3 mb-1" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.sales_overview')); ?></span>
                                            <span class="text-muted mt-1 fw-bold fs-7" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.last_30_days')); ?></span>
                                        </h3>
                                        <div class="card-toolbar">
                                            <ul class="nav">
                                                <li class="nav-item">
                                                    <a class="nav-link btn btn-sm btn-color-muted btn-active btn-active-light-primary active fw-bolder px-4 me-1" data-bs-toggle="tab" href="#kt_tab_pane_1_1"><?php echo e(__('translations.monthly')); ?></a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link btn btn-sm btn-color-muted btn-active btn-active-light-primary fw-bolder px-4 me-1" data-bs-toggle="tab" href="#kt_tab_pane_1_2"><?php echo e(__('translations.weekly')); ?></a>
                                                </li>
                                                <li class="nav-item">
                                                    <a class="nav-link btn btn-sm btn-color-muted btn-active btn-active-light-primary fw-bolder px-4" data-bs-toggle="tab" href="#kt_tab_pane_1_3"><?php echo e(__('translations.daily')); ?></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="tab-content">
                                            <div class="tab-pane fade show active" id="kt_tab_pane_1_1">
                                                <div id="kt_charts_widget_1_chart_1" style="height: 350px"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="card shadow" style="border-radius: 15px;">
                                    <div class="card-header border-0 pt-5">
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-bolder fs-3 mb-1" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.sales_statistics')); ?></span>
                                            <span class="text-muted mt-1 fw-bold fs-7" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.overall_performance')); ?></span>
                                        </h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="d-flex flex-wrap flex-stack mt-5">
                                            <!-- Sales Statistics Item -->
                                            <div class="d-flex flex-column w-100 me-2 mb-5">
                                                <span class="text-dark fw-bolder mb-1 fs-6 " style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.total_sales')); ?></span>
                                                <div class="d-flex align-items-center">
                                                    <div class="progress h-10px w-100 bg-light-success">
                                                        <div class="progress-bar bg-success" role="progressbar" style="width: 85%" aria-valuenow="85" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <span class="text-success fw-bolder fs-6 ms-3"><?php echo e(isset($totalSales) ? $totalSales : '0'); ?></span>
                                                </div>
                                            </div>
                                            <!-- Total Invoices -->
                                            <div class="d-flex flex-column w-100 me-2 mb-5">
                                                <span class="text-dark fw-bolder mb-1 fs-6 " style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.total_invoices')); ?></span>
                                                <div class="d-flex align-items-center">
                                                    <div class="progress h-10px w-100 bg-light-primary">
                                                        <div class="progress-bar bg-primary" role="progressbar" style="width: 65%" aria-valuenow="65" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <span class="text-primary fw-bolder fs-6 ms-3"><?php echo e(isset($totalInvoices) ? $totalInvoices : '0'); ?></span>
                                                </div>
                                            </div>
                                            <!-- Pending Payments -->
                                            <div class="d-flex flex-column w-100 me-2 mb-5">
                                                <span class="text-dark fw-bolder mb-1 fs-6 " style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.pending_payments')); ?></span>
                                                <div class="d-flex align-items-center">
                                                    <div class="progress h-10px w-100 bg-light-warning">
                                                        <div class="progress-bar bg-warning" role="progressbar" style="width: 45%" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                    <span class="text-warning fw-bolder fs-6 ms-3"><?php echo e(isset($pendingPayments) ? $pendingPayments : '0'); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Examination & Client Statistics -->
                        <div class="row g-5 g-xl-10 mb-5">
                            <div class="col-xl-4 col-lg-6 col-md-6">
                                <div class="card card-xl-stretch mb-xl-8 shadow" style="background-color: #F5F8FA; border-radius: 15px; ">
                                    <div class="card-header border-0 py-5">
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-bolder fs-3 mb-1 " style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.examination_status')); ?></span>
                                        </h3>
                                    </div>
                                    <div class="card-body d-flex flex-column">
                                        <div class="mb-7">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="fs-6 text-gray-800 me-3" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.waiting')); ?></span>
                                                <div class="flex-grow-1">
                                                    <div class="progress h-6px">
                                                        <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo e(($examinationsWaiting / max($examinationsCount, 1)) * 100); ?>%" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                </div>
                                                <span class="fw-bolder fs-6 text-gray-800 ms-3"><?php echo e($examinationsWaiting); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="fs-6 text-gray-800 me-3" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.operation')); ?></span>
                                                <div class="flex-grow-1">
                                                    <div class="progress h-6px">
                                                        <div class="progress-bar bg-warning" role="progressbar" style="width: <?php echo e(($examinationsOperation / max($examinationsCount, 1)) * 100); ?>%" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                </div>
                                                <span class="fw-bolder fs-6 text-gray-800 ms-3"><?php echo e($examinationsOperation); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="fs-6 text-gray-800 me-3" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.done')); ?></span>
                                                <div class="flex-grow-1">
                                                    <div class="progress h-6px">
                                                        <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e(($examinationsDone / max($examinationsCount, 1)) * 100); ?>%" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                </div>
                                                <span class="fw-bolder fs-6 text-gray-800 ms-3" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e($examinationsDone); ?></span>
                                            </div>
                                            <div class="d-flex align-items-center">
                                                <span class="fs-6 text-gray-800 me-3" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.cancelled')); ?></span>
                                                <div class="flex-grow-1">
                                                    <div class="progress h-6px">
                                                        <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo e(($examinationsCancelled / max($examinationsCount, 1)) * 100); ?>%" aria-valuemin="0" aria-valuemax="100"></div>
                                                    </div>
                                                </div>
                                                <span class="fw-bolder fs-6 text-gray-800 ms-3" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e($examinationsCancelled); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-4 col-lg-6 col-md-6">
                                <div class="card card-xl-stretch mb-xl-8 shadow" style="background-color: #F5F8FA; border-radius: 15px;">
                                    <div class="card-header border-0 py-5">
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-bolder fs-3 mb-1" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.gender_distribution')); ?></span>
                                        </h3>
                                    </div>
                                    <div class="card-body">
                                        <div id="kt_chart_gender" style="height: 250px"></div>
                                        <div class="d-flex justify-content-around mt-5">
                                            <div class="d-flex flex-column text-center">
                                                <span class="fw-bold fs-2 text-primary" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e($maleClientsCount); ?></span>
                                                <span class="fw-bold fs-7 text-gray-600" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.male-clients')); ?></span>
                                            </div>
                                            <div class="d-flex flex-column text-center">
                                                <span class="fw-bold fs-2 text-danger" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e($femaleClientsCount); ?></span>
                                                <span class="fw-bold fs-7 text-gray-600"><?php echo e(__('translations.female-clients')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-4 col-lg-12 col-md-12">
                                <div class="card card-xl-stretch mb-xl-8 shadow" style="background-color: #F5F8FA; border-radius: 15px;">
                                    <div class="card-header border-0 py-5">
                                        <h3 class="card-title align-items-start flex-column">
                                            <span class="card-label fw-bolder fs-3 mb-1" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.recent_examinations')); ?></span>
                                        </h3>
                                    </div>
                                    <div class="card-body pt-3">
                                        <?php if(count($examinationsToday) > 0): ?>
                                            <?php $__currentLoopData = $examinationsToday->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="d-flex align-items-center mb-7">
                                                    <div class="symbol symbol-50px me-5">
                                                        <span class="symbol-label bg-light-primary">
                                                            <i class="fas fa-clipboard-check text-primary fs-1"></i>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex flex-column">
                                                        <a href="<?php echo e(route('admin.receptions.show', $examination->id)); ?>" class="text-dark text-hover-primary fs-6 fw-bolder"><?php echo e($examination->code); ?></a>
                                                        <span class="text-muted fw-bold"><?php echo e($examination->created_at->format('H:i')); ?> - <?php echo e($examination->status); ?></span>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <div class="text-center text-muted" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.no_examinations_today')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card shadow" style="border-radius: 15px; background: linear-gradient(135deg, #f5f7fa, #c3cfe2);">
                            <div class="card-body py-15 text-center">
                                <h1 class="text-dark fs-1 fw-bolder mb-5" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(__('translations.welcome')); ?></h1>
                                <h2 class="text-primary fs-2" style="color: <?php echo e($themeSettings->text_color); ?> !important;"><?php echo e(Auth::user()->name); ?></h2>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <?php if(auth()->user()->isSuperAdmin()): ?>
        <!-- Add JavaScript for charts -->
        <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Gender Distribution Chart
                var genderOptions = {
                    series: [<?php echo e($maleClientsCount); ?>, <?php echo e($femaleClientsCount); ?>],
                    chart: {
                        type: 'donut',
                        height: 250,
                    },
                    labels: ['<?php echo e(__("translations.male-clients")); ?>', '<?php echo e(__("translations.female-clients")); ?>'],
                    colors: ['#3699FF', '#F64E60'],
                    legend: {
                        position: 'bottom'
                    },
                    dataLabels: {
                        enabled: false
                    },
                    plotOptions: {
                        pie: {
                            donut: {
                                size: '65%'
                            }
                        }
                    }
                };
                var genderChart = new ApexCharts(document.querySelector("#kt_chart_gender"), genderOptions);
                genderChart.render();

                // Sales Overview Chart
                var salesOptions = {
                    series: [{
                        name: '<?php echo e(__("translations.sales")); ?>',
                        data: [30, 40, 35, 50, 49, 60, 70, 91, 125, 150, 160, 180]
                    }],
                    chart: {
                        type: 'area',
                        height: 350,
                        toolbar: {
                            show: false
                        }
                    },
                    dataLabels: {
                        enabled: false
                    },
                    stroke: {
                        curve: 'smooth',
                        width: 3
                    },
                    colors: ['#0095E8'],
                    xaxis: {
                        categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                    },
                    tooltip: {
                        x: {
                            format: 'dd/MM/yy HH:mm'
                        },
                    },
                    fill: {
                        type: 'gradient',
                        gradient: {
                            shadeIntensity: 1,
                            opacityFrom: 0.7,
                            opacityTo: 0.2,
                            stops: [0, 90, 100]
                        }
                    }
                };
                var salesChart = new ApexCharts(document.querySelector("#kt_charts_widget_1_chart_1"), salesOptions);
                salesChart.render();
            });
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/index.blade.php ENDPATH**/ ?>