<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.financial-reports')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.reports')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <!-- Future Year Alert -->
            <div id="future_year_alert" class="alert alert-warning d-flex align-items-center p-5 mb-10" style="display:none !important;">
                <span class="svg-icon svg-icon-2hx svg-icon-warning me-4">
                    <i class="bi bi-exclamation-triangle fs-1"></i>
                </span>
                <div class="d-flex flex-column">
                    <h4 class="mb-1 text-warning"><?php echo e(__('translations.future-year-warning') ?? 'تنبيه: عام مستقبلي'); ?></h4>
                    <span><?php echo e(__('translations.future-year-message') ?? 'لقد قمت باختيار عام مستقبلي. لن تكون هناك بيانات متاحة للعرض حتى يحدث هذا العام.'); ?></span>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row g-5 g-xl-10  mb-xl-15">
                <!-- Expenses Card -->
                <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 ">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header pt-5">
                            <div class="card-title d-flex flex-column">
                                <div class="symbol symbol-50px mb-3">
                                    <span class="symbol-label bg-light-danger">
                                        <i class="bi bi-cash-stack fs-2x text-danger"></i>
                                    </span>
                                </div>
                                <span class="fs-2hx fw-bold text-dark me-2 lh-1 ls-n2 mb-2"><?php echo e(number_format($currentMonthExpenses, 0)); ?> <?php echo e(__('translations.currency')); ?></span>
                                <span class="text-gray-500 pt-1 fw-semibold fs-6"><?php echo e(__('translations.current-month-expenses')); ?></span>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-end pt-0">
                            <div class="d-flex align-items-center flex-column mt-3 w-100">
                                <div class="d-flex justify-content-between fw-bold fs-6 text-gray-500 w-100 mt-auto mb-2">
                                    <span><?php echo e(__('translations.view-details')); ?></span>
                                    <a href="<?php echo e(route('admin.financial-reports.expenses')); ?>" class="btn btn-sm btn-icon btn-light-danger btn-active-danger">
                                        <i class="bi bi-arrow-right fs-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Returns Card -->
                <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header pt-5">
                            <div class="card-title d-flex flex-column">
                                <div class="symbol symbol-50px mb-3">
                                    <span class="symbol-label bg-light-warning">
                                        <i class="bi bi-arrow-return-left fs-2x text-warning"></i>
                                    </span>
                                </div>
                                <span class="fs-2hx fw-bold text-dark me-2 lh-1 ls-n2 mb-2"><?php echo e(number_format($currentMonthReturns ?? 0, 0)); ?> <?php echo e(__('translations.currency')); ?></span>
                                <span class="text-gray-500 pt-1 fw-semibold fs-6"><?php echo e(__('translations.current-month-returns')); ?></span>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-end pt-0">
                            <div class="d-flex align-items-center flex-column mt-3 w-100">
                                <div class="d-flex justify-content-between fw-bold fs-6 text-gray-500 w-100 mt-auto mb-2">
                                    <span><?php echo e(__('translations.view-details')); ?></span>
                                    <a href="<?php echo e(route('admin.financial-reports.sales')); ?>" class="btn btn-sm btn-icon btn-light-warning btn-active-warning">
                                        <i class="bi bi-arrow-right fs-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sales Card -->
                <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header pt-5">
                            <div class="card-title d-flex flex-column">
                                <div class="symbol symbol-50px mb-3">
                                    <span class="symbol-label bg-light-success">
                                        <i class="bi bi-graph-up fs-2x text-success"></i>
                                    </span>
                                </div>
                                <span class="fs-2hx fw-bold text-dark me-2 lh-1 ls-n2 mb-2"><?php echo e(number_format($currentMonthSales, 0)); ?> <?php echo e(__('translations.currency')); ?></span>
                                <span class="text-gray-500 pt-1 fw-semibold fs-6"><?php echo e(__('translations.current-month-sales')); ?></span>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-end pt-0">
                            <div class="d-flex align-items-center flex-column mt-3 w-100">
                                <div class="d-flex justify-content-between fw-bold fs-6 text-gray-500 w-100 mt-auto mb-2">
                                    <span><?php echo e(__('translations.view-details')); ?></span>
                                    <a href="<?php echo e(route('admin.financial-reports.sales')); ?>" class="btn btn-sm btn-icon btn-light-success btn-active-success">
                                        <i class="bi bi-arrow-right fs-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Profit Card -->
                <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3 ">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header pt-5">
                            <div class="card-title d-flex flex-column">
                                <div class="symbol symbol-50px mb-3">
                                    <span class="symbol-label bg-light-primary">
                                        <i class="bi bi-wallet2 fs-2x text-primary"></i>
                                    </span>
                                </div>
                                <span class="fs-2hx fw-bold text-dark me-2 lh-1 ls-n2 mb-2"><?php echo e(number_format($currentMonthProfit, 0)); ?> <?php echo e(__('translations.currency')); ?></span>
                                <span class="text-gray-500 pt-1 fw-semibold fs-6"><?php echo e(__('translations.current-month-profit')); ?></span>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-end pt-0">
                            <div class="d-flex align-items-center flex-column mt-3 w-100">
                                <div class="d-flex justify-content-between fw-bold fs-6 text-gray-500 w-100 mt-auto mb-2">
                                    <span><?php echo e(__('translations.view-details')); ?></span>
                                    <a href="<?php echo e(route('admin.financial-reports.profits')); ?>" class="btn btn-sm btn-icon btn-light-primary btn-active-primary">
                                        <i class="bi bi-arrow-right fs-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Top Products Card -->
                <div class="col-md-6 col-lg-6 col-xl-3 col-xxl-3  ">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header pt-5">
                            <div class="card-title d-flex flex-column">
                                <div class="symbol symbol-50px mb-3">
                                    <span class="symbol-label bg-light-info">
                                        <i class="bi bi-box-seam fs-2x text-info"></i>
                                    </span>
                                </div>
                                <span class="fw-bold text-dark me-2 lh-1 ls-n2 mb-2"><?php echo e(__('translations.top-products')); ?></span>
                                <span class="text-gray-500 pt-1 fw-semibold fs-6"><?php echo e(__('translations.best-selling-products')); ?></span>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-end pt-0">
                            <div class="d-flex align-items-center flex-column mt-3 w-100">
                                <div class="d-flex justify-content-between fw-bold fs-6 text-gray-500 w-100 mt-auto mb-2">
                                    <span><?php echo e(__('translations.view-details')); ?></span>
                                    <a href="<?php echo e(route('admin.financial-reports.top-products')); ?>" class="btn btn-sm btn-icon btn-light-info btn-active-info">
                                        <i class="bi bi-arrow-right fs-2"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charts Section -->
            <div class="row g-5 g-xl-10">
                <!-- Monthly Expenses Chart -->
                <div class="col-xl-6 mb-5 mb-xl-10">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header py-5">
                            <h3 class="card-title align-items-start flex-column">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="card-label fw-bolder text-dark"><?php echo e(__('translations.monthly-expenses')); ?></span>
                                    <span class="badge badge-light-danger ms-3 fs-7"><?php echo e($selectedYear ?? date('Y')); ?></span>
                                </div>
                                <span class="text-gray-500 mt-1 fw-semibold fs-6"><?php echo e(__('translations.expenses-for-current-year')); ?></span>
                            </h3>
                            <div class="card-toolbar">
                                <form action="<?php echo e(route('admin.financial-reports.index')); ?>" method="GET" class="d-flex align-items-center">
                                    <select name="year" class="form-select form-select-sm" onchange="this.form.submit()">
                                        <?php for($year = date('Y') + 5; $year >= date('Y') - 5; $year--): ?>
                                            <option value="<?php echo e($year); ?>" <?php echo e(($selectedYear ?? date('Y')) == $year ? 'selected' : ''); ?>><?php echo e($year); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </form>
                            </div>
                        </div>
                        <div class="card-body pt-0">
                            <div id="expenses_chart" class="min-h-auto" style="height: 320px"></div>
                        </div>
                    </div>
                </div>

                <!-- Monthly Sales Chart -->
                <div class="col-xl-6 mb-5 mb-xl-10">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header py-5">
                            <h3 class="card-title align-items-start flex-column">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="card-label fw-bolder text-dark"><?php echo e(__('translations.monthly-sales')); ?></span>
                                    <span class="badge badge-light-success ms-3 fs-7"><?php echo e($selectedYear ?? date('Y')); ?></span>
                                </div>
                                <span class="text-gray-500 mt-1 fw-semibold fs-6"><?php echo e(__('translations.sales-for-current-year')); ?></span>
                            </h3>
                        </div>
                        <div class="card-body pt-0">
                            <div id="sales_chart" class="min-h-auto" style="height: 320px"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Profit Chart -->
            <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
                <div class="col-xl-12">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header py-5">
                            <h3 class="card-title align-items-start flex-column">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="card-label fw-bolder text-dark"><?php echo e(__('translations.monthly-profits')); ?></span>
                                    <span class="badge badge-light-primary ms-3 fs-7"><?php echo e($selectedYear ?? date('Y')); ?></span>
                                </div>
                                <span class="text-gray-500 mt-1 fw-semibold fs-6"><?php echo e(__('translations.profits-for-current-year')); ?></span>
                            </h3>
                        </div>
                        <div class="card-body pt-0">
                            <div id="profits_chart" class="min-h-auto" style="height: 350px"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Products Table -->
            <div class="row g-5 g-xl-10">
                <div class="col-xl-12 mb-5 mb-xl-10">
                    <div class="card card-flush h-100 shadow-sm hover-elevate-up">
                        <div class="card-header py-5">
                            <h3 class="card-title align-items-start flex-column">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="card-label fw-bolder text-dark"><?php echo e(__('translations.top-products')); ?></span>
                                    <span class="badge badge-light-info ms-3 fs-7"><?php echo e(now()->format('F Y')); ?></span>
                                </div>
                                <span class="text-gray-500 mt-1 fw-semibold fs-6"><?php echo e(__('translations.top-selling-products-current-month')); ?></span>
                            </h3>
                        </div>
                        <div class="card-body pt-0">
                            <div class="table-responsive">
                                <table class="table align-middle table-row-dashed fs-6 gy-4 gs-7">
                                    <thead>
                                        <tr class="text-start text-gray-400 fw-bold fs-7 text-uppercase gs-0">
                                            <th class="min-w-150px"><?php echo e(__('translations.product')); ?></th>
                                            <th class="min-w-100px"><?php echo e(__('translations.category')); ?></th>
                                            <th class="min-w-100px text-end"><?php echo e(__('translations.quantity-sold')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="fw-semibold text-gray-600">
                                        <?php $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="symbol symbol-40px me-3">
                                                        <div class="symbol-label bg-light-primary">
                                                            <i class="bi bi-box fs-2 text-primary"></i>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex flex-column">
                                                        <span class="text-gray-800 fw-bold"><?php echo e($product->product->name ?? 'N/A'); ?></span>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo e($product->product->category->name ?? 'N/A'); ?></td>
                                            <td class="text-end">
                                                <span class="badge badge-light-success fw-bold"><?php echo e($product->total_quantity); ?></span>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<!-- Make sure ApexCharts is loaded -->
<script src="https://cdn.jsdelivr.net/npm/apexcharts@3.35.0/dist/apexcharts.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Check if ApexCharts is available
        if (typeof ApexCharts === 'undefined') {
            console.error('ApexCharts not loaded, attempting to load it now');
            // Try to load ApexCharts dynamically
            var script = document.createElement('script');
            script.src = 'https://cdn.jsdelivr.net/npm/apexcharts@3.35.0/dist/apexcharts.min.js';
            script.onload = function() {
                console.log('ApexCharts loaded dynamically');
                initCharts();
            };
            script.onerror = function() {
                console.error('Failed to load ApexCharts dynamically');
                document.querySelectorAll('.min-h-auto').forEach(function(el) {
                    el.innerHTML = '<div class="alert alert-danger">Failed to load chart library. Please refresh the page.</div>';
                });
            };
            document.head.appendChild(script);
        } else {
            console.log('ApexCharts already loaded');
            initCharts();
        }
    });

    function initCharts() {
        try {
            // Common chart options
            const chartFontFamily = 'Tajawal, sans-serif';
            const commonOptions = {
                chart: {
                    fontFamily: chartFontFamily,
                    toolbar: {
                        show: false
                    },
                    zoom: {
                        enabled: false
                    },
                    sparkline: {
                        enabled: false
                    },
                    animations: {
                        enabled: true,
                        easing: 'easeinout',
                        speed: 800,
                        animateGradually: {
                            enabled: true,
                            delay: 150
                        },
                        dynamicAnimation: {
                            enabled: true,
                            speed: 350
                        }
                    }
                },
                tooltip: {
                    theme: 'light',
                    marker: {
                        show: true
                    },
                    x: {
                        show: true
                    }
                },
                dataLabels: {
                    enabled: false
                }
            };

            // Helper function to check if chart data is empty
            function isChartDataEmpty(data) {
                if (!data || !Array.isArray(data)) return true;
                // Check if array is empty or contains only null/undefined values
                return data.length === 0 || data.every(function(value) {
                    return value === null || value === undefined;
                });
            }

            // Parse chart data
            const expensesData = <?php echo json_encode($monthlyExpenses['data'] ?? [], 15, 512) ?>;
            const expensesLabels = <?php echo json_encode($monthlyExpenses['labels'] ?? [], 15, 512) ?>;
            const salesData = <?php echo json_encode($monthlySales['data'] ?? [], 15, 512) ?>;
            const salesLabels = <?php echo json_encode($monthlySales['labels'] ?? [], 15, 512) ?>;
            const returnsData = <?php echo json_encode($monthlyReturns['data'] ?? [], 15, 512) ?>;
            const returnsLabels = <?php echo json_encode($monthlyReturns['labels'] ?? [], 15, 512) ?>;
            const profitsData = <?php echo json_encode($monthlyProfits['data'] ?? [], 15, 512) ?>;
            const profitsLabels = <?php echo json_encode($monthlyProfits['labels'] ?? [], 15, 512) ?>;

            // Debug data in console
            console.log('Selected Year:', "<?php echo e($selectedYear); ?>");
            console.log('Expenses Data:', expensesData);
            console.log('Expenses Labels:', expensesLabels);
            console.log('Sales Data:', salesData);
            console.log('Sales Labels:', salesLabels);
            console.log('Returns Data:', returnsData);
            console.log('Returns Labels:', returnsLabels);
            console.log('Profits Data:', profitsData);
            console.log('Profits Labels:', profitsLabels);

            // Check if selected year is in the future
            const currentYear = new Date().getFullYear();
            const selectedYear = parseInt("<?php echo e($selectedYear ?? date('Y')); ?>");
            const isFutureYear = selectedYear > currentYear;

            console.log('Current Year:', currentYear);
            console.log('Is Future Year:', isFutureYear);

            // Update UI elements for future years
            if (isFutureYear) {
                // Add visual indicators to card headers
                document.querySelectorAll('.card-header .badge').forEach(badge => {
                    if (badge.textContent.includes(selectedYear)) {
                        badge.classList.remove('badge-light-danger', 'badge-light-success', 'badge-light-primary', 'badge-light-info');
                        badge.classList.add('badge-light-warning');
                    }
                });

                // Show future year alert
                const futureYearAlert = document.getElementById('future_year_alert');
                if (futureYearAlert) {
                    futureYearAlert.style.display = 'flex !important';
                    // Force display using JS to override the !important in style attribute
                    setTimeout(() => {
                        futureYearAlert.style.cssText = 'display: flex !important';
                    }, 50);
                }
            }

            // Check if data is empty
            const expensesDataIsEmpty = isChartDataEmpty(expensesData);
            const salesDataIsEmpty = isChartDataEmpty(salesData);
            const profitsDataIsEmpty = isChartDataEmpty(profitsData);

            console.log('Is expenses data empty?', expensesDataIsEmpty);
            console.log('Is sales data empty?', salesDataIsEmpty);
            console.log('Is profits data empty?', profitsDataIsEmpty);

            // Force expenses data to be treated as not empty if it has any values above 0
            const hasExpenseData = Array.isArray(expensesData) && expensesData.some(value => value > 0);
            console.log('Has expense data:', hasExpenseData);

            // Expenses Chart
            const expensesChart = document.querySelector("#expenses_chart");
            if (expensesChart) {
                if (!expensesDataIsEmpty) {
                    const expensesOptions = {
                        ...commonOptions,
                        series: [{
                            name: '<?php echo e(__("translations.expenses")); ?>',
                            data: expensesData
                        }],
                        chart: {
                            ...commonOptions.chart,
                            type: 'area',
                            height: 320,
                        },
                        colors: ['#F1416C'],
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                opacityFrom: 0.7,
                                opacityTo: 0.2,
                                stops: [0, 90, 100]
                            }
                        },
                        stroke: {
                            curve: 'smooth',
                            width: 3
                        },
                        xaxis: {
                            categories: expensesLabels,
                            labels: {
                                style: {
                                    colors: '#787878',
                                    fontFamily: chartFontFamily,
                                }
                            },
                            axisBorder: {
                                show: false
                            }
                        },
                        yaxis: {
                            labels: {
                                style: {
                                    colors: '#787878',
                                    fontFamily: chartFontFamily,
                                },
                                formatter: function(val) {
                                    return val.toLocaleString()
                                }
                            },
                            min: 0,
                            forceNiceScale: true
                        },
                        tooltip: {
                            ...commonOptions.tooltip,
                            y: {
                                formatter: function (val) {
                                    return val.toLocaleString() + ' <?php echo e(__("translations.currency")); ?>'
                                }
                            }
                        }
                    };

                    setTimeout(function() {
                        const expensesChartObj = new ApexCharts(expensesChart, expensesOptions);
                        expensesChartObj.render();
                    }, 100);
                } else {
                    // Show different message for future years
                    if (isFutureYear) {
                        expensesChart.innerHTML = '<div class="d-flex justify-content-center align-items-center h-100"><div class="text-center"><i class="bi bi-calendar-x fs-1 text-warning mb-3"></i><div class="text-muted fs-3"><?php echo e(__("translations.future-year-no-data") ?? "لا توجد بيانات للسنوات القادمة"); ?></div></div></div>';
                    } else {
                        expensesChart.innerHTML = '<div class="d-flex justify-content-center align-items-center h-100"><span class="text-muted fs-3"><?php echo e(__("translations.no-expenses-data")); ?></span></div>';
                    }
                }
            } else {
                console.error("Expenses chart container not found");
            }

            // Process the raw sales data into numeric values
            const processedSalesData = salesData.map(value => {
                // Convert any string values to numbers and handle non-numeric values
                const numValue = typeof value === 'string' ? parseFloat(value) : value;
                return isNaN(numValue) ? 0 : numValue;
            });

            console.log('Original sales data:', salesData);
            console.log('Processed sales data:', processedSalesData);

            // Sales Chart
            const salesChart = document.querySelector("#sales_chart");
            if (salesChart) {
                // Clear any existing content
                salesChart.innerHTML = '';

                try {
                    const salesOptions = {
                        series: [{
                            name: '<?php echo e(__("translations.sales")); ?>',
                            data: processedSalesData
                        }],
                        chart: {
                            type: 'area',
                            height: 320,
                            fontFamily: chartFontFamily,
                            toolbar: {
                                show: false
                            },
                            zoom: {
                                enabled: false
                            }
                        },
                        colors: ['#50CD89'],
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                opacityFrom: 0.7,
                                opacityTo: 0.2,
                                stops: [0, 90, 100]
                            }
                        },
                        stroke: {
                            curve: 'smooth',
                            width: 3
                        },
                        xaxis: {
                            categories: salesLabels,
                            labels: {
                                style: {
                                    colors: '#787878',
                                    fontFamily: chartFontFamily,
                                }
                            },
                            axisBorder: {
                                show: false
                            }
                        },
                        yaxis: {
                            labels: {
                                style: {
                                    colors: '#787878',
                                    fontFamily: chartFontFamily,
                                },
                                formatter: function(val) {
                                    return val.toLocaleString()
                                }
                            },
                            min: 0,
                            forceNiceScale: true
                        },
                        tooltip: {
                            theme: 'light',
                            marker: {
                                show: true
                            },
                            x: {
                                show: true
                            },
                            y: {
                                formatter: function (val) {
                                    return val.toLocaleString() + ' <?php echo e(__("translations.currency")); ?>'
                                }
                            }
                        },
                        dataLabels: {
                            enabled: false
                        }
                    };

                    console.log('Rendering sales chart with options:', salesOptions);
                    const salesChartObj = new ApexCharts(salesChart, salesOptions);
                    salesChartObj.render();
                    console.log('Sales chart rendered successfully');
                } catch (error) {
                    console.error('Failed to render sales chart:', error);
                    salesChart.innerHTML = '<div class="d-flex justify-content-center align-items-center h-100 p-5"><div class="text-center"><span class="text-danger fs-3"><?php echo e(__("translations.chart-error") ?? "خطأ في عرض المخطط"); ?></span><div class="small text-muted mt-2">Error: ' + error.message + '</div></div></div>';
                }
            } else {
                console.error("Sales chart container not found");
            }

            // Profits Chart
            if (!profitsDataIsEmpty) {
                const profitsChart = document.querySelector("#profits_chart");
                if (profitsChart) {
                    const profitsOptions = {
                        ...commonOptions,
                        series: [{
                            name: '<?php echo e(__("translations.profits")); ?>',
                            data: profitsData
                        }],
                        chart: {
                            ...commonOptions.chart,
                            type: 'bar',
                            height: 350,
                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: '55%',
                                endingShape: 'rounded',
                                borderRadius: 4
                            },
                        },
                        colors: ['#009EF7'],
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shade: 'light',
                                type: "vertical",
                                shadeIntensity: 0.1,
                                gradientToColors: undefined,
                                inverseColors: true,
                                opacityFrom: 1,
                                opacityTo: 0.8,
                                stops: [0, 100]
                            },
                        },
                        dataLabels: {
                            enabled: false
                        },
                        stroke: {
                            show: true,
                            width: 2,
                            colors: ['transparent']
                        },
                        xaxis: {
                            categories: profitsLabels,
                            labels: {
                                style: {
                                    colors: '#787878',
                                    fontFamily: chartFontFamily,
                                }
                            },
                            axisBorder: {
                                show: false
                            }
                        },
                        yaxis: {
                            labels: {
                                style: {
                                    colors: '#787878',
                                    fontFamily: chartFontFamily,
                                },
                                formatter: function(val) {
                                    return val.toLocaleString()
                                }
                            },
                            min: 0,
                            forceNiceScale: true
                        },
                        tooltip: {
                            ...commonOptions.tooltip,
                            y: {
                                formatter: function (val) {
                                    return val.toLocaleString() + ' <?php echo e(__("translations.currency")); ?>'
                                }
                            }
                        }
                    };

                    setTimeout(function() {
                        const profitsChartObj = new ApexCharts(profitsChart, profitsOptions);
                        profitsChartObj.render();
                    }, 300);
                } else {
                    console.error("Profits chart container not found");
                }
            } else {
                const profitsChart = document.querySelector("#profits_chart");
                if (profitsChart) {
                    // Show different message for future years
                    if (isFutureYear) {
                        profitsChart.innerHTML = '<div class="d-flex justify-content-center align-items-center h-100"><div class="text-center"><i class="bi bi-calendar-x fs-1 text-warning mb-3"></i><div class="text-muted fs-3"><?php echo e(__("translations.future-year-no-data") ?? "لا توجد بيانات للسنوات القادمة"); ?></div></div></div>';
                    } else {
                        profitsChart.innerHTML = '<div class="d-flex justify-content-center align-items-center h-100"><span class="text-muted fs-3"><?php echo e(__("translations.no-profits-data")); ?></span></div>';
                    }
                }
            }
        } catch (error) {
            console.error('Error initializing charts:', error);
            // Show error on all chart containers
            document.querySelectorAll('.min-h-auto').forEach(function(el) {
                el.innerHTML = '<div class="alert alert-danger"><?php echo e(__("translations.chart-init-error") ?? "خطأ في تهيئة المخططات"); ?></div>';
            });
        }
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/financial_reports/index.blade.php ENDPATH**/ ?>