<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.examinations-list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.examinations')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <style>
        /* Estilos modernos para la tabla */
        #kt_datatable_example {
            border-collapse: separate;
            border-spacing: 0;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            width: 100%;
            margin-bottom: 2rem;
        }

        #kt_datatable_example thead tr {
            background-color: #f8f9fa;
            border-bottom: none;
        }

        #kt_datatable_example thead th {
            padding: 15px 20px;
            font-weight: 600;
            color: #5E6278;
            border-bottom: 1px solid #e9ecef;
            text-transform: uppercase;
            font-size: 0.85rem;
            letter-spacing: 0.5px;
            white-space: nowrap;
        }

        #kt_datatable_example tbody tr {
            transition: all 0.2s ease;
            border-left: 4px solid transparent;
        }

        #kt_datatable_example tbody tr:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        #kt_datatable_example td {
            padding: 16px 20px;
            vertical-align: middle;
            border-bottom: 1px solid #f0f0f0;
        }

        /* Estilos específicos para cada columna */
        #kt_datatable_example td:nth-child(1) { /* Código */
            font-weight: 600;
            width: 10%;
            white-space: nowrap;
        }

        #kt_datatable_example td:nth-child(2) { /* Nombre del cliente */
            width: 15%;
            white-space: nowrap;
        }

        #kt_datatable_example td:nth-child(3) { /* Nota */
            width: 35%;
        }

        #kt_datatable_example td:nth-child(4) { /* Tipo */
            width: 10%;
            white-space: nowrap;
        }

        #kt_datatable_example td:nth-child(5) { /* Fecha */
            width: 12%;
            white-space: nowrap;
        }

        #kt_datatable_example td:nth-child(6) { /* Acciones */
            width: 18%;
            text-align: right;
        }

        /* Estilos para los tipos de exámenes */
        tr[data-status="عادي"] {
            border-left: 4px solid #a1a5b7;
        }

        tr[data-status="مميز"] {
            border-left: 4px solid #ffc700;
        }

        tr[data-status="مستعجل"] {
            border-left: 4px solid #f1416c;
        }

        tr[data-status="تحضير"] {
            border-left: 4px solid #50cd89;
        }

        tr[data-status="توصيل"] {
            border-left: 4px solid #009ef7;
        }

        /* Tipos de exámenes con estilos modernos */
        .exam-badge {
            padding: 6px 12px;
            border-radius: 50px;
            font-size: 0.75rem;
            font-weight: 600;
            display: inline-block;
            text-align: center;
            min-width: 80px;
        }

        .exam-badge-regular {
            background-color: #f8f9fa;
            color: #5E6278;
        }

        .exam-badge-special {
            background-color: #fff8dd;
            color: #ffc700;
        }

        .exam-badge-urgent {
            background-color: #fff5f8;
            color: #f1416c;
        }

        .exam-badge-preparation {
            background-color: #e8fff3;
            color: #50cd89;
        }

        .exam-badge-delivery {
            background-color: #f1faff;
            color: #009ef7;
        }

        /* Botones modernos */
        .action-btn {
            padding: 8px 16px;
            border-radius: 6px;
            transition: all 0.2s ease;
            font-weight: 500;
            background-color: #f8f9fa;
            color: #5E6278;
            border: none;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }

        .action-btn:hover {
            background-color: #009ef7;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 158, 247, 0.3);
        }

        /* Estilos para card principal */
        .reception-card {
            border-radius: 12px;
            box-shadow: 0 6px 30px rgba(0, 0, 0, 0.05);
            border: none;
            overflow: hidden;
        }

        .reception-card .card-header {
            border-bottom: 1px solid #f1f1f2;
            padding: 20px 25px;
        }

        .reception-card .card-body {
            padding: 25px;
        }

        /* Modernización del buscador */
        .search-container {
            position: relative;
            margin-bottom: 25px;
        }

        .search-input {
            padding: 12px 20px 12px 50px;
            border-radius: 8px;
            border: 1px solid #e9ecef;
            background-color: #f9f9f9;
            transition: all 0.2s ease;
            width: 350px;
            font-size: 0.95rem;
        }

        .search-input:focus {
            border-color: #009ef7;
            background-color: white;
            box-shadow: 0 0 0 4px rgba(0, 158, 247, 0.15);
        }

        .search-icon {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #a1a5b7;
        }

        /* Botón de crear */
        .create-button {
            background-color: var(--primary-color);
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            color: var(--text-color);
            font-weight: 500;
            box-shadow: 0 4px 14px rgba(0, 158, 247, 0.3);
            transition: all 0.2s ease;
        }

        .create-button:hover {
            background-color: var(--primary-color);
            transform: translateY(-2px);
            box-shadow: 0 6px 18px rgba(0, 158, 247, 0.4);
        }

        .create-button .svg-icon {
            margin-right: 8px;
        }

        /* Ajustes responsivos para la tabla */
        @media (max-width: 992px) {
            #kt_datatable_example {
                overflow-x: auto;
                display: block;
            }

            .search-input {
                width: 100%;
            }
        }

        /* Estilo para notas */
        .note-text {
            font-size: 0.85rem;
            color: #7E8299;
            max-height: 60px;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
        }

        /* Estilo para códigos de examen */
        .exam-code {
            font-family: 'Courier New', monospace;
            background: #f1f3f4;
            padding: 4px 8px;
            border-radius: 4px;
            letter-spacing: 0.5px;
        }

        /* Estilo para fechas */
        .exam-date {
            color: #7E8299;
            font-size: 0.85rem;
        }
    </style>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2 reception-card">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0"><?php echo e(__('translations.examinations-list')); ?></h3>
                                </div>
                                <div class="card-toolbar">
                                    <?php if (app('laratrust')->hasPermission('receptions-create')) : ?>
                                        <a href="<?php echo e(route('admin.receptions.create')); ?>" class="btn create-button">
                                            <span class="svg-icon svg-icon-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none">
                                                    <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2"
                                                        rx="1" transform="rotate(-90 11.364 20.364)" fill="var(--sidebar-text-color)"
                                                        stroke="var(--sidebar-text-color)" stroke-width="3"></rect>
                                                    <rect x="4.36396" y="11.364" width="16" height="2" rx="1"
                                                        fill="var(--sidebar-text-color)" stroke="var(--sidebar-text-color)" stroke-width="3"></rect>
                                                </svg>
                                            </span>
                                            <span style="color: var(--sidebar-text-color)"><?php echo e(__('translations.examination-speed-create')); ?></span>
                                        </a>
                                    <?php endif; // app('laratrust')->permission ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="search-container">
                                    <span class="search-icon">
                                        <svg width="20" height="20" viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                                        </svg>
                                    </span>
                                    <input type="text" data-kt-filter="search"
                                        class="form-control form-control-solid search-input"
                                        placeholder="<?php echo e(__('translations.examinations-search')); ?>" />
                                </div>

                                <div class="table-responsive">
                                    <?php
                                        $specialClasses = [
                                            'عادي' => 'exam-badge-regular',
                                            'مميز' => 'exam-badge-special',
                                            'مستعجل' => 'exam-badge-urgent',
                                            'تحضير' => 'exam-badge-preparation',
                                            'توصيل' => 'exam-badge-delivery',
                                        ];
                                    ?>

                                    <table id="kt_datatable_example"
                                        class="table align-middle table-row-dashed fs-6 gy-5 custom-table">
                                        <thead>
                                            <tr class="fw-bolder fs-8 text-uppercase gs-0">
                                                <th><?php echo e(__('translations.Examination Code')); ?></th>
                                                <th><?php echo e(__('translations.Client name')); ?></th>
                                                <th><?php echo e(__('translations.Note')); ?></th>
                                                <th><?php echo e(__('translations.type')); ?></th>
                                                <th><?php echo e(__('translations.Date')); ?></th>
                                                <th class="text-end"><?php echo e(__('translations.actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-gray-800">
                                            <?php $__currentLoopData = $examinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $badgeClass = $specialClasses[$examination->special] ?? 'exam-badge-regular';
                                                ?>
                                                <tr data-status="<?php echo e($examination->special); ?>">
                                                    <td><span class="exam-code"><?php echo e($examination->code); ?></span></td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="symbol symbol-30px me-3 bg-light rounded-circle">
                                                                <span class="symbol-label bg-light-primary text-primary fw-bold">
                                                                    <?php echo e(substr($examination->client->first_name ?? 'U', 0, 1)); ?>

                                                                </span>
                                                            </div>
                                                            <div class="fw-bold">
                                                                <?php echo e($examination->client->first_name ?? ''); ?> <?php echo e($examination->client->last_name ?? ''); ?>

                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="note-text">
                                                            <?php echo $examination->notes; ?>

                                                        </div>
                                                    </td>
                                                    <td><?php echo e($examination->type); ?></td>
                                                    <td>
                                                        <span class="exam-date">
                                                            <?php echo e(\Carbon\Carbon::parse($examination->created_at)->format('d M Y, H:i')); ?>

                                                        </span>
                                                    </td>
                                                    <td class="text-end">
                                                        <div class="d-flex align-items-center justify-content-end">
                                                            <span class="exam-badge <?php echo e($badgeClass); ?> me-3">
                                                                <?php echo e($examination->special); ?>

                                                            </span>

                                                            <?php if (app('laratrust')->hasPermission('receptions-show')) : ?>
                                                                <a href="<?php echo e(route('admin.receptions.show', $examination->id)); ?>"
                                                                    class="btn action-btn">
                                                                    <?php echo e(__('translations.show')); ?>

                                                                </a>
                                                            <?php endif; // app('laratrust')->permission ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/receptions/index.blade.php ENDPATH**/ ?>