<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($setting->name); ?></title>

    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background: #f9f9f9;
            font-weight: 500;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: 20px auto;
            background: #fff;
            padding: 30px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            border-radius: 12px;
            position: relative;
        }

        .logo-section {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }

        .logo img {
            width: 100px;
            height: auto;
            object-fit: contain;
        }

        .company-info {
            display: flex;
            flex-direction: column;
            text-align: right;
            margin-right: -120px;
        }

        .company-name {
            font-size: 20px;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .company-details {
            font-size: 14px;
            color: #555;
        }

        .client-info {
            display: flex;
            flex-direction: column;
            text-align: center;
        }

        .client-name {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .client-code {
            font-size: 18px;
            color: #555;
        }

        .special-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            color: #fff;
        }

        .tables-section {
            margin-top: 30px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table th,
        table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }

        table th {
            background: #f8f9fa;
            font-weight: 600;
        }

        .price-table {
            width: 300px;
            margin-bottom: 25px;
        }

        .price-table td:first-child {
            width: 70%;
        }

        .price-table td:last-child {
            width: 30%;
            font-weight: 600;
        }

        .details-table th,
        .details-table td {
            padding: 8px;
        }

        .delivery-table {
            margin-top: 20px;
        }

        .divider {
            width: 100%;
            height: 1px;
            background: #eee;
            margin: 30px 0;
        }

        @media print {
            body {
                background: white;
                padding: 0;
                margin: 0;
            }

            .container {
                max-width: 100%;
                margin: 0;
                padding: 20px;
                box-shadow: none;
                border-radius: 0;
            }

            .footer {
                display: none;
            }
        }
    </style>
</head>

<body dir="rtl">
    <div class="container">
        <div class="logo-section">
            <div class="logo">
                <?php if($setting->logo): ?>
                    <img src="<?php echo e(asset('uploads/' . $setting->logo)); ?>" alt="logo">
                <?php else: ?>
                    <img src="<?php echo e(asset('logo.png')); ?>" alt="logo">
                <?php endif; ?>
            </div>

            <div class="company-info">
                <div class="company-name"><?php echo e($setting->name); ?></div>
                <div class="company-details">
                    <div><?php echo e($setting->address ?? ''); ?></div>
                    <div><?php echo e($setting->phone1 ?? ''); ?></div>
                </div>
            </div>

            <div class="client-info">
                <div class="client-name">
                    <?php echo e($examination->client->first_name); ?> <?php echo e($examination->client->last_name); ?>

                </div>
                <div class="client-code"><?php echo e($examination->code); ?></div>
            </div>

            <?php
                $specialColors = [
                    'عادي' => '#6c757d', // Gray
                    'مميز' => '#ffc107', // Gold
                    'مستعجل' => '#dc3545', // Red
                    'تحضير' => '#28a745', // Green
                    'توصيل' => '#007bff', // Blue
                ];

                $currentSpecial = $examination->special;
                $currentColor = $specialColors[$currentSpecial] ?? '#6c757d';
            ?>

            <div class="special-status">
                <span class="special-badge" style="background-color: <?php echo e($currentColor); ?>">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 17.27L18.18 21L16.54 13.97L22 9.24L14.81 8.63L12 2L9.19 8.63L2 9.24L7.46 13.97L5.82 21L12 17.27Z" fill="currentColor"/>
                    </svg>
                    <?php echo e($currentSpecial); ?>

                </span>
            </div>
        </div>

        <div class="tables-section">
            <div class="price-info">
                <table class="price-table">
                    <tbody>
                        <tr>
                            <td></td>
                            <td><?php echo e(__('translations.price')); ?></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td><?php echo e(__('translations.paid')); ?></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td><?php echo e(__('translations.remaining')); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <table class="details-table" dir="ltr">
                <thead>
                    <tr>
                        <th><?php echo e(__('translations.Type')); ?></th>
                        <th><?php echo e(__('translations.Sph')); ?></th>
                        <th><?php echo e(__('translations.Cyl')); ?></th>
                        <th><?php echo e(__('translations.Axis')); ?></th>
                        <th><?php echo e(__('translations.A.D.D')); ?></th>
                        <th><?php echo e(__('translations.I.P.D')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $examination->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->type); ?></td>
                            <td><?php echo e($item->sph); ?></td>
                            <td><?php echo e($item->cyl); ?></td>
                            <td><?php echo e($item->axis); ?></td>
                            <td><?php echo e($item->lpd); ?></td>
                            <td><?php echo e($item->add); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <table class="delivery-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('translations.AAA')); ?></th>
                        <th>الخميس</th>
                        <th>الاربعاء</th>
                        <th>الثلاثاء</th>
                        <th>الاثنين</th>
                        <th>الاحد</th>
                        <th>السبت</th>
                    </tr>
                </thead>
            </table>

            <div class="divider"></div>
            <div class="divider"></div>
            <div class="divider"></div>
            <div class="divider"></div>
        </div>
    </div>

    <script>
        window.onload = function() {
            setTimeout(() => {
                window.print();
            }, 1000);
        };
    </script>
</body>
</html>
<?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/receptions/print_special.blade.php ENDPATH**/ ?>