<?php $__env->startSection('title', __('translations.clients-reports')); ?>
<?php $__env->startSection('sub-title', __('translations.reports')); ?>

<?php $__env->startSection('content'); ?>
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <div class="row">
                <!-- Summary Cards -->
                <div class="col-md-4">
                    <div class="card card-body">
                        <h4 id="total_clients_display"><?php echo e(__('translations.total_clients')); ?>: <?php echo e($totalClients); ?></h4>
                    </div>
                </div>
                <!--<div class="col-md-4">-->
                <!--    <div class="card card-body">-->
                <!--        <h4 id="total_men_display"><?php echo e(__('translations.total_men')); ?>: <?php echo e($totalMen); ?></h4>-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="col-md-4">-->
                <!--    <div class="card card-body">-->
                <!--        <h4 id="total_women_display"><?php echo e(__('translations.total_women')); ?>: <?php echo e($totalWomen); ?></h4>-->
                <!--    </div>-->
                <!--</div>-->
            </div>

            <div class="card card-docs mb-2">
                <div class="card-header">
                    <div class="card-title m-0">
                        <h3 class="fw-bolder m-0"><?php echo e(__('translations.clients-reports')); ?></h3>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-4">
                        <?php
                            $filters = [
                                'first_name' => __('translations.first_name'),
                                'last_name' => __('translations.last_name'),
                                'phone' => __('translations.phone'),
                            ];
                        ?>

                        <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-3 mb-3">
                                <input type="text" id="<?php echo e($key); ?>" class="form-control" placeholder="<?php echo e($label); ?>">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <div class="col-md-3 mb-3">
                            <input type="date" id="birth_date" class="form-control" placeholder="<?php echo e(__('translations.birth_date')); ?>">
                        </div>

                        <div class="col-md-3 mb-3">
                            <select id="city_id" class="form-control">
                                <option value=""><?php echo e(__('translations.select_city')); ?></option>
                                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <select id="region_id" class="form-control">
                                <option value=""><?php echo e(__('translations.select_region')); ?></option>
                                <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($region->id); ?>"><?php echo e($region->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-3 mb-3">
                            <select id="gender" class="form-control">
                                <option value=""><?php echo e(__('translations.select_gender')); ?></option>
                                <option value="man"><?php echo e(__('translations.male')); ?></option>
                                <option value="women"><?php echo e(__('translations.female')); ?></option>
                            </select>
                        </div>

                       <div class="d-flex  justify-content-around">
                        <div class="col-md-4 mb-3">
                            <button id="search_button" class="btn btn-primary w-100"><?php echo e(__('translations.search')); ?></button>
                        </div>


                        <div class="col-md-4 mb-3">
                            <a href="<?php echo e(route('admin.clients.export')); ?>" class="btn btn-success w-100"><?php echo e(__('translations.Excel')); ?></a>
                        </div>
                       </div>
                    </div>

                    <!-- Clients Table -->
                    <div id="reports-body">
                        <?php echo $__env->make('admin.reports.partials.clients_table', ['clients' => $clients], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script>
$(document).ready(function() {
    $('#search_button').on('click', function() {
        let filters = {};
        $('#first_name, #last_name, #birth_date, #address, #phone, #city_id, #region_id, #gender').each(function() {
            if ($(this).val() !== '') {
                filters[$(this).attr('id')] = $(this).val();
            }
        });

        $.ajax({
            url: "<?php echo e(route('admin.clients.filter')); ?>",
            method: 'GET',
            data: filters,
            success: function(data) {
                $('#reports-body').html(data.html);
                $('#total_clients_display').text('<?php echo e(__('translations.total_clients')); ?>: ' + data.total_clients);
                $('#total_men_display').text('<?php echo e(__('translations.total_men')); ?>: ' + data.total_men);
                $('#total_women_display').text('<?php echo e(__('translations.total_women')); ?>: ' + data.total_women);
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/reports/client.blade.php ENDPATH**/ ?>