<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.clients-edit')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.clients')); ?>

<?php $__env->stopSection(); ?>

<head>
    <!-- تحميل CSS لـ Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        .card-docs {
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08) !important;
            border: none;
        }
        .card-header {
            border-radius: 12px 12px 0 0 !important;
            background:  linear-gradient(135deg, #3a7bd5, #2196f3) !important;
        }
        .card-title h3 {
            color: #ffffff !important;
            font-weight: 600 !important;
        }
        .form-control-solid, .form-select-solid {
            border-radius: 8px;
            border: 1px solid #e5e7eb;
            transition: all 0.3s;
        }
        .form-control-solid:focus, .form-select-solid:focus {
            border-color: #4e4376;
            box-shadow: 0 0 0 3px rgba(78, 67, 118, 0.1);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(78, 67, 118, 0.2);
        }
        .btn-light {
            background: #f8fafc;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 10px 20px;
            transition: all 0.3s;
        }
        .btn-light:hover {
            background: #f1f5f9;
            transform: translateY(-2px);
        }
        .section-title {
            position: relative;
            display: inline-block;
            padding-left: 18px;
        }
        .section-title:before {
            content: "";
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 8px;
            height: 25px;
            background: linear-gradient(135deg, #2b5876, #4e4376);
            border-radius: 4px;
        }
        .input-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #6b7280;
        }
        .input-group-prepend {
            margin-right: -1px;
        }
        .form-group {
            position: relative;
        }
        .phone-input-container {
            display: flex;
            align-items: stretch;
        }
        .phone-input-container .country-select {
            min-width: 140px;
            border-radius: 8px 0 0 8px !important;
        }
        .phone-input-container .phone-input {
            border-radius: 0 8px 8px 0 !important;
            flex-grow: 1;
        }
        .flag-icon {
            width: 20px;
            margin-right: 5px;
        }
    </style>
</head>

<?php $__env->startSection('content'); ?>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-5">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bold m-0">
                                        <i class="fa fa-user-edit me-2"></i>
                                        <?php echo e(__('translations.clients-edit')); ?>

                                    </h3>
                                </div>
                            </div>

                            <div class="card-body p-lg-5">
                                <form action="<?php echo e(route('admin.clients.update', $client->id)); ?>" method="post"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?> <!-- For update method -->

                                    <!-- Personal Information -->
                                    <div class="mb-5">
                                        <h4 class="fs-5 fw-semibold mb-3 text-gray-700 section-title">
                                            <?php echo e(__('translations.Client Information')); ?>

                                        </h4>
                                        <div class="separator separator-dashed mb-4"></div>

                                        <div class="row">
                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-id-card text-primary me-2"></i>
                                                    <?php echo e(__('translations.first name')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <div class="position-relative">
                                                    <input type="text" class="form-control form-control-solid ps-3"
                                                        name="first_name" value="<?php echo e(old('first_name', $client->first_name)); ?>" required />
                                                </div>
                                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-user text-primary me-2"></i>
                                                    <?php echo e(__('translations.last name')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <div class="position-relative">
                                                    <input type="text" class="form-control form-control-solid ps-3"
                                                        name="last_name" value="<?php echo e(old('last_name', $client->last_name)); ?>" required />
                                                </div>
                                                <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-phone-alt text-primary me-2"></i>
                                                    <?php echo e(__('translations.phone')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <div class="phone-input-container">
                                                    <select id="country_code" class="form-select form-select-solid country-select"
                                                        data-control="select2" name="country_code" required>
                                                        <option value="" disabled><?php echo e(__('translations.SelectCountryCode')); ?></option>
                                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option <?php echo e(old('country_code', $client->country_code) == $country->phone ? 'selected' : ''); ?>

                                                                value="<?php echo e($country->phone); ?>">
                                                                <?php echo e($country->name_ar); ?> (<?php echo e($country->phone); ?>)
                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <input type="text" class="form-control form-control-solid phone-input"
                                                        placeholder="<?php echo e(__('translations.phone')); ?>"
                                                        name="phone" value="<?php echo e(old('phone', $client->phone)); ?>" required />
                                                </div>
                                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-3 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-birthday-cake text-primary me-2"></i>
                                                    <?php echo e(__('translations.age')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <div class="position-relative">
                                                    <input type="number" placeholder="<?php echo e(__('translations.age')); ?>"
                                                        class="form-control form-control-solid"
                                                        name="age" value="<?php echo e(old('age', $client->age)); ?>" required />
                                                </div>
                                                <?php $__errorArgs = ['age'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-3 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-venus-mars text-primary me-2"></i>
                                                    <?php echo e(__('translations.Gender')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select form-select-solid" name="gender" required>
                                                    <option value=""><?php echo e(__('translations.Gender')); ?></option>
                                                    <option value="man" <?php echo e(old('gender', $client->gender) == 'man' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('translations.man')); ?>

                                                    </option>
                                                    <option value="woman" <?php echo e(old('gender', $client->gender) == 'woman' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('translations.women')); ?>

                                                    </option>
                                                </select>
                                                <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-map-marker-alt text-primary me-2"></i>
                                                    <?php echo e(__('translations.City')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select form-select-solid" name="city_id" id="city_id">
                                                    <option value=""><?php echo e(__('translations.SelectCity')); ?></option>
                                                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($city->id); ?>"
                                                            <?php echo e(old('city_id', $client->city_id) == $city->id ? 'selected' : ''); ?>>
                                                            <?php echo e($city->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-md-6 mb-4">
                                                <label class="form-label fw-semibold">
                                                    <i class="fa fa-map text-primary me-2"></i>
                                                    <?php echo e(__('translations.Region')); ?> <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select form-select-solid" name="region_id" id="region_id">
                                                    <option value=""><?php echo e(__('translations.SelectRegion')); ?></option>
                                                    <?php if($client->city): ?>
                                                        <?php $__currentLoopData = $client->city->regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($region->id); ?>"
                                                                <?php echo e(old('region_id', $client->region_id) == $region->id ? 'selected' : ''); ?>>
                                                                <?php echo e($region->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </select>
                                                <?php $__errorArgs = ['region_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="fv-plugins-message-container invalid-feedback mt-1">
                                                        <strong><?php echo e($message); ?></strong>
                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="d-flex pt-3 border-top justify-content-between align-items-center">
                                        <a href="<?php echo e(route('admin.clients.index')); ?>" class="btn btn-light">
                                            <i class="fa fa-arrow-left me-1"></i> <?php echo e(__('translations.back')); ?>

                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fa fa-check-circle me-1"></i> <?php echo e(__('translations.update')); ?>

                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // تهيئة Select2
            if (typeof $.fn.select2 !== 'undefined') {
                $('.form-select').select2({
                    minimumResultsForSearch: 10,
                    dropdownCssClass: "select2-dropdown-bordered"
                });
            }

            // تحويل البيانات من PHP إلى جافا سكريبت
            const regionsByCity = <?php echo json_encode(
                $cities->mapWithKeys(function ($city) {
                    return [
                        $city->id => $city->regions->pluck('name', 'id')->toArray(), // تحويل البيانات إلى مصفوفة
                    ];
                })) ?>;

            // الحصول على العناصر
            const citySelect = document.getElementById('city_id');
            const regionSelect = document.getElementById('region_id');

            // عند تغيير المدينة
            citySelect.addEventListener('change', function() {
                const cityId = this.value;

                // مسح المناطق السابقة
                regionSelect.innerHTML = '<option value=""><?php echo e(__('translations.SelectRegion')); ?></option>';

                if (cityId && regionsByCity[cityId]) {
                    // إضافة المناطق بناءً على المدينة المختارة
                    Object.entries(regionsByCity[cityId]).forEach(function([regionId, regionName]) {
                        const option = document.createElement('option');
                        option.value = regionId; // استخدم معرف المنطقة كقيمة
                        option.textContent = regionName; // استخدم اسم المنطقة كنص
                        regionSelect.appendChild(option);
                    });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/clients/edit.blade.php ENDPATH**/ ?>