<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.settings-edit')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<style>
    .settings-card {
        border-radius: 10px;
        background-color: #fff;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .settings-tabs {
        padding: 1rem;
    }

    .settings-tab {
        display: flex;
        align-items: center;
        padding: 0.75rem 1rem;
        margin-bottom: 0.5rem;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
    }

    .settings-tab.active {
        background-color: #f1f8ff;
        color: #0d6efd;
    }

    .settings-tab:hover:not(.active) {
        background-color: #f8f9fa;
    }

    .settings-tab-icon {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 0.75rem;
        font-size: 14px;
    }

    .settings-tab-text {
        font-weight: 500;
        font-size: 14px;
    }

    .tab-content {
        display: none;
        padding: 1.5rem;
    }

    .tab-content.active {
        display: block;
        animation: fadeIn 0.3s;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }

    .form-control {
        border-radius: 8px;
        padding: 0.6rem 1rem;
        border: 1px solid #e0e0e0;
        transition: all 0.2s;
    }

    .form-control:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.15rem rgba(13, 110, 253, 0.1);
    }

    .form-label {
        font-weight: 500;
        color: #555;
        margin-bottom: 0.5rem;
        font-size: 14px;
    }

    .input-group-text {
        border-radius: 8px 0 0 8px;
        border: 1px solid #e0e0e0;
        background-color: #f9f9f9;
    }

    .btn {
        border-radius: 8px;
        padding: 0.6rem 1.25rem;
        font-weight: 500;
        transition: all 0.2s;
    }

    .btn-primary {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }

    .btn-primary:hover {
        background-color: #0b5ed7;
        border-color: #0b5ed7;
    }

    .btn-light {
        background-color: #f8f9fa;
        border-color: #e0e0e0;
        color: #555;
    }

    .btn-light:hover {
        background-color: #e9ecef;
        border-color: #ddd;
    }

    .tab-content-header {
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 1px solid #f1f1f4;
    }

    .tab-content-header h3 {
        font-size: 18px;
        color: #333;
    }

    .upload-zone {
        border: 2px dashed #ddd;
        border-radius: 10px;
        padding: 2rem;
        text-align: center;
        transition: all 0.2s;
        background-color: #fafafa;
    }

    .upload-zone:hover {
        border-color: #0d6efd;
        background-color: #f8f9fa;
    }

    .logo-preview {
        max-width: 100%;
        max-height: 100px;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content d-flex flex-column flex-column-fluid">
    <div class="container-fluid">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <h1 class="fs-4 fw-bold text-dark"><?php echo e(__('translations.settings')); ?></h1>
        </div>

        <form id="settings-form" action="<?php echo e(route('admin.settings.update')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row g-4">

                <!-- Content -->
                <div class="col-12 col-lg-12">
                    <div class="settings-card">
                        <!-- Company Tab -->
                        <div id="company-tab" class="tab-content active">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0"><?php echo e(__('translations.company_information')); ?></h3>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-name_ar')); ?></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="name_ar" value="<?php echo e($setting->translate('ar')->name); ?>" required />
                                    <?php $__errorArgs = ['name_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-name_en')); ?></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="name_en" value="<?php echo e($setting->translate('en')->name); ?>" required />
                                    <?php $__errorArgs = ['name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-12">
                                    <label class="form-label"><?php echo e(__('translations.settings-email')); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-envelope text-primary"></i>
                                        </span>
                                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="email" value="<?php echo e($setting->email); ?>" required />
                                    </div>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Contact Tab -->
                        <div id="contact-tab" class="tab-content">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0"><?php echo e(__('translations.contact_information')); ?></h3>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-address_ar')); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-map-marker text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control <?php $__errorArgs = ['address_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="address_ar" value="<?php echo e($setting->translate('ar')->address); ?>" required />
                                    </div>
                                    <?php $__errorArgs = ['address_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-address_en')); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-map-marker text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control <?php $__errorArgs = ['address_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="address_en" value="<?php echo e($setting->translate('en')->address); ?>" required />
                                    </div>
                                    <?php $__errorArgs = ['address_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-phone1')); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-phone text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control <?php $__errorArgs = ['phone1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="phone1" value="<?php echo e($setting->phone1); ?>" required />
                                    </div>
                                    <?php $__errorArgs = ['phone1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-phone2')); ?></label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fa fa-phone text-primary"></i>
                                        </span>
                                        <input type="text" class="form-control <?php $__errorArgs = ['phone2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="phone2" value="<?php echo e($setting->phone2); ?>" required />
                                    </div>
                                    <?php $__errorArgs = ['phone2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Description Tab -->
                        <div id="description-tab" class="tab-content">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0"><?php echo e(__('translations.description')); ?></h3>
                            </div>

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-description_ar')); ?></label>
                                    <textarea class="form-control <?php $__errorArgs = ['description_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="description_ar" rows="6" required><?php echo e($setting->translate('ar')->description); ?></textarea>
                                    <?php $__errorArgs = ['description_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label"><?php echo e(__('translations.settings-description_en')); ?></label>
                                    <textarea class="form-control <?php $__errorArgs = ['description_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="description_en" rows="6" required><?php echo e($setting->translate('en')->description); ?></textarea>
                                    <?php $__errorArgs = ['description_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Media Tab -->
                        <div id="media-tab" class="tab-content">
                            <div class="tab-content-header">
                                <h3 class="fw-bold m-0"><?php echo e(__('translations.media')); ?></h3>
                            </div>

                            <div class="row justify-content-center g-4">
                                <?php if(isset($setting->logo)): ?>
                                <div class="col-12 text-center mb-3">
                                    <div class="mb-3">
                                        <img src="<?php echo e(asset('storage/' . $setting->logo)); ?>" alt="Current Logo"
                                            class="logo-preview border p-2">
                                        <p class="text-muted small mt-2"><?php echo e(__('translations.current_logo')); ?></p>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="col-md-8">
                                    <div class="upload-zone">
                                        <i class="fa fa-cloud-upload text-primary fs-3 mb-2"></i>
                                        <h5 class="mb-3"><?php echo e(__('translations.settings-logo')); ?></h5>
                                        <input type="file" class="form-control d-none" name="logo" accept="image/*" id="logo-upload">
                                        <button type="button" id="logo-trigger" class="btn btn-primary">
                                            <i class="fa fa-upload me-1"></i> <?php echo e(__('translations.choose_file')); ?>

                                        </button>
                                        <p class="text-muted small mt-2" id="selected-file"><?php echo e(__('translations.no_file_selected')); ?></p>
                                        <?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="text-danger mt-2"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <a href="<?php echo e(route('admin.index')); ?>" class="btn btn-light me-2">
                                    <i class="fa fa-times me-1"></i> <?php echo e(__('translations.cancel')); ?>

                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save me-1"></i> <?php echo e(__('translations.edit')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Tab navigation
        const tabs = document.querySelectorAll('.settings-tab');
        const tabContents = document.querySelectorAll('.tab-content');

        tabs.forEach(tab => {
            tab.addEventListener('click', function() {
                const targetTab = this.getAttribute('data-tab');

                // Update active tab
                tabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');

                // Update tab content
                tabContents.forEach(content => content.classList.remove('active'));
                document.getElementById(`${targetTab}-tab`).classList.add('active');
            });
        });

        // File upload trigger
        document.getElementById('logo-trigger').addEventListener('click', function() {
            document.getElementById('logo-upload').click();
        });

        // File upload display
        document.getElementById('logo-upload').addEventListener('change', function() {
            const fileName = this.files[0] ? this.files[0].name : '<?php echo e(__("translations.no_file_selected")); ?>';
            document.getElementById('selected-file').textContent = fileName;
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>