<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.examinations-create')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.examinations')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Enhanced Modern Design Styling */
    :root {
        --primary-color: #4361ee;
        --primary-gradient: linear-gradient(135deg, #3a7bd5, #2196f3);
        --secondary-color: #4cc9f0;
        --light-bg: #f8f9fa;
        --dark-text: #2b2d42;
        --medium-text: #555b6e;
        --light-text: #8d99ae;
        --border-radius: 10px;
        --shadow-sm: 0 2px 10px rgba(0, 0, 0, 0.05);
        --shadow-md: 0 5px 20px rgba(0, 0, 0, 0.08);
        --shadow-lg: 0 10px 30px rgba(0, 0, 0, 0.1);
        --transition: all 0.3s ease;
    }

    body {
        background-color: #f0f2f5 !important;
    }

    .full-width-container {
        width: 100%;
        padding: 0 30px;
        max-width: 100%;
    }

    .form-control, .select2-selection {
        border-radius: var(--border-radius) !important;
        border: 1px solid #e2e8f0 !important;
        padding: 12px 16px !important;
        transition: var(--transition) !important;
        background-color: #ffffff !important;
        font-size: 0.95rem !important;
        height: auto !important;
        color: var(--dark-text) !important;
    }

    .form-control:focus, .select2-container--focus .select2-selection {
        border-color: var(--primary-color) !important;
        box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15) !important;
        background-color: #fff !important;
    }

    .form-control::placeholder {
        color: var(--light-text) !important;
        opacity: 0.7 !important;
    }

    .ultra-modern-card {
        border-radius: 16px !important;
        box-shadow: var(--shadow-md) !important;
        border: none !important;
        overflow: hidden !important;
        background-color: #ffffff !important;
        margin-bottom: 30px !important;
        transition: var(--transition) !important;
    }

    .ultra-modern-card:hover {
        box-shadow: var(--shadow-lg) !important;
        transform: translateY(-2px) !important;
    }

    .ultra-modern-card .card-header {
        background: var(--primary-gradient) !important;
        padding: 25px 30px !important;
        border: none !important;
        position: relative !important;
        overflow: hidden !important;
    }

    .ultra-modern-card .card-header:before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 100%;
        height: 200%;
        background: rgba(255, 255, 255, 0.1);
        transform: rotate(-30deg);
    }

    .ultra-modern-card .card-header h3 {
        color: #fff !important;
        font-size: 1.75rem !important;
        font-weight: 700 !important;
        margin: 0 !important;
        position: relative !important;
        z-index: 2 !important;
    }

    .ultra-modern-card .card-body {
        padding: 35px !important;
        background-color: #fff !important;
    }

    label.form-label {
        font-weight: 600 !important;
        color: var(--dark-text) !important;
        margin-bottom: 10px !important;
        font-size: 0.95rem !important;
        display: flex !important;
        align-items: center !important;
    }

    label.form-label i {
        margin-right: 8px !important;
        color: var(--primary-color) !important;
    }

    .btn-ultra-primary {
        background: var(--primary-gradient) !important;
        border: none !important;
        border-radius: var(--border-radius) !important;
        padding: 14px 28px !important;
        font-weight: 600 !important;
        transition: var(--transition) !important;
        color: #fff !important;
        box-shadow: 0 5px 15px rgba(67, 97, 238, 0.35) !important;
        text-transform: uppercase !important;
        letter-spacing: 0.5px !important;
        font-size: 0.9rem !important;
    }

    .btn-ultra-primary:hover {
        transform: translateY(-3px) !important;
        box-shadow: 0 8px 25px rgba(67, 97, 238, 0.5) !important;
    }

    .btn-ultra-secondary {
        background: #ffffff !important;
        border: 1px solid #e2e8f0 !important;
        border-radius: var(--border-radius) !important;
        padding: 14px 28px !important;
        font-weight: 600 !important;
        transition: var(--transition) !important;
        color: var(--medium-text) !important;
        box-shadow: var(--shadow-sm) !important;
        text-transform: uppercase !important;
        letter-spacing: 0.5px !important;
        font-size: 0.9rem !important;
    }

    .btn-ultra-secondary:hover {
        background: #f8fafc !important;
        transform: translateY(-3px) !important;
        box-shadow: var(--shadow-md) !important;
        color: var(--primary-color) !important;
    }

    .form-section {
        background: #ffffff;
        border-radius: var(--border-radius);
        padding: 25px;
        margin-bottom: 25px;
        box-shadow: var(--shadow-sm);
        border-left: 5px solid var(--primary-color);
        transition: var(--transition);
    }

    .form-section:hover {
        box-shadow: var(--shadow-md);
    }

    .section-title {
        font-size: 1.25rem;
        font-weight: 700;
        margin-bottom: 20px;
        color: var(--dark-text);
        padding-bottom: 10px;
        border-bottom: 1px solid #e2e8f0;
        display: flex;
        align-items: center;
    }

    .section-title i {
        margin-right: 10px;
        color: var(--primary-color);
        font-size: 1.4rem;
    }

    .ultra-modern-table {
        border-radius: var(--border-radius) !important;
        overflow: hidden !important;
        box-shadow: var(--shadow-sm) !important;
        border: none !important;
    }

    .ultra-modern-table thead tr {
        background: var(--primary-gradient) !important;
        color: #fff !important;
    }

    .ultra-modern-table thead th {
        padding: 16px !important;
        font-weight: 600 !important;
        border: none !important;
        font-size: 0.9rem !important;
        text-transform: uppercase !important;
        letter-spacing: 0.5px !important;
    }

    .ultra-modern-table tbody td {
        padding: 16px !important;
        border-color: #f1f5f9 !important;
        vertical-align: middle !important;
    }

    .ultra-modern-table tbody tr {
        transition: var(--transition) !important;
    }

    .ultra-modern-table tbody tr:hover {
        background-color: #f8fafc !important;
    }

    .ultra-modern-table tbody tr:nth-child(even) {
        background-color: #f9fafb !important;
    }

    /* Last examination panel styling */
    #details-table2 {
        background: #f8fafc;
        border-radius: var(--border-radius);
        padding: 25px;
        margin-bottom: 30px;
        box-shadow: var(--shadow-sm);
        border-left: 5px solid var(--secondary-color);
        transition: var(--transition);
    }

    #details-table2:hover {
        box-shadow: var(--shadow-md);
    }

    .info-box {
        background: #ffffff;
        border-radius: var(--border-radius);
        padding: 20px;
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
        height: 100%;
        display: flex;
        align-items: center;
        border-left: 3px solid var(--primary-color);
    }

    .info-box:hover {
        box-shadow: var(--shadow-md);
        transform: translateY(-2px);
    }

    .info-box i {
        font-size: 2rem;
        color: var(--primary-color);
        margin-right: 15px;
    }

    .info-content {
        flex: 1;
    }

    .info-label {
        font-size: 0.85rem;
        color: var(--light-text);
        margin-bottom: 5px;
    }

    .info-value {
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--dark-text);
    }

    .notes-box {
        background: #ffffff;
        border-radius: var(--border-radius);
        padding: 20px;
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
        border-left: 3px solid var(--secondary-color);
    }

    .notes-box:hover {
        box-shadow: var(--shadow-md);
    }

    /* Input group styling */
    .input-group {
        position: relative;
        margin-bottom: 20px;
    }

    /* Table responsive wrapper styling */
    .table-responsive-wrapper {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border-radius: var(--border-radius);
        box-shadow: var(--shadow-sm);
        margin-bottom: 20px;
        position: relative;
    }

    .table-responsive-wrapper:after {
        content: "";
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        width: 5px;
        background: linear-gradient(to right, rgba(255,255,255,0), rgba(67, 97, 238, 0.15));
        pointer-events: none;
        opacity: 0;
        transition: opacity 0.3s ease;
    }

    .table-responsive-wrapper.has-scroll:after {
        opacity: 1;
    }

    .table-responsive-wrapper::-webkit-scrollbar {
        height: 8px;
    }

    .table-responsive-wrapper::-webkit-scrollbar-thumb {
        background: var(--primary-color);
        border-radius: 10px;
    }

    .table-responsive-wrapper::-webkit-scrollbar-track {
        background: #f0f2f5;
        border-radius: 10px;
    }

    /* Table form control improvements */
    .ultra-modern-table select.form-control,
    .ultra-modern-table input.form-control {
        min-width: 120px;
        font-size: 0.9rem !important;
    }

    .ultra-modern-table td {
        vertical-align: middle !important;
    }

    /* Responsive table adjustments */
    @media (max-width: 768px) {
        .ultra-modern-table thead th {
            white-space: nowrap;
            padding: 12px !important;
            font-size: 0.8rem !important;
        }

        .ultra-modern-table tbody td {
            padding: 12px !important;
        }

        .ultra-modern-table select.form-control,
        .ultra-modern-table input.form-control {
            min-width: 110px;
            font-size: 0.85rem !important;
            padding: 8px 12px !important;
        }
    }

    @media (max-width: 576px) {
        .ultra-modern-table select.form-control,
        .ultra-modern-table input.form-control {
            min-width: 90px;
            font-size: 0.8rem !important;
            padding: 6px 8px !important;
        }
    }

    /* Responsive improvements */
    @media (max-width: 992px) {
        .ultra-modern-card .card-body {
            padding: 25px !important;
        }

        .form-section {
            padding: 20px;
        }
    }

    @media (max-width: 768px) {
        .full-width-container {
            padding: 0 15px;
        }

        .ultra-modern-card .card-body {
            padding: 20px !important;
        }

        .btn-ultra-primary, .btn-ultra-secondary {
            padding: 12px 20px !important;
        }
    }

    /* Animation */
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .animate-fade-in {
        animation: fadeIn 0.5s ease forwards;
    }
</style>

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="full-width-container animate-fade-in">
            <div class="ultra-modern-card">
                <div class="card-header">
                    <h3 class="fw-bolder m-0"><?php echo e(__('translations.examinations-create')); ?></h3>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.receptions.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <!-- Basic Information Section -->
                        <div class="form-section">
                            <h4 class="section-title">
                                <i class="fas fa-info-circle p-2" style="font-size: 1.5rem;"></i>
                                <?php echo e(__('translations.Basic Information')); ?>

                            </h4>
                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label class="form-label">
                                        <i class="fas fa-hashtag p-2" style="font-size: 1rem;"></i>
                                        <?php echo e(__('translations.Examination Code')); ?>

                                        <span class="text-danger ms-1">*</span>
                                    </label>
                                    <input type="text" class="form-control" name="code" value="<?php echo e($examination_code); ?>" readonly />
                                    <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="fv-plugins-message-container invalid-feedback">
                                            <strong><?php echo e($message); ?></strong>
                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <!-- Client Selection Section -->
                                <div class="col-md-6 mb-4">
                                    <label class="form-label">
                                        <i class="fas fa-user p-2" style="font-size: 1rem;"></i>
                                        <?php echo e(__('translations.Client name')); ?>

                                        <span class="text-danger ms-1">*</span>
                                    </label>
                                    <div class="d-flex">
                                        <select id="client-select" class="form-control" data-control="select2" name="client_id" required>
                                            <option value="" disabled selected><?php echo e(__('translations.select_client')); ?></option>
                                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($client->id); ?>">
                                                    <?php echo e($client->first_name . ' ' . $client->last_name . ' - ' . $client->phone); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <a href="<?php echo e(route('admin.clients.create')); ?>" class="btn btn-ultra-primary ms-3">
                                            <i class="fas fa-plus-circle me-1"></i> <?php echo e(__('translations.create_client')); ?>

                                        </a>
                                    </div>
                                </div>

                                <div class="col-md-6 mb-4">
                                    <label class="form-label">
                                        <i class="fas fa-glasses p-2" style="font-size: 1rem;"></i>
                                        <?php echo e(__('translations.type')); ?>

                                        <span class="text-danger ms-1">*</span>
                                    </label>
                                    <select class="form-control" data-control="select2" name="type" id="type" required>
                                        <option value="" disabled> <?php echo e(__('translations.select_type')); ?></option>
                                        <option value="نظارات" selected>نظارات</option>
                                        <option value="عدسات">عدسات</option>
                                    </select>
                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="fv-plugins-message-container invalid-feedback">
                                            <strong><?php echo e($message); ?></strong>
                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-6 mb-4">
                                    <label class="form-label">
                                        <i class="fas fa-tag p-2" style="font-size: 1rem;"></i>
                                        <?php echo e(__('translations.special_type')); ?>

                                        <span class="text-danger ms-1">*</span>
                                    </label>
                                    <select class="form-control" data-control="select2" name="special" id="special_type" required>
                                        <option value="" disabled><?php echo e(__('translations.select_type')); ?></option>
                                        <?php if(is_countable($specials) && count($specials) > 0): ?>
                                            <?php $__currentLoopData = $specials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $special): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($special); ?>" <?php echo e($special === 'عادي' ? 'selected' : ''); ?>><?php echo e($special); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <option value=""><?php echo e(__('translations.no_types')); ?></option>
                                        <?php endif; ?>
                                    </select>
                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="fv-plugins-message-container invalid-feedback">
                                            <strong><?php echo e($message); ?></strong>
                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <!-- Notes & Attachments Section -->
                        <div class="form-section">
                            <h4 class="section-title">
                                <i class="fas fa-clipboard p-2" style="font-size: 1rem;"></i>
                                <?php echo e(__('translations.Notes & Attachments')); ?>

                            </h4>
                            <div class="row">
                                <div class="col-md-12 mb-4">
                                    <label class="form-label">
                                        <i class="fas fa-comment p-2" style="font-size: 1rem;"></i>
                                        <?php echo e(__('translations.Note')); ?>

                                    </label>
                                    <textarea class="form-control" name="notes" rows="4" placeholder="Enter any important notes here..."></textarea>
                                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="fv-plugins-message-container invalid-feedback">
                                            <strong><?php echo e($message); ?></strong>
                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-lg-12 mb-4">
                                    <label class="form-label">
                                        <i class="fas fa-paperclip p-2" style="font-size: 1rem;"></i>
                                        <?php echo e(__('translations.attachment')); ?>

                                    </label>
                                    <input type="file" class="form-control" name="file">
                                    <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger text-bold"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <input type="text" class="form-control" name="status" value="في انتظار التاكيد" hidden />
                            </div>
                        </div>

                        <!-- Last Examination Details -->
                        <div id="details-table2" style="display: none;" class="animate-fade-in">
                            <h4 class="section-title">
                                <i class="fas fa-history p-2" style="font-size: 1rem;"></i>
                                <?php echo e(__('translations.Last Examination')); ?>

                            </h4>

                            <div class="row mb-4">
                                <div class="col-md-4 mb-3">
                                    <div class="info-box">
                                        <i class="fas fa-calendar-alt p-2" style="font-size: 1rem;"></i>
                                        <div class="info-content">
                                            <div class="info-label"><?php echo e(__('translations.examination-created_at')); ?></div>
                                            <div class="info-value" id="examination-created_at">N/A</div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <div class="info-box">
                                        <i class="fas fa-user-clock p-2" style="font-size: 1rem;"></i>
                                        <div class="info-content">
                                            <div class="info-label"><?php echo e(__('translations.Client Age')); ?></div>
                                            <div class="info-value" id="client-age">N/A</div>
                                        </div>
                                    </div>
                                </div>

                                <div id="download-file-section" class="col-md-4 mb-3" style="display: none;">
                                    <div class="info-box">
                                        <i class="fas fa-file-download p-2" style="font-size: 1rem;"></i>
                                        <div class="info-content">
                                            <div class="info-label"><?php echo e(__('translations.Attachment')); ?></div>
                                            <a id="download-file-button" href="#" class="info-value text-hover-primary">
                                                <?php echo e(__('translations.Download File')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-4">
                                <h5 class="mb-3">
                                    <i class="fas fa-clipboard-list p-2" style="font-size: 1rem;"></i>
                                    <?php echo e(__('translations.Examination Notes')); ?>

                                </h5>
                                <div class="notes-box" id="examination-notes">N/A</div>
                            </div>

                            <div class="table-responsive-wrapper">
                                <table dir="ltr" class="table table-bordered table-hover align-middle ultra-modern-table">
                                    <thead>
                                        <tr class="fw-bold fs-7 text-uppercase">
                                            <th><?php echo e(__('translations.Type')); ?></th>
                                            <th><?php echo e(__('translations.Sph')); ?></th>
                                            <th><?php echo e(__('translations.Cyl')); ?></th>
                                            <th><?php echo e(__('translations.Axis')); ?></th>
                                            <th><?php echo e(__('translations.A.D.D')); ?></th>
                                            <th><?php echo e(__('translations.I.P.D')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="details-table-body2" class="text-gray-800 fw-semibold">
                                        <!-- Data dynamically inserted here -->
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- تفاصيل الفحص - Examination Details -->
                        <div class="form-section">
                            <h4 class="section-title">
                                <i class="fas fa-clipboard-check p-2" style="font-size: 1rem;"></i>
                                <?php echo e(__('translations.Examination Details')); ?>

                            </h4>
                            <div class="card-body p-0" dir="ltr">
                                <div class="table-responsive-wrapper">
                                    <table class="table align-middle ultra-modern-table">
                                        <thead>
                                            <tr class="fw-bold fs-7 text-uppercase">
                                                <th>Type</th>
                                                <th>Sph</th>
                                                <th>Cyl</th>
                                                <th>Axis</th>
                                                <th>A.D.D</th>
                                                <th>I.P.D</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-gray-800 fw-semibold">
                                            <tr id="rt-row">
                                                <td>Rt</td>
                                                <td>
                                                    <select class="form-control" name="rt_sph">
                                                        <option value="0">0.00</option>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="-<?php echo e(number_format($i, 2)); ?>">-<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="+<?php echo e(number_format($i, 2)); ?>">+<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </td>
                                                <td>
                                                    <select class="form-control" name="rt_cyl">
                                                        <option value="0">0.00</option>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="-<?php echo e(number_format($i, 2)); ?>">-<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="+<?php echo e(number_format($i, 2)); ?>">+<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </td>
                                                <td><input type="text" class="form-control" name="rt_axis" placeholder="Axis"></td>
                                                <td>
                                                    <select class="form-control" name="rt_lpd">
                                                        <?php for($i = 0; $i <= 10; $i += 0.25): ?>
                                                            <option value="<?php echo e(number_format($i, 2)); ?>">+<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </td>
                                                <td><input type="text" class="form-control" name="rt_add" placeholder="I.P.D"></td>
                                            </tr>
                                            <tr id="lt-row">
                                                <td>Lt</td>
                                                <td>
                                                    <select class="form-control" name="lt_sph">
                                                        <option value="0">0.00</option>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="-<?php echo e(number_format($i, 2)); ?>">-<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="+<?php echo e(number_format($i, 2)); ?>">+<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </td>
                                                <td>
                                                    <select class="form-control" name="lt_cyl">
                                                        <option value="0">0.00</option>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="-<?php echo e(number_format($i, 2)); ?>">-<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                        <?php for($i = 0.25; $i <= 20; $i += 0.25): ?>
                                                            <option value="+<?php echo e(number_format($i, 2)); ?>">+<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </td>
                                                <td><input type="text" class="form-control" name="lt_axis" placeholder="Axis"></td>
                                                <td>
                                                    <select class="form-control" name="lt_lpd">
                                                        <?php for($i = 0; $i <= 10; $i += 0.25): ?>
                                                            <option value="<?php echo e(number_format($i, 2)); ?>">+<?php echo e(number_format($i, 2)); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </td>
                                                <td><input type="text" class="form-control" name="lt_add" placeholder="I.P.D"></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex pt-4 justify-content-between align-items-center">
                            <a href="<?php echo e(route('admin.receptions.index')); ?>" class="btn btn-ultra-secondary">
                                <i class="fa fa-arrow-left me-2" aria-hidden="true"></i> <?php echo e(__('translations.back')); ?>

                            </a>
                            <div class="d-flex gap-3">
                                <button type="submit" name="button_type" value="save" class="btn btn-ultra-primary">
                                    <i class="fa fa-check me-2" aria-hidden="true"></i> <?php echo e(__('translations.create')); ?>

                                </button>
                                <button type="submit" name="button_type" value="last_examination" class="btn btn-ultra-primary">
                                    <i class="fa fa-history me-2" aria-hidden="true"></i> اضافة قياسات اخر فحص
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<script>
    $(document).ready(function() {
        // Add fade-in animation to major elements
        setTimeout(function() {
            $('.form-section').addClass('animate-fade-in');
        }, 100);

        // Check if table containers are scrollable
        function checkTableScroll() {
            $('.table-responsive-wrapper').each(function() {
                if(this.scrollWidth > this.clientWidth) {
                    $(this).addClass('has-scroll');
                } else {
                    $(this).removeClass('has-scroll');
                }
            });
        }

        // Run on page load
        checkTableScroll();

        // Run on window resize
        $(window).on('resize', function() {
            checkTableScroll();
        });

        $('#client-select').on('change', function() {
            var clientId = $(this).val();
            if (clientId) {
                fetchLastExamination(clientId);
                // Check scrollable tables after data is loaded
                setTimeout(checkTableScroll, 500);
            }
        });

        function fetchLastExamination(clientId) {
            $.ajax({
                url: '/admin/examination/last',
                method: 'GET',
                data: {
                    client_id: clientId
                },
                dataType: 'json',
                success: function(response) {
                    $('#details-table-body2').empty();
                    $('#download-file-section').hide(); // Hide the download section initially

                    // Display examination notes
                    if (response.client && response.client.age) {
                        $('#client-age').text(response.client.age);
                    } else {
                        $('#client-age').text('N/A');
                    }

                    // Display examination notes
                    if (response.examination && response.examination.notes) {
                        $('#examination-notes').text(response.examination.notes);
                    } else {
                        $('#examination-notes').text('N/A');
                    }

                    // Display the examination creation date
                    if (response.examination && response.examination.created_at) {
                        const createdAt = new Date(response.examination.created_at);
                        const formattedDate =
                            `${String(createdAt.getDate()).padStart(2, '0')}/${String(createdAt.getMonth() + 1).padStart(2, '0')}/${createdAt.getFullYear()}`;
                        $('#examination-created_at').text(formattedDate);
                    } else {
                        $('#examination-created_at').text('N/A');
                    }

                    // Show download file button if a file exists
                    if (response.examination && response.examination.file) {
                        const filePath = '<?php echo e(asset('uploads/')); ?>/' + response.examination.file;
                        $('#download-file-section').show();
                        $('#download-file-button').attr('href', filePath); // Set the download file URL
                    }

                    // Populate the examination details table
                    if (response.details && response.details.length > 0) {
                        response.details.forEach((entry) => {
                            const row = `
                        <tr>
                            <td>${entry.type || 'N/A'}</td>
                            <td>${entry.sph || 'N/A'}</td>
                            <td>${entry.cyl || 'N/A'}</td>
                            <td>${entry.axis || 'N/A'}</td>
                            <td>${entry.lpd || 'N/A'}</td>
                            <td>${entry.add || 'N/A'}</td>
                        </tr>`;
                            $('#details-table-body2').append(row);
                        });
                        $('#details-table2').fadeIn(500);
                    }
                },
                error: function(xhr) {
                    const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr
                        .responseJSON.message : 'An error occurred';
                    alert(errorMessage);
                    $('#details-table2').fadeOut(500);
                },
            });
        }

        function calculateAge(birthDate) {
            const today = new Date();
            let age = today.getFullYear() - birthDate.getFullYear();
            const monthDiff = today.getMonth() - birthDate.getMonth();
            if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }
            return age;
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/receptions/create.blade.php ENDPATH**/ ?>