<div id="kt_header" class="header align-items-stretch shadow-sm">
  <div class="header-brand">
    <a href="<?php echo e(route('admin.index')); ?>">
        <?php if($setting->logo): ?>
            <img alt="Logo" src="<?php echo e(asset('uploads/'.$setting->logo)); ?>" class="logo-img d-block" />
        <?php else: ?>
            <img alt="Logo" src="<?php echo e(asset('logo.png')); ?>" class="logo-img d-block" />
        <?php endif; ?>
    </a>

    <style>
        .logo-img {
            width: 45px!important;
            transition: all 0.3s ease;
        }
        @media (min-width: 768px) {
            .logo-img {
                width: 70px!important;
            }
        }

        .btn {
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.08);
            padding: 0.45rem 0.9rem;
            font-size: 0.85rem;
            border: none;
            letter-spacing: 0.3px;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            filter: brightness(1.05);
        }
        .action-buttons .btn {
            margin-right: 10px;
            display: flex;
            align-items: center;
            gap: 6px;
            position: relative;
            overflow: hidden;
            z-index: 1;
        }
        .action-buttons .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, rgba(255,255,255,0.1), rgba(255,255,255,0.3), rgba(255,255,255,0.1));
            transition: all 0.8s ease;
            z-index: -1;
        }
        .action-buttons .btn:hover::before {
            left: 100%;
        }
        .action-buttons .btn i {
            font-size: 0.9rem;
        }
        .btn-light-info {
            background: #0ea5e9 !important;
            color: white !important;
        }
        .btn-light-primary {
            background: #6366f1 !important;
            color: white !important;
        }
        .btn-light-success {
            background: #10b981 !important;
            color: white !important;
        }
        .btn-light-warning {
            background: #f59e0b !important;
            color: white !important;
        }
        .page-title h1 {
            font-size: 1.5rem !important;
            letter-spacing: 0.5px;
        }
        .breadcrumb {
            font-size: 0.8rem !important;
        }
    </style>

    <div id="kt_aside_toggle" class="btn btn-icon w-auto px-0 btn-active-color-primary aside-minimize" data-kt-toggle="true" data-kt-toggle-state="active" data-kt-toggle-target="body" data-kt-toggle-name="aside-minimize">
      <span class="svg-icon svg-icon-1 me-n1 minimize-default">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
          <rect opacity="0.3" x="8.5" y="11" width="12" height="2" rx="1" fill="black" />
          <path d="M10.3687 11.6927L12.1244 10.2297C12.5946 9.83785 12.6268 9.12683 12.194 8.69401C11.8043 8.3043 11.1784 8.28591 10.7664 8.65206L7.84084 11.2526C7.39332 11.6504 7.39332 12.3496 7.84084 12.7474L10.7664 15.3479C11.1784 15.7141 11.8043 15.6957 12.194 15.306C12.6268 14.8732 12.5946 14.1621 12.1244 13.7703L10.3687 12.3073C10.1768 12.1474 10.1768 11.8526 10.3687 11.6927Z" fill="black" />
          <path opacity="0.5" d="M16 5V6C16 6.55228 15.5523 7 15 7C14.4477 7 14 6.55228 14 6C14 5.44772 13.5523 5 13 5H6C5.44771 5 5 5.44772 5 6V18C5 18.5523 5.44771 19 6 19H13C13.5523 19 14 18.5523 14 18C14 17.4477 14.4477 17 15 17C15.5523 17 16 17.4477 16 18V19C16 20.1046 15.1046 21 14 21H5C3.89543 21 3 20.1046 3 19V5C3 3.89543 3.89543 3 5 3H14C15.1046 3 16 3.89543 16 5Z" fill="black" />
        </svg>
      </span>

      <span class="svg-icon svg-icon-1 minimize-active">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
          <rect opacity="0.3" width="12" height="2" rx="1" transform="matrix(-1 0 0 1 15.5 11)" fill="black" />
          <path d="M13.6313 11.6927L11.8756 10.2297C11.4054 9.83785 11.3732 9.12683 11.806 8.69401C12.1957 8.3043 12.8216 8.28591 13.2336 8.65206L16.1592 11.2526C16.6067 11.6504 16.6067 12.3496 16.1592 12.7474L13.2336 15.3479C12.8216 15.7141 12.1957 15.6957 11.806 15.306C11.3732 14.8732 11.4054 14.1621 11.8756 13.7703L13.6313 12.3073C13.8232 12.1474 13.8232 11.8526 13.6313 11.6927Z" fill="black" />
          <path d="M8 5V6C8 6.55228 8.44772 7 9 7C9.55228 7 10 6.55228 10 6C10 5.44772 10.4477 5 11 5H18C18.5523 5 19 5.44772 19 6V18C19 18.5523 18.5523 19 18 19H11C10.4477 19 10 18.5523 10 18C10 17.4477 9.55228 17 9 17C8.44772 17 8 17.4477 8 18V19C8 20.1046 8.89543 21 10 21H19C20.1046 21 21 20.1046 21 19V5C21 3.89543 20.1046 3 19 3H10C8.89543 3 8 3.89543 8 5Z" fill="#C4C4C4" />
        </svg>
      </span>
    </div>

    <div class="d-flex align-items-center d-lg-none ms-n3 me-1" title="Show aside menu">
      <div class="btn btn-icon btn-active-color-primary w-30px h-30px" id="kt_aside_mobile_toggle">
        <span class="svg-icon svg-icon-1">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
            <path d="M21 7H3C2.4 7 2 6.6 2 6V4C2 3.4 2.4 3 3 3H21C21.6 3 22 3.4 22 4V6C22 6.6 21.6 7 21 7Z" fill="black" />
            <path opacity="0.3" d="M21 14H3C2.4 14 2 13.6 2 13V11C2 10.4 2.4 10 3 10H21C21.6 10 22 10.4 22 11V13C22 13.6 21.6 14 21 14ZM22 20V18C22 17.4 21.6 17 21 17H3C2.4 17 2 17.4 2 18V20C2 20.6 2.4 21 3 21H21C21.6 21 22 20.6 22 20Z" fill="black" />
          </svg>
        </span>
      </div>
    </div>
  </div>

  <div class="toolbar">
    <div class="container-fluid py-3 py-lg-0 d-none d-md-flex align-items-center justify-content-between">
      <div class="page-title d-flex flex-column me-5">
        <h1 class="d-flex flex-column fw-bolder fs-3 mb-0" style="color:var(--header-text-color) !important; text-shadow: 1px 1px 2px rgba(0,0,0,0.2);"><?php echo e(__('translations.dashboard')); ?></h1>
        <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 pt-1">
          <li class="breadcrumb-item " style="color: var(--header-text-color) !important; opacity: 0.8;"><?php echo $__env->yieldContent('sub-title'); ?> - <?php echo $__env->yieldContent('title'); ?></li>
        </ul>
      </div>

      <div class="d-flex align-items-center overflow-auto pt-lg-0">
        <div class="d-flex align-items-center action-buttons">
          <div class="d-flex">
              
              <div class="app-navbar-item ms-1 ms-lg-2">
                <a href="<?php echo e(route('admin.clients.create')); ?>" class="btn btn-light-info">
                  <i class="fas fa-user-plus"></i>
                  <?php echo e(__('translations.create-client')); ?>

                </a>
              </div>
              
              <div class="app-navbar-item ms-1 ms-lg-2">
                <a href="<?php echo e(route('admin.receptions.create')); ?>" class="btn btn-light-primary">
                  <i class="fas fa-plus"></i>
                  <?php echo e(__('translations.create-reception')); ?>

                </a>
              </div>
              
              <div class="app-navbar-item ms-1 ms-lg-2">
                <a href="<?php echo e(route('admin.invoices.create')); ?>" class="btn btn-light-success">
                  <i class="fas fa-file-invoice"></i>
                  <?php echo e(__('translations.create-invoice')); ?>

                </a>
              </div>
              
              <div class="app-navbar-item ms-1 ms-lg-2">
                <a href="<?php echo e(route('admin.expenses.create')); ?>" class="btn btn-danger">
                  <i class="fas fa-money-bill-wave"></i>
                  <?php echo e(__('translations.create-expense')); ?>

                </a>
              </div>
            <div class="app-navbar-item ms-1 ms-lg-3" id="kt_header_user_menu_toggle">
                <div class="cursor-pointer symbol symbol-35px symbol-md-40px" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-start">
                  <img src="<?php echo e(auth()->user()->picture_url); ?>" alt="user" style="width: 40px !important; height: 40px !important; border-radius: 50%; border: 2px solid #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                </div>
                <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-800 menu-state-bg menu-state-color fw-semibold py-4 fs-6 w-275px" data-kt-menu="true">
                  <div class="menu-item px-3">
                    <div class="menu-content d-flex align-items-center px-3">
                      <div class="symbol symbol-50px me-5">
                        <img src="<?php echo e(auth()->user()->picture_url); ?>" alt="user" style="border-radius: 50%; border: 2px solid #f1f1f1;">
                      </div>

                      <div class="d-flex flex-column">
                        <div class="fw-bold d-flex align-items-center fs-5"><?php echo e(auth()->user()->name); ?></div>
                        <a href="#" class="fw-semibold text-muted text-hover-primary fs-7"><?php $__currentLoopData = auth()->user()->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($role->display_name); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></a>
                      </div>
                    </div>
                  </div>
                  
                  <div class="menu-item px-5">

                  <form action="<?php echo e(route('admin.setLocale')); ?>" method="post">
                      <?php echo csrf_field(); ?>
                      <div class="form-group">
                        <select class="form-control select2" name="locale" onchange="this.form.submit()" >
                          <option value="ar" <?php echo e(app()->getLocale() == 'ar' ? 'selected' : ''); ?>><?php echo e(__('translations.arabic')); ?></option>
                          <option value="en" <?php echo e(app()->getLocale() == 'en' ? 'selected' : ''); ?>><?php echo e(__('translations.english')); ?></option>
                        </select>
                      </div>
                    </form>
                  </div>
                  
                  <div class="menu-item px-5">
                    <a href="<?php echo e(route('admin.profile.index')); ?>" class="menu-link px-5"><?php echo e(__('translations.edit-profile')); ?></a>
                  </div>
                  
                  <div class="menu-item px-5">
                      <a href="#" class="menu-link px-5" onclick="event.preventDefault();
                          if(confirm('هل أنت متأكد من عملية الحذف ؟')) {
                              document.getElementById('logout-form').submit();
                          }">
                          <?php echo e(__('translations.logout')); ?>

                      </a>
                      <!-- The logout form -->
                      <form id="logout-form" action="<?php echo e(route('admin.logout')); ?>" method="post" style="display: none;">
                          <?php echo csrf_field(); ?>
                          <?php echo method_field('POST'); ?>  <!-- Add the method POST explicitly -->
                      </form>
                  </div>

                </div>
              </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/layouts/header.blade.php ENDPATH**/ ?>