<?php
$themeSettings = \App\Models\ThemeSettings::first() ?? new \App\Models\ThemeSettings();
?>

<style id="dynamic-theme-styles">
    :root {
        --sidebar-bg-color: <?php echo e($themeSettings->sidebar_bg_color); ?>;
        --sidebar-text-color: <?php echo e($themeSettings->sidebar_text_color); ?>;
        --header-bg-color: <?php echo e($themeSettings->header_bg_color); ?>;
        --header-text-color: <?php echo e($themeSettings->header_text_color); ?>;
        --primary-color: <?php echo e($themeSettings->primary_color); ?>;
        --secondary-color: <?php echo e($themeSettings->secondary_color); ?>;
        --font-family: <?php echo e($themeSettings->font_family); ?>;
        --base-font-size: <?php echo e($themeSettings->base_font_size); ?>;
        --heading-font-size: <?php echo e($themeSettings->heading_font_size); ?>;
        --menu-font-size: <?php echo e($themeSettings->menu_font_size); ?>;
        --text-color: <?php echo e($themeSettings->text_color); ?>;
        --link-color: <?php echo e($themeSettings->link_color); ?>;
    }

    /* Apply base font settings */
    body {
        font-family: var(--font-family);
        font-size: var(--base-font-size);
        color: var(--text-color);
    }

    /* Apply heading styles */
    h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: var(--font-family);
        color: var(--text-color);
    }

    h1, .h1 { font-size: calc(var(--heading-font-size) * 1.5); }
    h2, .h2 { font-size: calc(var(--heading-font-size) * 1.3); }
    h3, .h3 { font-size: var(--heading-font-size); }

    /* Link styles */
    a:not(.btn) {
        color: var(--link-color);
    }
    a:not(.btn):hover {
        color: <?php echo e($themeSettings->primary_color); ?>;
    }

    /* Sidebar styling */
    .aside {
        background-color: var(--sidebar-bg-color) !important;
    }
    .aside .aside-menu .menu .menu-item .menu-link {
        font-size: var(--menu-font-size);
        color: var(--sidebar-text-color);
    }
    .aside .aside-menu .menu .menu-item .menu-link.active {
        background-color: rgba(255, 255, 255, 0.1);
        color: var(--primary-color);
    }
    .aside .aside-menu .menu .menu-item .menu-link:hover:not(.active) {
        background-color: rgba(255, 255, 255, 0.05);
    }
    .aside-dark .aside-logo .menu-item .menu-link .menu-title {
        color: var(--sidebar-text-color);
    }
    .aside-dark .menu-title, .aside-dark .menu-icon, .aside-dark .menu-arrow {
        color: var(--sidebar-text-color);
    }

    /* Header styling */
    .header {
        background-color: var(--header-bg-color);
    }
    .header .page-title, .header .menu-title, .header .menu-text {
        color: var(--header-text-color);
    }
    .header-menu .menu-title {
        color: var(--header-text-color);
    }
    .topbar .topbar-item {
        color: var(--header-text-color);
    }

    /* Primary color elements */
    .btn-primary, .btn-check:checked + .btn.btn-active-light-primary {
        background-color: var(--primary-color) !important;
        border-color: var(--primary-color) !important;
    }
    .btn-primary:hover, .btn-check:checked + .btn.btn-active-light-primary:hover {
        background-color: <?php echo e($themeSettings->primary_color); ?> !important;
        border-color: <?php echo e($themeSettings->primary_color); ?> !important;
    }
    .text-primary, .text-hover-primary:hover {
        color: var(--primary-color) !important;
    }
    .border-primary {
        border-color: var(--primary-color) !important;
    }

    .card .card-header .card-title, .card .card-header .card-title .card-label{
        color: var(--sidebar-text-color) !important;
    }

    /* Secondary color elements */
    .btn-secondary {
        background-color: var(--secondary-color) !important;
        border-color: var(--secondary-color) !important;
    }
    .btn-secondary:hover {
        background-color: <?php echo e($themeSettings->secondary_color); ?> !important;
        border-color: <?php echo e($themeSettings->secondary_color); ?> !important;
    }
    .text-secondary {
        color: var(--secondary-color) !important;
    }
    .border-secondary {
        border-color: var(--secondary-color) !important;
    }
    .bg-secondary, .bg-light-secondary {
        background-color: <?php echo e($themeSettings->secondary_color); ?> !important;
    }

    /* Dark mode styles */
    <?php if($themeSettings->is_dark_mode): ?>
    body {
        background-color: #000;
        color: #ffffff;
    }
    h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {
        color: #ffffff;
    }
    .card {
        background-color: #2b2b40;
        border-color: #3a3a5a;
    }
    .card-header {
        background-color: #323248;
        border-color: #3a3a5a;
    }
    .form-control, .form-select {
        background-color: #323248;
        border-color: #3a3a5a;
        color: #ffffff;
    }

    .card.card-docs {
        background-color: #000;
    }
    .table {
        color: #ffffff;
        border-color: #3a3a5a;
        background-color: #000;
    }
    .table thead th {
        background-color: #323248;
        color: #ffffff;
    }
    .table-row-dashed tbody tr {
        border-bottom-color: #3a3a5a;
    }
    .table td, .table th {
        color: #ffffff;
    }
    .card-header {
            border-radius: 12px 12px 0 0 !important;
            background-color:var(--sidebar-bg-color) !important;
        }
    <?php endif; ?>
</style>
<?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/layouts/dynamic-styles.blade.php ENDPATH**/ ?>