<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.return-invoices-list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.return-invoices')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2 shadow-sm border-0 rounded-lg">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center py-4">
                                <div class="card-title m-0">
                                    <h3 class="fw-bold fs-4 m-0 text-primary"><?php echo e(__('translations.return-invoices-list')); ?></h3>
                                </div>
                            </div>
                            <div class="card-body p-4">
                                <div class="d-flex align-items-center justify-content-between position-relative mb-4">
                                    <div class="position-relative w-250px">
                                        <span class="svg-icon svg-icon-1 position-absolute ms-4 top-50 translate-middle-y text-gray-500">
                                            <svg width="18" height="18" viewBox="0 0 24 24">
                                                <path fill="currentColor"
                                                    d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                                            </svg>
                                        </span>
                                        <input type="text" data-kt-filter="search"
                                            class="form-control form-control-solid rounded-pill ps-14 shadow-sm border-0"
                                            placeholder="<?php echo e(__('translations.invoices-search')); ?>" />
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="text-gray-600 fs-7"><?php echo e(count($invoices)); ?> <?php echo e(__('translations.invoices')); ?></span>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table id="kt_datatable_example"
                                        class="table align-middle gs-0 gy-4 table-hover border-0">
                                        <thead>
                                            <tr class="text-gray-400 fw-bold fs-7 text-uppercase bg-light-primary rounded-top">
                                                <th class="ps-4 min-w-200px rounded-start"><?php echo e(__('translations.invoices-customer')); ?></th>
                                                <th class="min-w-100px text-center"><?php echo e(__('translations.invoices-total')); ?></th>
                                                <th class="min-w-100px text-center"><?php echo e(__('translations.invoices-payment-method')); ?></th>
                                                <th class="min-w-100px text-center"><?php echo e(__('translations.invoices-status')); ?></th>
                                                <th class="min-w-100px text-center"><?php echo e(__('translations.invoices-date')); ?></th>
                                                <th class="min-w-150px text-end pe-4 rounded-end"><?php echo e(__('translations.actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-gray-700 fw-semibold">
                                            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="border-bottom border-gray-100">
                                                    <td>
                                                        <div class="d-flex align-items-center ps-4">
                                                            <div class="symbol symbol-50px me-3 bg-light-primary rounded-circle shadow-sm">
                                                                <span class="symbol-label bg-light-primary text-primary fw-bold fs-5"><?php echo e(substr($invoice->client->first_name, 0, 1)); ?></span>
                                                            </div>
                                                            <div>
                                                                <div class="fw-bold fs-6 mb-0"><?php echo e($invoice->client->first_name); ?>

                                                                    <?php echo e($invoice->client->last_name); ?></div>
                                                                <div class="text-gray-500 fs-7"><?php echo e($invoice->number); ?></div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="text-center fw-bolder fs-6"><?php echo e(number_format($invoice->total_price, 0)); ?>

                                                        <span class="text-gray-500 fs-7"><?php echo e(__('translations.currency')); ?></span>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php if($invoice->payment_method_code == '011'): ?>
                                                            <span class="badge bg-light-info text-info px-3 py-2 fs-8 rounded-pill"><?php echo e(__('translations.cash')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge bg-light-danger text-danger px-3 py-2 fs-8 rounded-pill"><?php echo e(__('translations.credit')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php if($invoice->status == 'pending'): ?>
                                                            <span class="badge bg-light-warning text-warning px-3 py-2 fs-8 rounded-pill"><?php echo e(__('translations.' . $invoice->status)); ?></span>
                                                        <?php elseif($invoice->status == 'sending_to_invotek'): ?>
                                                            <span class="badge bg-light-success text-success px-3 py-2 fs-8 rounded-pill"><?php echo e(__('translations.' . $invoice->status)); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge bg-light-danger text-danger px-3 py-2 fs-8 rounded-pill"><?php echo e(__('translations.' . $invoice->status)); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="d-flex flex-column">
                                                            <span class="fw-bold"><?php echo e($invoice->created_at->format('d/m/Y')); ?></span>
                                                            <span class="text-gray-500 fs-7"><?php echo e($invoice->created_at->format('h:i A')); ?></span>
                                                        </div>
                                                    </td>
                                                    <td class="text-end pe-4">
                                                        <div class="dropdown">
                                                            <button class="btn btn-sm btn-icon btn-active-light-primary rounded-circle" type="button"
                                                                id="dropdownMenuButton" data-bs-toggle="dropdown"
                                                                aria-expanded="false">
                                                                <i class="bi bi-three-dots-vertical fs-5"></i>
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-end rounded shadow-sm border-0 py-3" aria-labelledby="dropdownMenuButton">
                                                                <?php if (app('laratrust')->hasPermission('invoices-show')) : ?>
                                                                    <a class="dropdown-item py-2 px-4"
                                                                        href="<?php echo e(route('admin.invoices.show', $invoice->id)); ?>">
                                                                        <i class="bi bi-eye me-2 text-primary"></i>
                                                                        <?php echo e(__('translations.show')); ?>

                                                                    </a>
                                                                <?php endif; // app('laratrust')->permission ?>
                                                                <?php if (app('laratrust')->hasPermission('invoices-edit')) : ?>
                                                                    <a class="dropdown-item py-2 px-4"
                                                                        href="<?php echo e(route('admin.invoices.edit', $invoice->id)); ?>">
                                                                        <i class="bi bi-pencil-square me-2 text-warning"></i>
                                                                        <?php echo e(__('translations.edit')); ?>

                                                                    </a>
                                                                <?php endif; // app('laratrust')->permission ?>
                                                                <?php if (app('laratrust')->hasPermission('invoices-delete')) : ?>
                                                                    <a class="dropdown-item py-2 px-4 text-danger" href="#"
                                                                        onclick="event.preventDefault();
                                    if(confirm('هل أنت متأكد من عملية الحذف ؟')) {
                                    document.getElementById('delete-form-<?php echo e($invoice->id); ?>').submit();
                                    }">
                                                                        <i class="bi bi-trash me-2"></i>
                                                                        <?php echo e(__('translations.delete')); ?>

                                                                    </a>
                                                                <?php endif; // app('laratrust')->permission ?>
                                                                <form id="delete-form-<?php echo e($invoice->id); ?>"
                                                                    action="<?php echo e(route('admin.invoices.destroy', $invoice->id)); ?>"
                                                                    method="post" style="display: none;">
                                                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/invoices/return-invoice-index.blade.php ENDPATH**/ ?>