<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.cache_settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.cache_management')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="post d-flex flex-column-fluid" id="kt_post">
        <div id="kt_content_container" class="container-fluid">
            <div class="card shadow-sm border-0 mb-5">
                <div class="card-header border-0" style="background: linear-gradient(135deg, #3a7bd5, #2196f3)">
                    <div class="card-title m-0">
                        <h3 class="fw-bold m-0 text-white"><?php echo e(__('translations.cache_management')); ?></h3>
                    </div>
                    <div class="card-toolbar">
                        <a href="<?php echo e(route('admin.settings.cache.clear-all')); ?>" class="btn btn-danger" onclick="return confirm('<?php echo e(__('translations.are_you_sure_clear_all_cache')); ?>');">
                            <i class="fas fa-trash-alt me-1"></i><?php echo e(__('translations.clear_all_cache')); ?>

                        </a>
                    </div>
                </div>
                <div class="card-body p-4">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong><?php echo e(session('success')); ?></strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <strong><?php echo e(session('error')); ?></strong>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="row g-4">
                        <!-- Application Cache -->
                        <div class="col-xl-6 col-lg-6 col-md-12">
                            <div class="card shadow-sm border rounded-4">
                                <div class="card-body p-4">
                                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-light-primary rounded-circle p-3 me-3">
                                                <i class="fas fa-database fa-2x text-primary"></i>
                                            </div>
                                            <div>
                                                <h4 class="mb-1"><?php echo e(__('translations.application_cache')); ?></h4>
                                                <p class="text-muted mb-0"><?php echo e(__('translations.current_size')); ?>: <span class="fw-bold"><?php echo e($cacheSize); ?></span></p>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('admin.settings.cache.clear-cache')); ?>" class="btn btn-primary mt-3 mt-md-0">
                                            <i class="fas fa-broom me-1"></i><?php echo e(__('translations.clear_cache')); ?>

                                        </a>
                                    </div>
                                    <div class="alert alert-light-primary mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <?php echo e(__('translations.application_cache_description')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- View Cache -->
                        <div class="col-xl-6 col-lg-6 col-md-12">
                            <div class="card shadow-sm border rounded-4">
                                <div class="card-body p-4">
                                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-light-info rounded-circle p-3 me-3">
                                                <i class="fas fa-file-code fa-2x text-info"></i>
                                            </div>
                                            <div>
                                                <h4 class="mb-1"><?php echo e(__('translations.view_cache')); ?></h4>
                                                <p class="text-muted mb-0"><?php echo e(__('translations.current_size')); ?>: <span class="fw-bold"><?php echo e($viewSize); ?></span></p>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('admin.settings.cache.clear-view')); ?>" class="btn btn-info mt-3 mt-md-0">
                                            <i class="fas fa-broom me-1"></i><?php echo e(__('translations.clear_view_cache')); ?>

                                        </a>
                                    </div>
                                    <div class="alert alert-light-info mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <?php echo e(__('translations.view_cache_description')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Config Cache -->
                        <div class="col-xl-6 col-lg-6 col-md-12">
                            <div class="card shadow-sm border rounded-4">
                                <div class="card-body p-4">
                                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-light-success rounded-circle p-3 me-3">
                                                <i class="fas fa-cogs fa-2x text-success"></i>
                                            </div>
                                            <div>
                                                <h4 class="mb-1"><?php echo e(__('translations.config_cache')); ?></h4>
                                                <p class="text-muted mb-0"><?php echo e(__('translations.system_configurations')); ?></p>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('admin.settings.cache.clear-config')); ?>" class="btn btn-success mt-3 mt-md-0">
                                            <i class="fas fa-broom me-1"></i><?php echo e(__('translations.clear_config_cache')); ?>

                                        </a>
                                    </div>
                                    <div class="alert alert-light-success mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <?php echo e(__('translations.config_cache_description')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Route Cache -->
                        <div class="col-xl-6 col-lg-6 col-md-12">
                            <div class="card shadow-sm border rounded-4">
                                <div class="card-body p-4">
                                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-light-warning rounded-circle p-3 me-3">
                                                <i class="fas fa-route fa-2x text-warning"></i>
                                            </div>
                                            <div>
                                                <h4 class="mb-1"><?php echo e(__('translations.route_cache')); ?></h4>
                                                <p class="text-muted mb-0"><?php echo e(__('translations.application_routes')); ?></p>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('admin.settings.cache.clear-route')); ?>" class="btn btn-warning mt-3 mt-md-0">
                                            <i class="fas fa-broom me-1"></i><?php echo e(__('translations.clear_route_cache')); ?>

                                        </a>
                                    </div>
                                    <div class="alert alert-light-warning mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <?php echo e(__('translations.route_cache_description')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Log Files -->
                        <div class="col-xl-6 col-lg-6 col-md-12">
                            <div class="card shadow-sm border rounded-4">
                                <div class="card-body p-4">
                                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-light-danger rounded-circle p-3 me-3">
                                                <i class="fas fa-file-alt fa-2x text-danger"></i>
                                            </div>
                                            <div>
                                                <h4 class="mb-1"><?php echo e(__('translations.log_files')); ?></h4>
                                                <p class="text-muted mb-0"><?php echo e(__('translations.current_size')); ?>: <span class="fw-bold"><?php echo e($logsSize); ?></span></p>
                                            </div>
                                        </div>
                                        <a href="<?php echo e(route('admin.settings.cache.clear-logs')); ?>" class="btn btn-danger mt-3 mt-md-0" onclick="return confirm('<?php echo e(__('translations.are_you_sure_clear_logs')); ?>');">
                                            <i class="fas fa-trash me-1"></i><?php echo e(__('translations.clear_logs')); ?>

                                        </a>
                                    </div>
                                    <div class="alert alert-light-danger mb-0">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <?php echo e(__('translations.logs_description')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-header border-0 bg-light">
                    <div class="card-title m-0">
                        <h3 class="fw-bold m-0"><?php echo e(__('translations.cache_instructions')); ?></h3>
                    </div>
                </div>
                <div class="card-body p-4">
                    <div class="alert alert-info">
                        <h5 class="alert-heading"><?php echo e(__('translations.when_to_clear_cache')); ?></h5>
                        <hr>
                        <p><?php echo e(__('translations.cache_explanation_1')); ?></p>
                        <p><?php echo e(__('translations.cache_explanation_2')); ?></p>
                        <ul>
                            <li><?php echo e(__('translations.cache_instruction_1')); ?></li>
                            <li><?php echo e(__('translations.cache_instruction_2')); ?></li>
                            <li><?php echo e(__('translations.cache_instruction_3')); ?></li>
                            <li><?php echo e(__('translations.cache_instruction_4')); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Icon box styling */
    .icon-box {
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.4s ease;
        border: 2px solid rgba(255, 255, 255, 0.5);
    }

    /* Card hover effect */
    .rounded-4 {
        border-radius: 0.75rem !important;
    }

    .card {
        transition: all 0.3s ease;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
    }

    /* Alert styling */
    .alert-light-primary {
        background-color: rgba(0, 123, 255, 0.1);
        color: #0d6efd;
        border: none;
    }

    .alert-light-info {
        background-color: rgba(13, 202, 240, 0.1);
        color: #0dcaf0;
        border: none;
    }

    .alert-light-success {
        background-color: rgba(25, 135, 84, 0.1);
        color: #198754;
        border: none;
    }

    .alert-light-warning {
        background-color: rgba(255, 193, 7, 0.1);
        color: #ffc107;
        border: none;
    }

    .alert-light-danger {
        background-color: rgba(220, 53, 69, 0.1);
        color: #dc3545;
        border: none;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/settings/cache.blade.php ENDPATH**/ ?>