<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.client-details')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.client-profile')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <!-- Client Information Card -->
                    <div class="col-12 mb-5">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0"><?php echo e(__('translations.client-information')); ?></h3>
                                </div>
                                <div class="card-toolbar">
                                    <a href="<?php echo e(route('admin.clients.edit', $client->id)); ?>" class="btn btn-sm btn-primary">
                                        <?php echo e(__('translations.edit')); ?>

                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th><?php echo e(__('translations.full-name')); ?>:</th>
                                                <td><?php echo e($client->first_name); ?> <?php echo e($client->last_name); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(__('translations.age')); ?>:</th>
                                                <td><?php echo e($client->age); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(__('translations.gender')); ?>:</th>
                                                <td><?php echo e($client->gender); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th><?php echo e(__('translations.phone')); ?>:</th>
                                                <td><?php echo e($client->full_phone_number); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(__('translations.address')); ?>:</th>
                                                <td><?php echo e($client->address); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo e(__('translations.city')); ?> / <?php echo e(__('translations.region')); ?>:</th>
                                                <td><?php echo e($client->city->name ?? ''); ?> <?php echo e($client->region->name ? '- ' . $client->region->name : ''); ?></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Examinations List Card -->
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0"><?php echo e(__('translations.examinations-list')); ?></h3>
                                </div>
                                <div class="card-toolbar">
                                    <?php if (app('laratrust')->hasPermission('examinations-create')) : ?>
                                    <a href="<?php echo e(route('admin.examinations.create', ['client_id' => $client->id])); ?>" class="btn btn-sm btn-primary">
                                        <?php echo e(__('translations.add-examination')); ?>

                                    </a>
                                    <?php endif; // app('laratrust')->permission ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center position-relative mb-4">
                                    <span class="svg-icon svg-icon-1 position-absolute ms-4">
                                        <svg width="18" height="18" viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                                        </svg>
                                    </span>
                                    <input type="text" data-kt-filter="search"
                                        class="form-control form-control-solid w-250px ps-14"
                                        placeholder="<?php echo e(__('translations.examinations-search')); ?>" />
                                </div>
                                <table id="kt_datatable_example"
                                    class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                                    <thead>
                                        <tr class="fw-bolder fs-8 text-uppercase gs-0">
                                            <th><?php echo e(__('translations.Examination Code')); ?></th>
                                            <th><?php echo e(__('translations.Note')); ?></th>
                                            <th><?php echo e(__('translations.type')); ?></th>
                                            <th><?php echo e(__('translations.Date')); ?></th>
                                            <th><?php echo e(__('translations.actions')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-800 fw-bold" id="examinations-body">
                                        <?php $__currentLoopData = $examinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $examination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($examination->code); ?></td>
                                                <td><?php echo \Illuminate\Support\Str::limit($examination->notes, 100, '...'); ?></td>
                                                <td><?php echo e($examination->type); ?></td>
                                                <td><?php echo e($examination->created_at); ?></td>

                                                <td>
                                                    <a href="#" class="btn btn-light btn-active-light-primary btn-sm"
                                                        data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end"
                                                        data-kt-menu-flip="top-end">
                                                        <?php echo e(__('translations.actions')); ?>

                                                        <span class="svg-icon svg-icon-5 m-0">
                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                                                height="24px" viewBox="0 0 24 24" version="1.1">
                                                                <g stroke="none" stroke-width="1" fill="none"
                                                                    fill-rule="evenodd">
                                                                    <polygon points="0 0 24 0 24 24 0 24"></polygon>
                                                                    <path
                                                                        d="M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z"
                                                                        fill="#000000" fill-rule="nonzero"
                                                                        transform="translate(12.000003, 11.999999) rotate(-180.000000) translate(-12.000003, -11.999999)">
                                                                    </path>
                                                                </g>
                                                            </svg>
                                                        </span>
                                                    </a>
                                                    <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold fs-7 w-125px py-4"
                                                        data-kt-menu="true">
                                                        <div class="menu-item px-3">


                                                            <?php if (app('laratrust')->hasPermission('receptions-show')) : ?>
                                                                <a href="<?php echo e(route('admin.receptions.show', $examination->id)); ?>"
                                                                    class="menu-link px-3">
                                                                    <?php echo e(__('translations.show')); ?>

                                                                </a>
                                                            <?php endif; // app('laratrust')->permission ?>

                                                          
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/clients/show.blade.php ENDPATH**/ ?>