<?php $__env->startSection('title'); ?><?php echo e(__('translations.loginmsg')); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column flex-root">
  <div class="login-container">
    <div class="d-flex flex-center flex-column flex-column-fluid p-2 p-md-10">
      <div class="login-card">
        <div class="login-logo mb-4">
          <?php if($setting->logo): ?>
            <img alt="Logo" src="<?php echo e(asset('uploads/'.$setting->logo)); ?>" class="logo-img d-block" style="width: 100px!important;" />
          <?php else: ?>
          <img alt="Logo" src="<?php echo e(asset('logo.png')); ?>" class="logo-img d-block" style="width: 100px!important;" />
      <?php endif; ?>
        </div>

        <div class="login-card-body">
          <form class="form w-100" action="<?php echo e(route('admin.login.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="text-center mb-8">
              <h1 class="login-title">تسجيل الدخول</h1>
              <p class="text-muted">أدخل بيانات الدخول للوصول إلى لوحة التحكم</p>
            </div>

            <div class="form-group mb-6">
              <label class="form-label fw-bold">البريد الإلكتروني</label>
              <div class="input-group">
                <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                <input class="form-control" type="email" name="email" placeholder="أدخل البريد الإلكتروني" value="<?php echo e(old('email')); ?>"/>
              </div>
              <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block mt-1"><strong><?php echo e($message); ?></strong></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group mb-6">
              <div class="d-flex justify-content-between align-items-center mb-2">
                <label class="form-label fw-bold mb-0">كلمة المرور</label>
              </div>
              <div class="input-group">
                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                <input class="form-control" type="password" name="password" placeholder="أدخل كلمة المرور"/>
              </div>
              <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block mt-1"><strong><?php echo e($message); ?></strong></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-check mb-6">
              <input class="form-check-input" type="checkbox" name="remember" id="remember">
              <label class="form-check-label" for="remember">تذكرني</label>
            </div>

            <div class="text-center">
              <button type="submit" class="btn btn-primary btn-lg w-100">
                <span class="indicator-label">تسجيل الدخول</span>
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
  .login-container {
    min-height: 100vh;
    background: linear-gradient(135deg, #3a7bd5, #00d2ff);
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .login-card {
    width: 100%;
    max-width: 450px;
    background-color: rgba(255, 255, 255, 0.95);
    border-radius: 15px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    padding: 0;
    margin: 20px;
  }

  .login-logo {
    display: flex;
    justify-content: center;
    padding-top: 2rem;
  }

  .login-card-body {
    padding: 2.5rem;
  }

  .login-title {
    font-size: 1.8rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 0.5rem;
  }

  .input-group-text {
    background-color: #f8f9fa;
    border-left: none;
  }

  .form-control {
    border-radius: 8px;
    padding: 12px 20px;
    border: 1px solid #e2e5ec;
    transition: all 0.3s ease;
  }

  .form-control:focus {
    box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.15);
    border-color: #3a7bd5;
  }

  .btn-primary {
    background: linear-gradient(135deg, #3a7bd5, #00d2ff);
    border: none;
    border-radius: 8px;
    padding: 12px 20px;
    font-weight: 600;
    transition: all 0.3s ease;
  }

  .btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
  }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.subsidiary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>