<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'en' ? 'ltr' : 'rtl'); ?>">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo e($setting->name); ?> - <?php echo $__env->yieldContent('title'); ?></title>

  <!-- Theme CSS Variables -->
  <style>
    <?php echo $themeCssVariables; ?>

    /* Dark mode settings */
    <?php if($theme->is_dark_mode): ?>
    body {
      background-color: #1a1a1a;
      color: #e0e0e0;
    }
    .card {
      background-color: #2a2a2a;
      border-color: #444;
    }
    .form-control, .form-select {
      background-color: #333;
      border-color: #444;
      color: #e0e0e0;
    }
    .form-control:focus, .form-select:focus {
      background-color: #3a3a3a;
    }
    .table {
      color: #e0e0e0;
    }
    .table td, .table th {
      border-color: #444;
    }
    .modal-content {
      background-color: #2a2a2a;
      border-color: #444;
    }
    .bg-light {
      background-color: #2a2a2a !important;
    }
    .text-dark {
      color: #e0e0e0 !important;
    }
    <?php endif; ?>

    body, input, button, select, textarea {
      font-family: var(--font-family);
      font-size: var(--base-font-size);
    }
    h1, h2, h3, h4, h5, h6 {
      font-family: var(--font-family);
      font-size: var(--heading-font-size);
    }
    .menu-item, .menu-link {
      font-family: var(--font-family);
      font-size: var(--menu-font-size);
    }
    /* Apply theme colors */
    .btn-primary {
      background-color: var(--primary-color);
      border-color: var(--primary-color);
    }
    .btn-secondary {
      background-color: var(--secondary-color);
      border-color: var(--secondary-color);
    }
    a {
      color: var(--link-color);
    }
    .text-primary {
      color: var(--primary-color) !important;
    }
    .bg-primary {
      background-color: var(--primary-color) !important;
    }
    .border-primary {
      border-color: var(--primary-color) !important;
    }
  </style>

  <!-- styles section -->
  <?php echo $__env->make('admin.layouts.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->make('admin.layouts.dynamic-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body id="kt_body" class="header-tablet-and-mobile-fixed <?php echo e($asideEnabled ?? true ? 'aside-enabled' : ''); ?>">
  <!-- loader section -->
  <div class="overlay-loader">
    <div class="loader">
      <div></div>
      <div></div>
      <div></div>
      <div></div>
    </div>
  </div>



  <div class="d-flex flex-column flex-root">
    <div class="page d-flex flex-row flex-column-fluid">
      <!-- aside section -->
      <?php echo $__env->make('admin.layouts.aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
        <!-- header section -->
        <?php echo $__env->make('admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- content section -->
        <?php echo $__env->yieldContent('content'); ?>
      </div>
    </div>
  </div>

  <!-- footer section -->
  <?php echo $__env->make('admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- scripts section -->
  <?php echo $__env->make('admin.layouts.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/layouts/main.blade.php ENDPATH**/ ?>