<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.products-list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.products')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0"><?php echo e(__('translations.products-list')); ?></h3>
                                </div>
                                <div class="card-toolbar">
                                    <?php if (app('laratrust')->hasPermission('products-create')) : ?>
                                        <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary">
                                            <span class="svg-icon svg-icon-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                    viewBox="0 0 24 24" fill="none">
                                                    <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2"
                                                        rx="1" transform="rotate(-90 11.364 20.364)" fill="white"
                                                        stroke="white" stroke-width="3"></rect>
                                                    <rect x="4.36396" y="11.364" width="16" height="2" rx="1"
                                                        fill="white" stroke="white" stroke-width="3"></rect>
                                                </svg>
                                            </span>
                                            <span><?php echo e(__('translations.products-create')); ?></span>
                                        </a>
                                    <?php endif; // app('laratrust')->permission ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center position-relative mb-4">
                                    <span class="svg-icon svg-icon-1 position-absolute ms-4">
                                        <svg width="18" height="18" viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M15.5 14h-.79l-.28-.27A6.471 6.471 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14z" />
                                        </svg>
                                    </span>
                                    <input type="text" data-kt-filter="search"
                                        class="form-control form-control-solid w-250px ps-14"
                                        placeholder="<?php echo e(__('translations.categories-search')); ?>" />
                                </div>
                                <table id="kt_datatable_example"
                                    class="table align-middle table-row-dashed fs-6 gy-5 custom-table d-table">
                                    <thead>
                                        <tr class="fw-bolder fs-8 text-uppercase gs-0">
                                            <th><?php echo e(__('translations.products-name')); ?></th>
                                            <th><?php echo e(__('translations.products-price')); ?></th>
                                            <th><?php echo e(__('translations.products-description')); ?></th>
                                            <th><?php echo e(__('translations.products-category')); ?></th>
                                            <th><?php echo e(__('translations.actions')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="text-gray-800 fw-bold">
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <img src="<?php echo e(asset('uploads/' . $product->image)); ?>"
                                                            alt="<?php echo e($product->name); ?>" class="img-fluid img-thumbnail"
                                                            style="width: 50px; height: 50px; border-radius: 50%;">
                                                        <div class="ms-3">
                                                            <div class="fw-bolder"><?php echo e($product->name); ?></div>
                                                            <div class="text-gray-600"><?php echo e($product->price); ?> <?php echo e(__('translations.currency')); ?></div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo e($product->price); ?> <?php echo e(__('translations.currency')); ?></td>
                                                <td><?php echo e($product->description); ?></td>
                                                <td><?php echo e($product->category->name); ?></td>
                                                <td>
                                                    <button class="btn btn-light btn-sm dropdown-toggle" type="button"
                                                        id="dropdownMenuButton" data-bs-toggle="dropdown"
                                                        aria-expanded="false">
                                                        <?php echo e(__('translations.actions')); ?>

                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php if (app('laratrust')->hasPermission('products-show')) : ?>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('admin.products.show', $product->id)); ?>">
                                                                <?php echo e(__('translations.show')); ?>

                                                            </a>
                                                        <?php endif; // app('laratrust')->permission ?>
                                                        <?php if (app('laratrust')->hasPermission('products-edit')) : ?>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('admin.products.edit', $product->id)); ?>">
                                                                <?php echo e(__('translations.edit')); ?>

                                                            </a>
                                                        <?php endif; // app('laratrust')->permission ?>
                                                        <?php if (app('laratrust')->hasPermission('products-delete')) : ?>
                                                            <a class="dropdown-item" href="#"
                                                                onclick="event.preventDefault();
                                    if(confirm('هل أنت متأكد من عملية الحذف ؟')) {
                                    document.getElementById('delete-form-<?php echo e($product->id); ?>').submit();
                                    }">
                                                                <?php echo e(__('translations.delete')); ?>

                                                            </a>
                                                        <?php endif; // app('laratrust')->permission ?>
                                                        <form id="delete-form-<?php echo e($product->id); ?>"
                                                            action="<?php echo e(route('admin.products.destroy', $product->id)); ?>"
                                                            method="post" style="display: none;">
                                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/products/index.blade.php ENDPATH**/ ?>